/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class Log {
    public static final long TIME_ZERO_NANO = System.nanoTime();
    public static final long TIME_ZERO_MILLI = System.currentTimeMillis();
    private final boolean enabled;
    private final String name;
    private static final String NAME_WHITESPACE = "                  ";
    private static final String ERROR_NAME = "ERROR";
    private static final boolean any;
    private static boolean teeErrors;
    private static boolean stacks;
    private static String stackFilter;
    private static Set<String> names;
    private static int longestNameLength;
    private static Map<Class, Formatter> formatters;
    private static Logger logger;
    private static Formatter DEFAULT_FORMATTER;
    private static AtomicInteger lastTag;
    private static char[] tagBuffer;
    private static char[] timeBuffer;

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(String message, Object p1) {
        Log.error(message, new Object[]{p1});
    }

    public static void error(String message, Object p1, Object p2) {
        Log.error(message, new Object[]{p1, p2});
    }

    public static void error(String message, Object p1, Object p2, Object p3) {
        Log.error(message, new Object[]{p1, p2, p3});
    }

    public static void error(String message, Object p1, Object p2, Object p3, Object p4) {
        Log.error(message, new Object[]{p1, p2, p3, p4});
    }

    public static void error(String message, Object p1, Object p2, Object p3, Object p4, Object p5) {
        Log.error(message, new Object[]{p1, p2, p3, p4, p5});
    }

    public static void error(String message, Object[] parameters) {
        Log.printerror(message, parameters);
    }

    public Log(String name) {
        if (any) {
            if (names.contains(name)) {
                this.enabled = true;
                this.name = name;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String name1, String name2) {
        if (any) {
            if (names.contains(name1)) {
                this.enabled = true;
                this.name = name1;
            } else if (names.contains(name2)) {
                this.enabled = true;
                this.name = name2;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String name1, String name2, String name3) {
        if (any) {
            if (names.contains(name1)) {
                this.enabled = true;
                this.name = name1;
            } else if (names.contains(name2)) {
                this.enabled = true;
                this.name = name2;
            } else if (names.contains(name3)) {
                this.enabled = true;
                this.name = name3;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String[] names) {
        boolean enabled = false;
        String name = null;
        if (any) {
            for (String logName : names) {
                if (!Log.names.contains(logName)) continue;
                enabled = true;
                name = logName;
                break;
            }
        }
        this.enabled = enabled;
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public boolean trace(String message) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, null);
        return true;
    }

    public boolean trace(String message, Object p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, int p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, long p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, boolean p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, int p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, int p1, int p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, long p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, boolean p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, boolean p1, boolean p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3, int p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4, p5});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4, p5});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4, p5});
        return true;
    }

    public boolean trace(String message, Object ... parameters) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, parameters);
        return true;
    }

    public static void addFormatter(Class type, Formatter formatter) {
        formatters.put(type, formatter != null ? formatter : DEFAULT_FORMATTER);
    }

    public static String format(String message, Object[] arguments) {
        StringBuffer buffer = new StringBuffer();
        Log.append(buffer, message, arguments);
        return buffer.toString();
    }

    public static void append(StringBuffer buffer, String message, Object[] arguments) {
        int length = message.length();
        char[] chars = new char[length + 1];
        message.getChars(0, length, chars, 0);
        chars[length] = '\u0000';
        int i = 0;
        while (true) {
            char c;
            int index;
            char c2;
            int i0 = i;
            do {
                if ((c2 = chars[i++]) != '\u0000') continue;
                buffer.append(chars, i0, i - i0 - 1);
                return;
            } while (c2 != '{' || (index = Character.digit(chars[i], 10)) < 0);
            buffer.append(chars, i0, i - i0 - 1);
            Object argument = index < arguments.length ? arguments[index] : "?";
            Log.append(buffer, argument);
            do {
                int n = ++i;
                ++i;
                c = chars[n];
                if (c != '\u0000') continue;
                buffer.append('?');
                return;
            } while (c != '}');
        }
    }

    public static StringBuffer append(StringBuffer buffer, Object object) {
        Formatter formatter = Log.getFormatter(object);
        try {
            formatter.append(buffer, object);
        }
        catch (Throwable t) {
            buffer.append('<').append(t).append('>');
        }
        return buffer;
    }

    public static Formatter getFormatter(Object object) {
        if (object == null) {
            return DEFAULT_FORMATTER;
        }
        return Log.getFormatter(object.getClass());
    }

    public static Formatter getFormatter(Class objectType) {
        Formatter formatter;
        block2: {
            formatter = formatters.get(objectType);
            if (formatter != null) break block2;
            Class type = objectType;
            do {
                for (Class<?> implementedType : type.getInterfaces()) {
                    formatter = formatters.get(implementedType);
                    if (formatter == null) continue;
                    formatters.put(objectType, formatter);
                    break block2;
                }
                if ((type = type.getSuperclass()) != null) continue;
                formatter = DEFAULT_FORMATTER;
                break block2;
            } while ((formatter = formatters.get(type)) == null);
            formatters.put(objectType, formatter);
        }
        return formatter;
    }

    private static void printerror(String message, Object[] parameters) {
        if (logger != null && !logger.isDisabled()) {
            Throwable stack;
            Throwable throwable = stack = stacks ? new Throwable() : null;
            if (teeErrors) {
                Log.print(System.err, ERROR_NAME, lastTag.getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters, stack);
            }
            logger.add(ERROR_NAME, message, parameters, null);
        } else {
            Log.print(System.err, ERROR_NAME, lastTag.getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters, null);
        }
    }

    private static void trace(String name, String message, Object[] parameters) {
        if (stacks) {
            logger.add(name, message, parameters, new Throwable());
        } else {
            logger.add(name, message, parameters, null);
        }
    }

    private static PrintStream getStream(String destination) {
        PrintStream stream;
        if (destination.equalsIgnoreCase("error")) {
            stream = System.err;
            System.err.println("____LOG: tracing enabled to standard error");
        } else if (destination.equalsIgnoreCase("output")) {
            stream = System.out;
            System.err.println("____LOG: tracing enabled to standard output");
        } else {
            String directory;
            File file = new File(destination);
            if (!(file.isAbsolute() || file.getPath().charAt(0) == '\\' || (directory = System.getProperty("ide.startingcwd")) == null || directory.isEmpty() || "".equals(directory))) {
                if (directory.startsWith("\"") && directory.endsWith("\"")) {
                    directory = directory.substring(1, directory.length() - 1);
                }
                file = new File(new File(directory), destination);
            }
            try {
                stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                System.err.println("____LOG: tracing enabled to " + file.getAbsolutePath());
            }
            catch (IOException e) {
                stream = null;
                System.err.println("____LOG: tracing aborted: file " + file.getAbsolutePath() + " not created:");
                e.printStackTrace(System.err);
            }
        }
        return stream;
    }

    private static void writeTag(PrintStream stream, int tag) {
        int i = tagBuffer.length;
        while (tag > 0 && i > 0) {
            Log.tagBuffer[--i] = (char)(48 + tag % 10);
            tag /= 10;
        }
        stream.print(tagBuffer);
    }

    public static String formatNow() {
        return Log.formatTime(System.nanoTime());
    }

    public static String formatTime(long nanoTime) {
        return Log.formatTranslatedTime(nanoTime - TIME_ZERO_NANO);
    }

    public static String formatTranslatedTime(long nanoTime) {
        char[] timeBuffer = Log.createTimeBuffer();
        Log.fillTranslatedTime(nanoTime, timeBuffer);
        return new String(timeBuffer);
    }

    public static StringBuffer appendNow(StringBuffer buffer) {
        return Log.appendTime(buffer, System.nanoTime());
    }

    public static StringBuffer appendTime(StringBuffer buffer, long nanoTime) {
        return Log.appendTranslatedTime(buffer, nanoTime - TIME_ZERO_NANO);
    }

    public static StringBuffer appendTranslatedTime(StringBuffer buffer, long nanoTime) {
        char[] timeBuffer = Log.createTimeBuffer();
        Log.fillTranslatedTime(nanoTime, timeBuffer);
        buffer.append(timeBuffer);
        return buffer;
    }

    private static char[] createTimeBuffer() {
        return new char[]{' ', ' ', '0', '.', '0', '0', '0', ',', '0', '0', '0'};
    }

    private static void fillTranslatedTime(long time, char[] timeBuffer) {
        timeBuffer[10] = (char)(48L + (time /= 1000L) % 10L);
        if ((time /= 10L) > 0L) {
            timeBuffer[9] = (char)(48L + time % 10L);
            if ((time /= 10L) > 0L) {
                timeBuffer[8] = (char)(48L + time % 10L);
                if ((time /= 10L) > 0L) {
                    timeBuffer[7] = 44;
                    timeBuffer[6] = (char)(48L + time % 10L);
                    if ((time /= 10L) > 0L) {
                        timeBuffer[5] = (char)(48L + time % 10L);
                        if ((time /= 10L) > 0L) {
                            timeBuffer[4] = (char)(48L + time % 10L);
                            if ((time /= 10L) > 0L) {
                                timeBuffer[3] = 46;
                                timeBuffer[2] = (char)(48L + time % 10L);
                                if ((time /= 10L) > 0L) {
                                    timeBuffer[1] = (char)(48L + time % 10L);
                                    if ((time /= 10L) > 0L) {
                                        timeBuffer[0] = (char)(48L + time % 10L);
                                        if ((time /= 10L) <= 0L) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(PrintStream stream, String name, int tag, long time, String thread, String message, Object[] parameters, Throwable stack) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            int i;
            stream.print("____LOG ");
            stream.print(name);
            int nameLength = name.length();
            if (nameLength < longestNameLength) {
                for (int i2 = nameLength; i2 < longestNameLength; ++i2) {
                    stream.print(' ');
                }
            }
            stream.print(' ');
            Log.writeTag(stream, tag);
            stream.print(": ");
            Log.fillTranslatedTime(time - TIME_ZERO_NANO, timeBuffer);
            stream.print(timeBuffer);
            stream.print(" [");
            int threadLength = thread.length();
            int LIMIT = 16;
            if (threadLength <= 16) {
                stream.print(thread);
                stream.print("] ");
                for (i = threadLength; i < 16; ++i) {
                    stream.print(' ');
                }
            } else {
                for (i = 0; i < 7; ++i) {
                    stream.print(thread.charAt(i));
                }
                stream.print('*');
                for (i = threadLength - 8; i < 16; ++i) {
                    stream.print(thread.charAt(i));
                }
                stream.print("] ");
            }
            if (parameters == null || parameters.length == 0) {
                stream.println(message);
            } else {
                StringBuffer buffer = new StringBuffer();
                Log.append(buffer, message, parameters);
                stream.println(buffer.toString());
                Object lastParameter = parameters[parameters.length - 1];
                if (lastParameter instanceof Throwable) {
                    Log.printStackTrace((Throwable)lastParameter, stream);
                }
            }
            if (stack != null) {
                String className;
                int i3;
                StackTraceElement[] trace = stack.getStackTrace();
                for (i3 = 0; i3 < trace.length && Log.class.getName().equals(trace[i3].getClassName()); ++i3) {
                }
                while (!(i3 >= trace.length || (className = trace[i3].getClassName()) != null && className.startsWith(stackFilter))) {
                    stream.print("\tat ");
                    stream.println(trace[i3++]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(Throwable e, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            StackTraceElement[] trace;
            for (StackTraceElement element : trace = e.getStackTrace()) {
                stream.println("\tat " + element);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                Log.printStackTraceAsCause(cause, stream, trace);
            }
        }
    }

    private static void printStackTraceAsCause(Throwable e, PrintStream stream, StackTraceElement[] causedTrace) {
        Throwable cause;
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        stream.println("Caused by: " + e);
        for (int i = 0; i <= m; ++i) {
            stream.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            stream.println("\t... " + framesInCommon + " more");
        }
        if ((cause = e.getCause()) != null) {
            Log.printStackTraceAsCause(cause, stream, trace);
        }
    }

    static {
        stackFilter = "";
        longestNameLength = ERROR_NAME.length();
        formatters = new HashMap<Class, Formatter>();
        lastTag = new AtomicInteger();
        DEFAULT_FORMATTER = new DefaultFormatter();
        formatters.put(Object.class, DEFAULT_FORMATTER);
        formatters.put(boolean[].class, new BooleanArrayFormatter());
        formatters.put(byte[].class, new ByteArrayFormatter());
        formatters.put(char[].class, new CharArrayFormatter());
        formatters.put(short[].class, new ShortArrayFormatter());
        formatters.put(int[].class, new IntArrayFormatter());
        formatters.put(long[].class, new LongArrayFormatter());
        formatters.put(float[].class, new FloatArrayFormatter());
        formatters.put(double[].class, new DoubleArrayFormatter());
        formatters.put(AWTEvent.class, new AWTEventFormatter());
        formatters.put(InputEvent.class, new InputEventFormatter());
        formatters.put(ActionEvent.class, new ActionEventFormatter());
        String property = System.getProperty("javatools.trace");
        if (property == null) {
            property = System.getProperty("audit.trace");
        }
        if (property != null) {
            int end;
            ArrayList<String> tokens = new ArrayList<String>();
            int start = 0;
            while ((end = property.indexOf(44, start)) >= 0) {
                tokens.add(property.substring(start, end));
                start = end + 1;
            }
            tokens.add(property.substring(start));
            if (!tokens.isEmpty()) {
                boolean asynchronous = false;
                boolean synchronous = false;
                any = true;
                names = new HashSet<String>();
                String destination = "error";
                block7: for (String name : tokens) {
                    int length;
                    if (name.length() == 0) continue;
                    switch (name.charAt(0)) {
                        case '!': 
                        case '#': {
                            name = name.substring(1).trim();
                            if (name.equals("asynchronous")) {
                                asynchronous = true;
                                continue block7;
                            }
                            if (name.equals("synchronous")) {
                                synchronous = true;
                                continue block7;
                            }
                            if (name.startsWith("stack")) {
                                int index;
                                length = name.length();
                                if (length == (index = "stack".length())) {
                                    stacks = true;
                                    continue block7;
                                }
                                if (name.charAt(index) == 's') {
                                    ++index;
                                }
                                if (length == index) {
                                    stacks = true;
                                    continue block7;
                                }
                                switch (name.charAt(index)) {
                                    case ':': 
                                    case ';': {
                                        stackFilter = name.substring(++index);
                                        stacks = true;
                                    }
                                }
                                continue block7;
                            }
                            destination = name;
                            teeErrors = !"error".equalsIgnoreCase(destination);
                            continue block7;
                        }
                    }
                    length = Math.min(NAME_WHITESPACE.length(), name.length());
                    if (length > longestNameLength) {
                        longestNameLength = length;
                    }
                    names.add(name);
                }
                logger = synchronous ? new SynchronousLogger(destination) : (asynchronous ? new AsynchronousLogger(destination, true) : new AsynchronousLogger(destination, false));
            } else {
                any = false;
            }
        } else {
            any = false;
        }
        tagBuffer = new char[]{' ', ' ', ' ', '0'};
        timeBuffer = Log.createTimeBuffer();
    }

    private static class ActionEventFormatter
    implements Formatter {
        private ActionEventFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("[when ");
            ActionEvent event = (ActionEvent)object;
            buffer.append(event.getWhen() - TIME_ZERO_MILLI);
            buffer.append("] ");
            buffer.append(event.paramString());
            buffer.append('}');
        }
    }

    private static class InputEventFormatter
    implements Formatter {
        private InputEventFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("[when ");
            InputEvent event = (InputEvent)object;
            buffer.append(event.getWhen() - TIME_ZERO_NANO);
            buffer.append("] ");
            buffer.append(event.paramString());
            buffer.append('}');
        }
    }

    private static class AWTEventFormatter
    implements Formatter {
        private AWTEventFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            AWTEvent event = (AWTEvent)object;
            buffer.append(event.paramString());
            buffer.append('}');
        }
    }

    private static class DoubleArrayFormatter
    implements Formatter {
        private DoubleArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            double[] array = (double[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class FloatArrayFormatter
    implements Formatter {
        private FloatArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            float[] array = (float[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class LongArrayFormatter
    implements Formatter {
        private LongArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            long[] array = (long[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class IntArrayFormatter
    implements Formatter {
        private IntArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            int[] array = (int[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class ShortArrayFormatter
    implements Formatter {
        private ShortArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            short[] array = (short[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class CharArrayFormatter
    implements Formatter {
        private CharArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('\"');
            block9: for (char c : (char[])object) {
                switch (c) {
                    case '\b': {
                        buffer.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        buffer.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        continue block9;
                    }
                    case '\"': {
                        buffer.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        buffer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' || c < '\u007f') {
                            buffer.append(c);
                            continue block9;
                        }
                        buffer.append("\\u");
                        String digits = Integer.toHexString(c);
                        for (int j = digits.length(); j < 4; ++j) {
                            buffer.append('0');
                        }
                        buffer.append(digits);
                    }
                }
            }
            buffer.append('\"');
        }
    }

    private static class ByteArrayFormatter
    implements Formatter {
        private ByteArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            byte[] array = (byte[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class BooleanArrayFormatter
    implements Formatter {
        private BooleanArrayFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            boolean[] array = (boolean[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            for (int i = 1; i < array.length; ++i) {
                buffer.append(", ");
                buffer.append(array[i]);
            }
            buffer.append('}');
        }
    }

    private static class DefaultFormatter
    implements Formatter {
        private DefaultFormatter() {
        }

        @Override
        public void append(StringBuffer buffer, Object object) {
            if (object == null) {
                buffer.append("null");
            } else {
                Class<?> type = object.getClass();
                if (!type.isArray()) {
                    buffer.append(object);
                } else {
                    Class<?> componentType = type.getComponentType();
                    buffer.append(componentType.getName());
                    buffer.append("[]{");
                    Object[] array = (Object[])object;
                    if (array.length > 0) {
                        Log.append(buffer, array[0]);
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            Log.append(buffer, array[i]);
                        }
                    }
                    buffer.append("}");
                }
            }
        }
    }

    private static class AsynchronousLogger
    implements Logger,
    Runnable {
        private String destination;
        private final boolean deferredParameters;
        private final BlockingQueue<Trace> queue;
        private Thread thread;
        private volatile boolean stopped;
        private volatile boolean disabled;

        public AsynchronousLogger(String destination, boolean deferredParameters) {
            this.destination = destination;
            this.deferredParameters = deferredParameters;
            this.queue = new ArrayBlockingQueue<Trace>(512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(String name, String message, Object[] parameters, Throwable stack) {
            if (this.disabled) {
                return;
            }
            int tag = lastTag.getAndIncrement();
            long time = System.nanoTime();
            if (!this.deferredParameters && parameters != null && parameters.length > 0) {
                Object[] evaluated = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    evaluated[i] = parameters[i] instanceof Throwable ? parameters[i] : Log.append(new StringBuffer(), parameters[i]);
                }
                parameters = evaluated;
            }
            Trace trace = new Trace(name, tag, time, Thread.currentThread().getName(), message, parameters, stack);
            BlockingQueue<Trace> i = this.queue;
            synchronized (i) {
                if (this.thread == null) {
                    this.thread = new Thread((Runnable)this, "Log");
                    this.thread.setPriority(1);
                    this.thread.start();
                }
            }
            try {
                this.queue.put(trace);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void run() {
            final PrintStream stream = Log.getStream(this.destination);
            this.destination = null;
            if (stream == null) {
                this.disabled = true;
                this.queue.clear();
                return;
            }
            try {
                Runtime.getRuntime().addShutdownHook(new Thread("LogShutdown"){

                    @Override
                    public void run() {
                        stream.flush();
                        AsynchronousLogger.this.stopped = true;
                        AsynchronousLogger.this.thread.interrupt();
                    }
                });
            }
            catch (IllegalStateException e) {
                this.stopped = true;
            }
            while (!this.stopped) {
                try {
                    Trace trace = this.queue.take();
                    Log.print(stream, trace.name, trace.tag, trace.time, trace.thread, trace.message, trace.parameters, trace.stack);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            for (Trace trace : this.queue) {
                Log.print(stream, trace.name, trace.tag, trace.time, trace.thread, trace.message, trace.parameters, trace.stack);
            }
            stream.close();
        }

        @Override
        public boolean isDisabled() {
            return this.disabled;
        }
    }

    private static class SynchronousLogger
    implements Logger {
        private final boolean disabled;
        private final PrintStream stream;

        public SynchronousLogger(String destination) {
            this.stream = Log.getStream(destination);
            boolean bl = this.disabled = this.stream == null;
            if (this.stream != null) {
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread("LogShutdown"){

                        @Override
                        public void run() {
                            SynchronousLogger.this.stream.flush();
                        }
                    });
                }
                catch (IllegalStateException e) {
                    this.stream.flush();
                }
            }
        }

        @Override
        public void add(String name, String message, Object[] parameters, Throwable stack) {
            if (this.disabled) {
                return;
            }
            Log.print(this.stream, name, lastTag.getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters, stack);
        }

        @Override
        public boolean isDisabled() {
            return this.stream != null;
        }
    }

    private static interface Logger {
        public void add(String var1, String var2, Object[] var3, Throwable var4);

        public boolean isDisabled();
    }

    private static class Trace {
        private String name;
        private int tag;
        private long time;
        private String thread;
        private String message;
        private Object[] parameters;
        private Throwable stack;

        public Trace(String name, int tag, long time, String thread, String message, Object[] parameters, Throwable stack) {
            this.name = name;
            this.tag = tag;
            this.time = time;
            this.thread = thread;
            this.message = message;
            this.parameters = parameters;
            this.stack = stack;
        }
    }

    public static interface Formatter {
        public void append(StringBuffer var1, Object var2);
    }
}

