/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util.deferred;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.javatools.util.ModelUtil;

public class DerivedCache<Key, Source, Target> {
    private ConcurrentMap<Key, CachedResource> _map = new ConcurrentHashMap<Key, CachedResource>();
    private Derive<Source, Target> derive;
    private Expire<Source, Target> expire;

    public DerivedCache(Derive<Source, Target> d) {
        this(d, new Expire<Source, Target>(){

            @Override
            public boolean expire(Source previous, Source current, Target target) {
                boolean areEqual = ModelUtil.areEqual(previous, current);
                return !areEqual;
            }
        });
    }

    public DerivedCache(Derive<Source, Target> d, Expire<Source, Target> e) {
        this.derive = d;
        this.expire = e;
    }

    public void updateSource(Key key, Source source) {
        CachedResource cr = this.getResource(key);
        cr.updateSource(source);
    }

    public Target getValue(Key key, Source source) throws InvocationTargetException {
        CachedResource cr = this.getResource(key);
        cr.updateSource(source);
        return cr.get();
    }

    public Target getValue(Key key) throws InvocationTargetException {
        CachedResource cr = this.getResource(key);
        return cr.get();
    }

    public void removeKey(Key key) {
        this._map.remove(key);
    }

    private CachedResource getResource(Key key) {
        CachedResource newCr;
        CachedResource cr = (CachedResource)this._map.get(key);
        if (cr == null && (cr = this._map.putIfAbsent(key, newCr = new CachedResource())) == null) {
            cr = newCr;
        }
        return cr;
    }

    private class CachedResource {
        private ReadWriteLock rwlock = new ReentrantReadWriteLock();
        private Source currentSource;
        private Target currentTarget;

        private CachedResource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSource(Source newSource) {
            this.rwlock.writeLock().lock();
            try {
                if (DerivedCache.this.expire.expire(this.currentSource, newSource, this.currentTarget)) {
                    this.currentSource = newSource;
                    this.currentTarget = null;
                }
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Target get() throws InvocationTargetException {
            this.rwlock.readLock().lock();
            try {
                Object target = this.currentTarget;
                if (target == null) {
                    this.rwlock.readLock().unlock();
                    this.rwlock.writeLock().lock();
                    try {
                        if (this.currentTarget == null) {
                            if (this.currentSource == null) {
                                throw new IllegalStateException("No source provided yet");
                            }
                            try {
                                this.currentTarget = DerivedCache.this.derive.derrive(this.currentSource);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        target = this.currentTarget;
                    }
                    finally {
                        this.rwlock.readLock().lock();
                        this.rwlock.writeLock().unlock();
                    }
                }
                Object Target2 = target;
                return Target2;
            }
            finally {
                this.rwlock.readLock().unlock();
            }
        }
    }

    public static interface Expire<Source, Target> {
        public boolean expire(Source var1, Source var2, Target var3);
    }

    public static interface Derive<Source, Target> {
        public Target derrive(Source var1) throws Exception;
    }
}

