/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.tint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.ceditor.tint.BlockStroke;
import oracle.ide.ceditor.tint.BlockType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class TintOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "TintOptions";
    public static final String NS_URL = "http://xmlns.oracle.com/ide/hash";
    public static final String ROOTQNAME = "block-color-preferences";
    private static final String TINT_ENABLED = "tintEnable";
    private static final String TINT_FIRSTTIME = "TintFirstTime";
    private static final String TINT_LIST = "TintList";
    private static final String KEY_IDENTIFIER = "KEY_IDENTIFIER";
    private static final String KEY_COLOR = "KEY_COLOR";
    private static final String KEY_STROKE = "KEY_STROKE";
    private static final String KEY_STROKE_COLOR = "KEY_STROKE_COLOR";

    private TintOptions(HashStructure hash) {
        super(hash);
    }

    public static TintOptions getInstance(PropertyStorage prefs) {
        return new TintOptions(TintOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean isEnabled() {
        return this._hash.getBoolean(TINT_ENABLED, false);
    }

    public void setEnabled(Boolean enabled) {
        this._hash.putBoolean(TINT_ENABLED, enabled.booleanValue());
    }

    public boolean isFirstTime(String id) {
        return this._hash.getBoolean("TintFirstTime:" + id, true);
    }

    public void setFirstTime(String id, Boolean firstTime) {
        this._hash.putBoolean("TintFirstTime:" + id, firstTime.booleanValue());
    }

    private String getScopedName(String provider) {
        return "TintList-" + provider;
    }

    public static List<BlockType> convertFromListStructure(ListStructure ls) {
        ArrayList<BlockType> list = new ArrayList<BlockType>();
        for (Object o : ls) {
            HashStructure blockHash = (HashStructure)o;
            String id = blockHash.getString(KEY_IDENTIFIER);
            Color color = blockHash.containsKey(KEY_COLOR) ? new Color(blockHash.getInt(KEY_COLOR)) : null;
            Color sColor = blockHash.containsKey(KEY_STROKE_COLOR) ? new Color(blockHash.getInt(KEY_STROKE_COLOR)) : null;
            BlockStroke stroke = BlockStroke.valueOf(blockHash.getString(KEY_STROKE));
            BlockType blockType = new BlockType(id, color, sColor, stroke);
            list.add(blockType);
        }
        return list;
    }

    public List<BlockType> getTintBlocks(String providerId) {
        return TintOptions.convertFromListStructure(this.getTintList(providerId));
    }

    public static ListStructure convertToListStructure(List<BlockType> blockList) {
        ListStructure ls = ListStructure.newInstance();
        for (BlockType blockType : blockList) {
            HashStructure blockHash = HashStructure.newInstance();
            blockHash.putString(KEY_IDENTIFIER, blockType.getIdentifier());
            if (blockType.getColor() != null) {
                blockHash.putInt(KEY_COLOR, blockType.getColor().getRGB());
            }
            if (blockType.getStrokeColor() != null) {
                blockHash.putInt(KEY_STROKE_COLOR, blockType.getStrokeColor().getRGB());
            }
            blockHash.putString(KEY_STROKE, blockType.getBlockStroke().name());
            ls.add((Object)blockHash);
        }
        return ls;
    }

    private ListStructure getTintList(String providerId) {
        String name = this.getScopedName(providerId);
        if (this._hash.getListStructure(name) == null) {
            this._hash.putListStructure(name, ListStructure.newInstance());
        }
        return this._hash.getListStructure(name);
    }

    public void setTintBlocks(String providerId, List<BlockType> blockList) {
        this.setTintList(providerId, TintOptions.convertToListStructure(blockList));
    }

    public void setTintList(String providerId, ListStructure TintList) {
        this._hash.putListStructure(this.getScopedName(providerId), TintList);
    }
}

