/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.ceditor.tint.TintProvider;
import oracle.ideimpl.ceditor.tint.Bundle;
import oracle.javatools.ui.list.EmptyListTextLayer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class AddTintDialog
extends JEWTDialog {
    private JList list;
    private TintProvider provider;

    public AddTintDialog(TintProvider provider, Collection<String> usedIdentifiers) {
        super((Frame)Ide.getMainWindow(), Bundle.get("SELECT_TITLE"), 7);
        this.provider = provider;
        this.init(provider.getAllBlockIdentifiers(), usedIdentifiers);
    }

    public List<String> getSelectedBlockIdentifiers() {
        return new ArrayList<Object>(Arrays.asList(this.list.getSelectedValues()));
    }

    private void init(Collection<String> allIds, Collection<String> usedIds) {
        ArrayList<String> availableIds = new ArrayList<String>(allIds);
        for (String id : usedIds) {
            availableIds.remove(id);
        }
        this.list = new JList(availableIds.toArray()){

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null) {
                    throw new IllegalArgumentException();
                }
                if (startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                prefix = prefix.toUpperCase();
                int increment = bias == Position.Bias.Forward ? 1 : -1;
                int index = startIndex;
                do {
                    Object o;
                    if ((o = model.getElementAt(index)) == null) continue;
                    String string = o.toString();
                    String providerString = AddTintDialog.this.provider.getDisplayName(string);
                    if (providerString != null) {
                        string = providerString;
                    }
                    if ((string = ((String)o).toUpperCase()) == null || !string.startsWith(prefix)) continue;
                    return index;
                } while ((index = (index + increment + max) % max) != startIndex);
                return -1;
            }
        };
        this.list.setCellRenderer(new BlockRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Window w;
                if (e.getClickCount() == 2 && AddTintDialog.this.list.getSelectedIndex() != -1 && (w = SwingUtilities.windowForComponent(AddTintDialog.this.list)) instanceof JEWTDialog) {
                    ((JEWTDialog)w).closeDialog(false);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddTintDialog.this.setOKButtonEnabled(AddTintDialog.this.list.getSelectedIndex() != -1);
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        EmptyListTextLayer emptyTextLayer = new EmptyListTextLayer(this.list, Bundle.get("ADD_EMPTY_LIST"));
        emptyTextLayer.setFont(EmptyListTextLayer.LARGE_FONT);
        JXLayer layer = new JXLayer((Component)sp, (LayerUI)emptyTextLayer);
        this.setResizable(true);
        this.setPreferredSize(325, 400);
        JPanel p = new JPanel(new BorderLayout(5, 5));
        String inst = Bundle.get("ADD_INSTRUCTIONS");
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)inst));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)inst));
        label.setLabelFor(this.list);
        p.add((Component)label, "North");
        p.add((Component)layer);
        this.setContent(p);
        HelpUtils.setHelpID((JComponent)p, (String)"f1_idedideaddblocks_html");
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        this.setOKButtonEnabled(this.list.getSelectedIndex() != -1);
    }

    private class BlockRenderer
    extends DefaultListCellRenderer {
        private BlockRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                label.setText(AddTintDialog.this.provider.getDisplayName((String)value));
            }
            return label;
        }
    }
}

