/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ceditor.tint.BlockStroke;
import oracle.ide.ceditor.tint.BlockType;
import oracle.ide.ceditor.tint.TintOptions;
import oracle.ide.ceditor.tint.TintProvider;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLChooser;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.ceditor.tint.AddTintDialog;
import oracle.ideimpl.ceditor.tint.Bundle;
import oracle.ideimpl.ceditor.tint.TintHook;
import oracle.ideimpl.ceditor.tint.TintOptionsModel;
import oracle.ideimpl.ceditor.tint.TintProviderReference;
import oracle.javatools.data.ListStructure;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.table.RolloverTableRenderer;

public class TintOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JTable table;
    private Action addAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TintOptionsPanel.this.add();
        }
    };
    private Action removeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TintOptionsPanel.this.remove();
        }
    };
    private Action loadAction = new AbstractAction(Bundle.get("OPTIONS_LOAD")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TintOptionsPanel.this.load();
        }
    };
    private Action saveAction = new AbstractAction(Bundle.get("OPTIONS_SAVE")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TintOptionsPanel.this.save();
        }
    };
    private Action restoreAction = new AbstractAction(Bundle.get("OPTIONS_RESTORE")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TintOptionsPanel.this.restore();
        }
    };
    private JComboBox providerCombo;
    private CustomColorChoice backgroundCC;
    private CustomColorChoice borderCC;
    private JComboBox borderCombo;
    private JCheckBox showBlockColoringCB;
    private boolean selecting = false;
    private TintOptionsModel model;

    public TintOptionsPanel() {
        this.setHelpID("f1_idedidesettintoptions_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private static TintOptions getOptions(TraversableContext tc) {
        return TintOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.loadSettingsFrom(TintOptionsPanel.getOptions(tc));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.saveSettingsTo(TintOptionsPanel.getOptions(tc));
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        TintOptions options = TintOptionsPanel.getOptions(tc);
        TintOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(TintOptions options) {
    }

    void loadSettingsFrom(TintOptions options) {
        ArrayList<TintProvider> providerList = new ArrayList<TintProvider>();
        HashMap<String, List<BlockType>> providerToBlockListMap = new HashMap<String, List<BlockType>>();
        HashMap<String, Comparator<BlockType>> providerToBlockComparatorMap = new HashMap<String, Comparator<BlockType>>();
        for (TintProviderReference providerRef : TintHook.get().providers()) {
            providerList.add(providerRef.provider());
            String providerID = providerRef.provider().getIdentifier();
            List<BlockType> aproviderList = options.getTintBlocks(providerID);
            providerToBlockListMap.put(providerID, aproviderList);
            BlockTypeComparator comparator = new BlockTypeComparator(providerRef.provider().getAllBlockIdentifiers());
            providerToBlockComparatorMap.put(providerID, comparator);
        }
        Collections.sort(providerList, new Comparator<TintProvider>(){

            @Override
            public int compare(TintProvider o1, TintProvider o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        this.providerCombo.setModel(new DefaultComboBoxModel<Object>(providerList.toArray()));
        this.model.populate(providerToBlockListMap, providerToBlockComparatorMap);
        TintProvider currentProvider = this.getCurrentProvider();
        if (currentProvider != null) {
            this.model.setProvider(currentProvider.getIdentifier());
        }
        this.showBlockColoringCB.setSelected(options.isEnabled());
        this.enableButtons();
    }

    void saveSettingsTo(TintOptions options) throws TraversalException {
        for (TintProviderReference providerRef : TintHook.get().providers()) {
            String providerID = providerRef.provider().getIdentifier();
            List<BlockType> blockList = this.model.getBlocks(providerID);
            ListStructure ls = TintOptions.convertToListStructure(blockList);
            options.setTintList(providerID, ls);
        }
        options.setEnabled(this.showBlockColoringCB.isSelected());
    }

    private void initializeComponent() {
        this.model = new TintOptionsModel();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TintOptionsPanel.this.enableButtons();
            }
        });
        TableBuilder builder = new TableBuilder();
        builder.setModel((TableModel)this.model);
        builder.setRollover(true);
        builder.setVisibleRows(-1);
        builder.setAutoSizeColumns(false);
        builder.setActionsDefault(TableBuilder.DefaultAction.ADD, (ActionListener)this.addAction);
        builder.setActionsDefault(TableBuilder.DefaultAction.DELETE, (ActionListener)this.removeAction);
        builder.setEmptyTextLarge(Bundle.get("OPTIONS_EMPTY_TABLE"));
        builder.setActionsSecondary(Bundle.get("OPTIONS_MORE_ACTIONS"), new Action[]{this.loadAction, this.saveAction, this.restoreAction});
        BuiltTable tableHolder = builder.build();
        this.table = tableHolder.getTable();
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)new RolloverTableRenderer((TableCellRenderer)new NameRenderer()));
        this.table.setDefaultRenderer(BlockType.class, (TableCellRenderer)new RolloverTableRenderer((TableCellRenderer)new PreviewRenderer()));
        this.table.setRowHeight(Math.max(this.table.getRowHeight(), 24));
        this.table.setShowHorizontalLines(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TintOptionsPanel.this.selectionChanged();
            }
        });
        this.showBlockColoringCB = new JCheckBox(StringUtils.stripMnemonic((String)Bundle.get("OPTIONS_SHOW_BLOCK_COLORING")));
        this.showBlockColoringCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)Bundle.get("OPTIONS_SHOW_BLOCK_COLORING")));
        String providerString = Bundle.get("OPTIONS_LANGUAGE_SCOPE");
        JLabel providerLabel = new JLabel(StringUtils.stripMnemonic((String)providerString));
        providerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)providerString));
        this.providerCombo = new JComboBox();
        providerLabel.setLabelFor(this.providerCombo);
        this.providerCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof TintProvider) {
                    label.setText(((TintProvider)value).getDisplayName());
                }
                return label;
            }
        });
        this.providerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TintOptionsPanel.this.model.setProvider(TintOptionsPanel.this.getCurrentProvider().getIdentifier());
            }
        });
        this.setLayout((LayoutManager)new MigLayout("fillx, ins 0"));
        this.add(this.showBlockColoringCB, "wrap");
        this.add((Component)new TitledSeparator(Bundle.get("OPTIONS_BLOCK_COLORS")), "gapy 6, span, growx, wrap");
        this.add(providerLabel, "split");
        this.add(this.providerCombo, "wrap");
        this.add(tableHolder.getGUI(), "grow");
        this.add(this.createControlPanel(), "aligny top, wrap");
    }

    private TintProvider getCurrentProvider() {
        return (TintProvider)this.providerCombo.getSelectedItem();
    }

    private JComponent createControlPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        JLabel colorLabel = new JLabel(StringUtils.stripMnemonic((String)Bundle.get("OPTIONS_COLOR")));
        colorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Bundle.get("OPTIONS_COLOR")));
        JLabel borderLabel = new JLabel(StringUtils.stripMnemonic((String)Bundle.get("OPTIONS_BORDER")));
        borderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Bundle.get("OPTIONS_BORDER")));
        this.backgroundCC = new CustomColorChoice();
        this.backgroundCC.setTransparentAllowed(true);
        this.borderCC = new CustomColorChoice();
        this.borderCC.setTransparentAllowed(true);
        this.borderCombo = new JComboBox<BlockStroke>(BlockStroke.values());
        this.borderCombo.setRenderer(new StrokeRenderer());
        this.borderCombo.setPreferredSize(new Dimension(80, this.borderCombo.getPreferredSize().height));
        this.borderCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TintOptionsPanel.this.updateDetails();
            }
        });
        this.backgroundCC.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "selectedColor") {
                    TintOptionsPanel.this.updateDetails();
                }
            }
        });
        this.borderCC.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "selectedColor") {
                    TintOptionsPanel.this.updateDetails();
                }
            }
        });
        colorLabel.setLabelFor((Component)this.backgroundCC);
        borderLabel.setLabelFor((Component)this.borderCC);
        panel.setLayout((LayoutManager)new MigLayout("aligny top, ins 0"));
        panel.add((Component)colorLabel, "");
        panel.add((Component)this.backgroundCC, "wrap");
        panel.add((Component)borderLabel, "");
        panel.add((Component)this.borderCombo, "");
        panel.add((Component)this.borderCC, "wrap");
        return panel;
    }

    private void enableButtons() {
        boolean rowSelected = this.table.getSelectedRow() != -1;
        this.backgroundCC.setEnabled(rowSelected);
        this.borderCC.setEnabled(rowSelected);
        this.borderCombo.setEnabled(rowSelected);
        TintProvider currentProvider = this.getCurrentProvider();
        this.providerCombo.setEnabled(currentProvider != null);
        this.addAction.setEnabled(currentProvider != null);
        this.removeAction.setEnabled(currentProvider != null);
        this.loadAction.setEnabled(currentProvider != null);
        this.saveAction.setEnabled(currentProvider != null);
        this.restoreAction.setEnabled(currentProvider != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        this.selecting = true;
        try {
            this.enableButtons();
            if (this.table.getSelectedRow() == -1) {
                this.backgroundCC.setSelectedColor(null);
                this.borderCC.setSelectedColor(null);
                this.borderCombo.setSelectedItem(null);
            } else {
                BlockType block = (BlockType)this.model.getValueAt(this.table.getSelectedRow(), 1);
                this.backgroundCC.setSelectedColor(block.getColor());
                this.borderCC.setSelectedColor(block.getStrokeColor());
                this.borderCombo.setSelectedItem((Object)block.getBlockStroke());
            }
        }
        finally {
            this.selecting = false;
        }
    }

    private void updateDetails() {
        if (this.selecting) {
            return;
        }
        if (this.table.getSelectedRow() != -1) {
            BlockType block = (BlockType)this.model.getValueAt(this.table.getSelectedRow(), 1);
            block.setColor(this.backgroundCC.getSelectedColor());
            block.setStrokeColor(this.borderCC.getSelectedColor());
            block.setBlockStroke((BlockStroke)((Object)this.borderCombo.getSelectedItem()));
            this.table.repaint();
        }
    }

    private void remove() {
        int row = this.table.getSelectedRow();
        if (row > -1) {
            this.model.remove(row);
        }
        if (this.table.getRowCount() > row) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void add() {
        ArrayList<String> usedIds = new ArrayList<String>();
        for (BlockType blockType : this.model.getBlocks(this.getCurrentProvider().getIdentifier())) {
            usedIds.add(blockType.getIdentifier());
        }
        AddTintDialog addDialog = new AddTintDialog(this.getCurrentProvider(), usedIds);
        if (addDialog.runDialog()) {
            for (String id : addDialog.getSelectedBlockIdentifiers()) {
                BlockType blockType = new BlockType(id, null, null, BlockStroke.NONE);
                this.model.add(blockType);
            }
        }
        this.enableButtons();
    }

    private void restore() {
        ArrayList<BlockType> defaultList = new ArrayList<BlockType>(this.getCurrentProvider().getDefaults());
        this.model.replaceProvidersBlocks(this.getCurrentProvider().getIdentifier(), defaultList);
    }

    private void save() {
        URLChooser urlChooser = DialogUtil.newURLChooser();
        if (urlChooser.showSaveDialog((Component)((Object)this)) == 0) {
            String providerID = this.getCurrentProvider().getIdentifier();
            ListStructureIO io = new ListStructureIO("http://xmlns.oracle.com/ide/hash", this.getProviderRootQName(providerID));
            try {
                List<BlockType> blockList = this.model.getBlocks(providerID);
                ListStructure ls = TintOptions.convertToListStructure(blockList);
                io.save(urlChooser.getSelectedURL(), (Object)ls);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), Bundle.get("OPTIONS_CANT_SAVE"), Bundle.get("OPTIONS_ERROR"), 0);
            }
        }
    }

    private void load() {
        URLChooser urlChooser = DialogUtil.newURLChooser();
        if (urlChooser.showOpenDialog((Component)((Object)this)) == 0) {
            String providerID = this.getCurrentProvider().getIdentifier();
            ListStructureIO io = new ListStructureIO("http://xmlns.oracle.com/ide/hash", providerID);
            try {
                ListStructure list = (ListStructure)io.load(urlChooser.getSelectedURL());
                this.model.replaceProvidersBlocks(providerID, TintOptions.convertFromListStructure(list));
                this.table.setModel(this.model);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), Bundle.get("OPTIONS_CANT_LOAD"), Bundle.get("OPTIONS_ERROR"), 0);
            }
        }
    }

    private String getProviderRootQName(String providerID) {
        return "block-color-preferences-" + providerID;
    }

    private class BlockTypeComparator
    implements Comparator<BlockType> {
        private SortedSet<String> sortedIds;

        public BlockTypeComparator(SortedSet<String> sortedIds) {
            this.sortedIds = sortedIds;
        }

        @Override
        public int compare(BlockType o1, BlockType o2) {
            if (o1.getIdentifier().equals(o2.getIdentifier())) {
                return 0;
            }
            for (String id : this.sortedIds) {
                if (id.equals(o1.getIdentifier())) {
                    return -1;
                }
                if (!id.equals(o2.getIdentifier())) continue;
                return 1;
            }
            return 0;
        }
    }

    private class PreviewRenderer
    extends DefaultTableCellRenderer {
        private BlockType blockType;

        private PreviewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            this.setOpaque(true);
            this.blockType = (BlockType)value;
            label.setToolTipText(null);
            return label;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.blockType.getColor());
            Rectangle clip = g.getClipBounds().intersection(new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1));
            g2.setClip(clip);
            g2.fillRoundRect(6, 4, this.getWidth(), this.getHeight() + 4, 10, 10);
            if (this.blockType.getBlockStroke().getStroke() != null) {
                g2.setStroke(this.blockType.getBlockStroke().getStroke());
                g2.setColor(this.blockType.getStrokeColor());
                g2.drawRoundRect(6, 4, this.getWidth(), this.getHeight() + 4, 10, 10);
            }
            g2.dispose();
        }
    }

    private class StrokePanel
    extends JPanel {
        BlockStroke blockStroke;
        int inset = 4;
        private Dimension prefSize = new Dimension(30, 16);

        private StrokePanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.blockStroke == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.blockStroke.getStroke() != null) {
                g2.setStroke(this.blockStroke.getStroke());
                g2.drawLine(this.inset, this.getHeight() / 2, this.getWidth() - this.inset, this.getHeight() / 2);
            }
        }
    }

    private class StrokeRenderer
    extends StrokePanel
    implements ListCellRenderer {
        private StrokeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.blockStroke = (BlockStroke)((Object)value);
            this.setBackground(!isSelected ? TintOptionsPanel.this.table.getBackground() : TintOptionsPanel.this.table.getSelectionBackground());
            return this;
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TintProvider provider = TintOptionsPanel.this.getCurrentProvider();
            if (provider != null && value instanceof String) {
                label.setText(provider.getDisplayName((String)value));
            }
            label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
            return label;
        }
    }
}

