/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.ComparisonPanel;
import oracle.dbtools.worksheet.commands.autotrace.NodeRenderer;
import oracle.dbtools.worksheet.commands.autotrace.PopupAction;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class AutotracePanel
extends AbstractPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());
    public JTreeTable tbl;
    private AutotraceTreeModel mdl = null;
    public JTable mystats;
    public Property mystatsData = new Property();
    boolean isExplainPlan = false;
    static final TableCellRenderer cellRenderer = new CellRenderer();

    public AutotraceTreeModel getATMdl() {
        return this.mdl;
    }

    public AutotracePanel(String string, boolean bl, WorksheetContext worksheetContext) {
        super(string, bl ? Messages.getString("AutotracePanel.0") : Messages.getString("AutotracePanel.1"));
        this.isExplainPlan = bl;
        Properties properties = Connections.getInstance().getConnectionInfo(worksheetContext.getConnectionName());
        if (properties != null) {
            String string2 = properties.getProperty("driver");
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            Constructor<? extends AutotraceTreeModel> constructor = worksheetFeatures.getAutotraceModelConstructor();
            try {
                this.mdl = constructor.newInstance(this);
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2"), exception);
            }
        }
        this.init();
        oracle.dbtools.raptor.SerializedData.getInstance().addObserver((Observer)this);
        try {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_autotrace_html");
        }
        catch (Exception exception) {
            System.err.println("Fine if standalone test : " + exception.getMessage());
        }
    }

    public AutotracePanel(String string, boolean bl, String string2) {
        super(string, bl ? Messages.getString("AutotracePanel.0") : Messages.getString("AutotracePanel.1"));
        this.isExplainPlan = bl;
        WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
        Constructor<? extends AutotraceTreeModel> constructor = worksheetFeatures.getAutotraceModelConstructor();
        try {
            this.mdl = constructor.newInstance(this);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2"), exception);
        }
        this.init();
        oracle.dbtools.raptor.SerializedData.getInstance().addObserver((Observer)this);
        try {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_autotrace_html");
        }
        catch (Exception exception) {
            System.err.println("Fine if standalone test : " + exception.getMessage());
        }
    }

    public void mdlReset() {
        this.getATMdl().reset();
    }

    public void mdlReload(String string, String string2, Connection connection) {
        this.getATMdl().reload(string, string2, connection);
    }

    public void explainPlan(String string, String string2, Connection connection) {
        this.getATMdl().explainPlan(string, string2, connection);
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.getATMdl().fetchPlan(string, string2, connection);
        this.getATMdl().reload(this.tbl.getTree());
    }

    private void init() {
        Serializable serializable;
        this.tbl = new JTreeTable((TreeTableModel)this.getATMdl()){

            protected Boolean isZebraRows() {
                return DBConfig.getInstance().getBoolean("ZEBRA_ROWS");
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = null;
                component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 != 0 && this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
                    if (n % 2 == 0 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color00);
                    } else if (n % 2 == 0 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color10);
                    } else if (n % 2 == 1 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color01);
                    } else if (n % 2 == 1 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color11);
                    }
                }
                return component;
            }
        };
        this.tbl.setAutoResizeMode(0);
        this.tbl.setCellSelectionEnabled(false);
        this.tbl.setColumnSelectionAllowed(false);
        this.tbl.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tbl);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        for (int i = 1; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
            serializable = this.tbl.getColumnModel().getColumn(i);
            serializable.setCellRenderer(cellRenderer);
        }
        JTree jTree = this.tbl.getTree();
        jTree.setCellRenderer(new NodeRenderer(this.tbl));
        jTree.setShowsRootHandles(true);
        serializable = this.tbl.getBackground();
        jScrollPane.setBackground((Color)serializable);
        jScrollPane.getViewport().setBackground((Color)serializable);
        this.tbl.addMouseListener((MouseListener)new PopupAction(this.tbl, this.getATMdl()));
        this.setLayout(new BorderLayout());
        SerializedData.initColumnWidths(this.tbl);
        if (this.isExplainPlan) {
            this.add((Component)jScrollPane, "Center");
        } else {
            this.mystats = new JTable(this.mystatsData);
            JScrollPane jScrollPane2 = new JScrollPane(this.mystats);
            JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(SerializedData.getInstance().dividerLocation);
            jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                    int n = jSplitPane.getDividerLocation();
                    SerializedData serializedData = SerializedData.getInstance();
                    int n2 = serializedData.dividerLocation;
                    if (Math.abs(n - n2) > 10) {
                        serializedData.dividerLocation = n;
                    }
                    SerializedData.write();
                }
            });
            this.add((Component)jSplitPane, "Center");
        }
        this.initToolbar();
    }

    @Override
    void addSQLbutton() {
        HyperlinkButton hyperlinkButton = new HyperlinkButton("SQL");
        hyperlinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GhostPalette ghostPalette = new GhostPalette();
                ghostPalette.setHideOnLoseFocus(true);
                ghostPalette.fadeInOut(true);
                ghostPalette.setLook(UIConstants.Look.LIGHT);
                int n = AutotracePanel.this.getLocation().x;
                int n2 = AutotracePanel.this.getLocation().y;
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(AutotracePanel.this, point, null);
                ghostPalette.setLocation(point);
                ghostPalette.setTitle(AutotracePanel.this.getTabLabel() + " SQL");
                MultiLineLabel multiLineLabel = new MultiLineLabel();
                multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
                multiLineLabel.setText(AutotracePanel.this.getATMdl().originalSQL);
                JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel, 20, 30);
                jScrollPane.setPreferredSize(new Dimension(AutotracePanel.this.getSize().width / 2, AutotracePanel.this.getSize().height / 2));
                final HyperlinkButton hyperlinkButton = new HyperlinkButton(Messages.getString("StatementRunnerResultsPanel.2"));
                hyperlinkButton.setBorder(BorderFactory.createEmptyBorder());
                hyperlinkButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringSelection stringSelection = new StringSelection(AutotracePanel.this.getATMdl().originalSQL);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        ClipboardStack.pushCurrentClipboard();
                        clipboard.setContents(stringSelection, stringSelection);
                        hyperlinkButton.setSelected(false);
                    }
                });
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jScrollPane, "Center");
                jPanel.add((Component)hyperlinkButton, "South");
                ghostPalette.add((Component)jPanel);
                ghostPalette.setSize(jScrollPane.getPreferredSize());
                ghostPalette.show(Ide.getMainWindow().getLayeredPane(), false, false);
            }
        });
        this._toolbar.add((Component)hyperlinkButton);
    }

    public static boolean showMyStat() {
        return oracle.dbtools.raptor.SerializedData.getInstance().myStat;
    }

    public String getSQL() {
        return this.getATMdl().getSQL();
    }

    @Override
    public Icon getTabIcon() {
        Icon icon = super.getTabIcon();
        if (icon != null) {
            return icon;
        }
        if (this.isExplainPlan) {
            return OracleIcons.getIcon((String)"explain.png");
        }
        return RaptorImagesArb.getIcon((String)"AUTOTRACE");
    }

    public void open() {
        SerializedData.initColumnWidths(this.tbl);
        this.mdlReset();
    }

    @Override
    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        LinkedList<JMenuItem> linkedList = new LinkedList<JMenuItem>();
        for (final WorksheetResultPanel worksheetResultPanel : worksheetResultPanelArray) {
            if (!(worksheetResultPanel instanceof AutotracePanel)) continue;
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("Compare_with") + " " + worksheetResultPanel.getTabLabel());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutotracePanel.this.cmp((AutotracePanel)worksheetResultPanel);
                }
            });
            linkedList.add(jMenuItem);
        }
        return linkedList.toArray(new JMenuItem[0]);
    }

    protected void cmp(AutotracePanel autotracePanel) {
        WorksheetContext worksheetContext = this.getContext();
        ComparisonPanel comparisonPanel = new ComparisonPanel(this, autotracePanel);
        worksheetContext.getCallback().showResultPanel(comparisonPanel);
    }

    public boolean isExplainPlanGetter() {
        return this.isExplainPlan;
    }

    @Override
    public void update(Observable observable, Object object) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractTableModel abstractTableModel = (AbstractTableModel)AutotracePanel.this.tbl.getModel();
                abstractTableModel.fireTableStructureChanged();
                AutotracePanel.this.tbl.revalidate();
                SerializedData.initColumnWidths(AutotracePanel.this.tbl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            try {
                Long.valueOf((String)object);
                jLabel.setHorizontalAlignment(4);
            }
            catch (Exception exception) {
                jLabel.setHorizontalAlignment(2);
            }
            jLabel.setToolTipText((String)object);
            return jLabel;
        }
    }

    public static final class Property
    extends AbstractTableModel {
        public Map<Integer, String> names = new HashMap<Integer, String>();
        public Map<Integer, Long> values = new HashMap<Integer, Long>();

        public void reset() {
            this.names = new HashMap<Integer, String>();
            this.values = new HashMap<Integer, Long>();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "V$STATNAME Name";
            }
            return "V$MYSTAT Value";
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.values.get(n);
            }
            return this.names.get(n);
        }
    }
}

