/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.images.OverlayIcon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;

class AutotraceTreeNode
extends RowSrcNode {
    String m_id = null;
    AutotraceTreeNode parent = null;
    String operation = null;
    String objectName = null;
    String qBlockName = null;
    String options = null;
    Map<String, String> extra = new TreeMap<String, String>();
    String accessPredicates = null;
    String filterPredicates = null;
    String partitionStart = null;
    String partitionStop = null;
    Color color = new Color(0);
    private AutotraceTreeNode orig = null;
    boolean isSpanned = false;
    String predicates = null;
    Icon overlay = null;
    DBConfig conf = null;
    boolean ignorePredicates;

    public AutotraceTreeNode clone(AutotraceTreeNode autotraceTreeNode) {
        AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(this.operation);
        autotraceTreeNode2.orig = this;
        autotraceTreeNode2.m_id = this.m_id;
        autotraceTreeNode2.parent = this.parent;
        autotraceTreeNode2.objectName = this.objectName;
        autotraceTreeNode2.qBlockName = this.qBlockName;
        autotraceTreeNode2.options = this.options;
        autotraceTreeNode2.accessPredicates = this.accessPredicates;
        autotraceTreeNode2.filterPredicates = this.filterPredicates;
        autotraceTreeNode2.partitionStart = this.partitionStart;
        autotraceTreeNode2.partitionStop = this.partitionStop;
        autotraceTreeNode2.color = this.color;
        autotraceTreeNode2.isSpanned = this.isSpanned;
        autotraceTreeNode2.predicates = this.predicates;
        autotraceTreeNode2.overlay = this.overlay;
        autotraceTreeNode2.ignorePredicates = ((AutotraceTreeNode)this.getRoot()).ignorePredicates;
        autotraceTreeNode2.cascadeDiff = ((AutotraceTreeNode)this.getRoot()).cascadeDiff;
        autotraceTreeNode2.extra.putAll(this.extra);
        for (int i = 0; i < this.getChildCount(); ++i) {
            autotraceTreeNode2.add(((AutotraceTreeNode)this.getChildAt(i)).clone(autotraceTreeNode));
        }
        if (autotraceTreeNode != null && !this.matchExists(autotraceTreeNode)) {
            autotraceTreeNode2.overlay = RaptorImagesArb.getIcon((String)"EXCLAMATION");
        }
        return autotraceTreeNode2;
    }

    public AutotraceTreeNode(String string) {
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.ignorePredicates = false;
        this.operation = string;
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return super.getColor();
    }

    @Override
    public String tooltip() {
        if (this.qBlockName != null) {
            return this.operation + " @" + this.qBlockName;
        }
        if (this.operation.endsWith("Predicates")) {
            return this.predicates;
        }
        return this.operation;
    }

    @Override
    public String toString() {
        String string = "";
        SerializedData serializedData = SerializedData.getInstance();
        if (this.options != null && (this.isExplainPlan() && (Boolean)serializedData.explainOptions.get("OPTIONS") == false || !this.isExplainPlan() && (Boolean)serializedData.autotraceOptions.get("OPTIONS") == false || this.orig != null)) {
            string = " (" + this.options + ") ";
        }
        String string2 = "";
        if (this.objectName != null && (this.isExplainPlan() && (Boolean)serializedData.explainOptions.get("OBJECT_NAME") == false || !this.isExplainPlan() && (Boolean)serializedData.autotraceOptions.get("OBJECT_NAME") == false || this.orig != null)) {
            string2 = this.objectName;
        }
        return this.operation + string + string2;
    }

    private boolean isExplainPlan() {
        String string = this.extra.get("LAST_CR_BUFFER_GETS");
        return string == null || "N/A".equals(string);
    }

    @Override
    public String getValue(String string) {
        if ("...".equals(this.operation)) {
            return "...";
        }
        if ("OPERATION".equals(string)) {
            return this.operation;
        }
        if (this.isSpanned) {
            return "";
        }
        if ("OBJECT_NAME".equals(string)) {
            return this.objectName;
        }
        if ("OPTIONS".equals(string)) {
            return this.options;
        }
        if ("PARTITION_START".equals(string)) {
            return this.partitionStart;
        }
        if ("PARTITION_STOP".equals(string)) {
            return this.partitionStop;
        }
        if ("ACCESS_PREDICATES".equals(string)) {
            return this.accessPredicates;
        }
        if ("FILTER_PREDICATES".equals(string)) {
            return this.filterPredicates;
        }
        if (this.extra.containsKey(string)) {
            return this.extra.get(string);
        }
        System.out.println("???" + string);
        return "???";
    }

    public static boolean isSpecialColumn(String string) {
        if ("Predicates Branch".equals(string)) {
            return true;
        }
        if ("Predicates Column".equals(string)) {
            return true;
        }
        return "ID".equals(string) || "PARENT_ID".equals(string) || "OBJECT_NAME".equals(string) || "OPTIONS".equals(string) || "OPERATION".equals(string) || "OTHER_XML".equals(string) || "PROJECTION".equals(string);
    }

    @Override
    public Icon getIcon() {
        Icon icon = null;
        icon = "Access Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAKEYS_ICON") : ("Filter Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAFILTER_ICON") : ("NESTED LOOPS".equals(this.operation) || "MERGE JOIN".equals(this.operation) || "HASH JOIN".equals(this.operation) ? WorksheetResources.getIcon("JOIN_ICON") : ("UNION-ALL".equals(this.operation) ? WorksheetResources.getIcon("UNION_ICON") : (this.operation != null && this.operation.contains("TABLE") ? WorksheetResources.getIcon("TABLE_ICON") : ("VIEW".equals(this.operation) ? WorksheetResources.getIcon("VIEW_ICON") : ("OR".equals(this.operation) ? WorksheetResources.getIcon("OR_ICON") : ("AND".equals(this.operation) ? WorksheetResources.getIcon("AND_ICON") : ("Projection".equals(this.operation) ? WorksheetResources.getIcon("PI_ICON") : (this.operation.startsWith("INDEX") ? WorksheetResources.getIcon("INDEX_ICON") : (this.operation.startsWith("SORT") ? BaseRaptorImages.getIcon((String)"SORTASCENDING_ENA") : (this.isSpanned ? WorksheetResources.getIcon("EMPTY_ICON") : WorksheetResources.getIcon("GRAY_ICON"))))))))))));
        if (this.overlay == null) {
            return icon;
        }
        return new OverlayIcon(icon, this.overlay);
    }

    @Override
    public boolean stucturallyTheSame(RowSrcNode rowSrcNode) {
        AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)rowSrcNode;
        return !(!AutotraceTreeNode.equals(this.operation, autotraceTreeNode.operation) || !AutotraceTreeNode.equals(this.objectName, autotraceTreeNode.objectName) || !AutotraceTreeNode.equals(this.options, autotraceTreeNode.options) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.accessPredicates, autotraceTreeNode.accessPredicates) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.filterPredicates, autotraceTreeNode.filterPredicates));
    }

    private static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.depth() + 1;
    }
}

