/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.task;

import java.io.BufferedOutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockableFactory;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.worksheet.commands.scriptrunner.ConsumerManager;
import oracle.dbtools.worksheet.commands.scriptrunner.api.AStatementRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.extension.ScriptRunnerHook;
import oracle.dbtools.worksheet.commands.scriptrunner.task.CommandRunnerScope;
import oracle.dbtools.worksheet.scriptparser.api.IScriptParser;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.dbtools.worksheet.utils.TextBufferReader;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public abstract class DBCommandRunnerTask
extends DatabaseQueryTask<Void> {
    private ScriptRunnerContext m_scriptRunnerContext = new ScriptRunnerContext();
    private Reader m_reader = null;
    protected String m_connectionName = null;
    WorksheetContext m_worksheetContext = null;
    boolean m_isCanceled = false;
    Connection m_connection = null;
    CommandRunnerScope m_commandRunnerScope = null;
    protected String m_id = null;
    protected ConsumerManager m_consumerManager = null;
    IScriptParser m_scriptParser = null;
    IRaptorTaskRunMode m_runMode = null;
    Logger m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected boolean isExecutionHandedOver = false;

    public DBCommandRunnerTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
        super(string, iRaptorTaskRunMode, bl, bl2);
    }

    public DBCommandRunnerTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
        super(string, iRaptorTaskRunMode, bl, bl2, bl3);
    }

    public IRaptorTaskRunMode getRunMode() {
        return this.m_runMode;
    }

    protected void loopThroughAllStatements() {
        IScriptParser iScriptParser = this.getParser();
        this.beforeLoopProcessing();
        ISQLCommand iSQLCommand = null;
        int n = 0;
        boolean bl = false;
        try {
            while (iScriptParser.hasNext() && !this.isInterupted()) {
                this.incrementCMDCount();
                if (n++ == 2000) {
                    System.gc();
                    n = 0;
                }
                this.checkCanProceed();
                if (this.isInterupted()) continue;
                this.checkCanProceed();
                iSQLCommand = (ISQLCommand)iScriptParser.next();
                if (!bl) {
                    if (this.getWorksheetContext().isStatementRunner()) {
                        if (this.getWorksheetContext().getStartCommand().equals((Object)iSQLCommand)) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                if (!bl) continue;
                this.runCommand(iSQLCommand, true, iScriptParser.hasNext(), this.getCMDCount());
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(this.m_worksheetContext.getConnectionName());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection != null && connection == this.m_scriptRunnerContext.getBaseConnection()) continue;
                this.requestCancel();
                break;
            }
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof CancellationException)) {
                this.m_logger.log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
            } else {
                this.m_isCanceled = true;
            }
        }
        catch (Exception exception) {
            boolean bl2 = false;
            for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof CancellationException)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            this.m_isCanceled = true;
        }
        this.afterLoopProcessing();
    }

    private void incrementCMDCount() {
        int n = this.getNotNullCMDCount();
        this.m_scriptRunnerContext.putProperty("current_cmd_count", (Object)(n + 1));
    }

    private int getNotNullCMDCount() {
        Integer n = (Integer)this.m_scriptRunnerContext.getProperty("current_cmd_count");
        if (n == null) {
            n = 0;
        }
        return n;
    }

    private int getCMDCount() {
        return this.getNotNullCMDCount();
    }

    protected abstract void afterLoopProcessing();

    protected abstract void beforeLoopProcessing();

    protected IScriptParser getParser() {
        if (this.m_scriptParser == null) {
            this.m_scriptParser = ScriptRunnerHook.getScriptParser(this.getScriptRunnerContext(), this.m_reader);
        }
        return this.m_scriptParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doWork() {
        this.m_commandRunnerScope = new CommandRunnerScope(this.m_worksheetContext.getEditor());
        this.startup();
        try {
            Connections.getInstance().getConnection(this.m_worksheetContext.getConnectionName());
            this.m_scriptParser = this.getParser();
            if (this.m_commandRunnerScope.isSelection()) {
                this.getScriptRunnerContext().setScriptText(this.m_worksheetContext.getEditor().getSelectionStart(), this.m_worksheetContext.getEditor().getSelectionEnd());
                this.m_scriptParser.setSelectedPos(this.m_commandRunnerScope.getSelectionStart(), this.m_commandRunnerScope.getSelectionEnd(), this.m_commandRunnerScope.getSelectionStartLine());
                this.loopThroughAllStatements();
            } else {
                this.getScriptRunnerContext().setScriptText(-1, -1);
                this.handleNoSelection(this.m_commandRunnerScope);
            }
        }
        catch (DBException dBException) {
            this.m_logger.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
        finally {
            if (!this.isExecutionHandedOver) {
                this.resetCursor(this.m_commandRunnerScope);
                this.cleanup();
                if (!this.m_isCanceled) {
                    this.setMessage(Messages.getString("ScriptRunnerTask.3"));
                }
                this.m_commandRunnerScope = null;
                this.getScriptRunnerContext().setScriptText(0, 0);
                this.getScriptRunnerContext().getExecutedCommandList().clear();
                System.gc();
            }
        }
        return null;
    }

    protected abstract void cleanup();

    protected void startup() {
    }

    protected abstract void handleNoSelection(CommandRunnerScope var1);

    void runTaskInNewThread(Thread thread) {
        try {
            this.checkCanProceed();
            if (!Thread.currentThread().isInterrupted()) {
                thread.start();
            }
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CancellationException) {
                this.m_isCanceled = true;
            }
            this.m_logger.log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
        }
    }

    boolean isInterupted() {
        boolean bl = false;
        try {
            bl = this.getCurrentConnection().isClosed();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return Thread.currentThread().isInterrupted() || this.m_isCanceled || this.getScriptRunnerContext().getExited() || bl;
    }

    protected void runTaskInThisThread(AStatementRunnerTask aStatementRunnerTask) {
        aStatementRunnerTask.runMe();
    }

    private String getDatabaseProductName() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.m_connectionName);
        return properties.getProperty("subtype");
    }

    void reinitializeTheScriptRunnerContext() {
        if (this.m_scriptRunnerContext.getTopLevel()) {
            if (this.m_scriptRunnerContext.getExited()) {
                this.m_scriptRunnerContext.reInitOnExit();
            } else {
                this.m_scriptRunnerContext.reInitNoExit();
            }
        }
    }

    void closeAnyIntermediateConnection() {
        if (this.getScriptRunnerContext().getCloseConnection()) {
            this.getScriptRunnerContext().closeCurrentConnection();
        }
    }

    void closeThePipeStream(BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    void resetCursor(CommandRunnerScope commandRunnerScope) {
        BasicEditorPane basicEditorPane = this.m_scriptRunnerContext.getEditorComponenet();
        try {
            SwingUtilities.invokeAndWait(new CursorUI(commandRunnerScope.getCursorPosition(), commandRunnerScope.isSelection(), commandRunnerScope.getSelectionStart(), commandRunnerScope.getSelectionEnd(), basicEditorPane));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected void runCommand(ISQLCommand iSQLCommand, boolean bl, boolean bl2, int n) {
        String string;
        this.highLightThisStatement(iSQLCommand);
        this.setMessage(Messages.getString("WorksheetTaskFactory.1") + iSQLCommand.getSql());
        this.tailoredRunCommand(iSQLCommand, bl, bl2, n);
        if (this.getScriptRunnerContext().isDbmsEnabled()) {
            this.enableDbmsOutput();
            this.getScriptRunnerContext().clearDbmsFlags();
        }
        if ((string = this.getScriptRunnerContext().popDbmsOutput()) != null) {
            this.setDbmsOutputDockable(string);
        }
    }

    protected void rememberHistory(ISQLCommand iSQLCommand) {
        if (this.m_worksheetContext.isTemporaryFile()) {
            this.getScriptRunnerContext().getExecutedCommandList().add(iSQLCommand);
        }
    }

    protected void saveHistory() {
        try {
            if (this.getScriptRunnerContext().getExecutedCommandList().size() < 1) {
                return;
            }
            if (!this.m_worksheetContext.isTemporaryFile()) {
                return;
            }
            if (this.getScriptRunnerContext().getExecutedCommandList().size() == 1) {
                ISQLCommand iSQLCommand = (ISQLCommand)this.getScriptRunnerContext().getExecutedCommandList().get(0);
                String string = (String)iSQLCommand.getProperty("EXECUTEFAILED");
                if (string == null && SQLCommand.StmtSubType.G_S_COMMENT_PLUS != iSQLCommand.getStmtSubType()) {
                    if (SQLCommand.StmtSubType.G_S_ATNESTED == iSQLCommand.getStmtSubType() || SQLCommand.StmtSubType.G_S_AT == iSQLCommand.getStmtSubType()) {
                        SqlEditorHistory.getInstance();
                        SqlEditorHistory.saveSql(iSQLCommand.getSQLOrig() + iSQLCommand.getStatementTerminator(), Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), SqlEditorHistory.TYPE_SCRIPT_HISTORY, (float)this.getDescriptor().getElapsedTime() / 1000.0f);
                    } else {
                        SqlEditorHistory.getInstance();
                        SqlEditorHistory.saveSql(iSQLCommand.getSQLOrig() + iSQLCommand.getStatementTerminator(), Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), SqlEditorHistory.TYPE_SQL_HISTORY, (float)this.getDescriptor().getElapsedTime() / 1000.0f);
                    }
                }
            } else if (this.isScriptViable()) {
                SqlEditorHistory.getInstance();
                SqlEditorHistory.saveSql(this.getScriptRunnerContext().getScriptText().trim(), Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), SqlEditorHistory.TYPE_SCRIPT_HISTORY, (float)this.getDescriptor().getElapsedTime() / 1000.0f);
            }
        }
        catch (Exception exception) {
            this.m_logger.log(Level.INFO, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private boolean isScriptViable() {
        for (ISQLCommand iSQLCommand : this.getScriptRunnerContext().getExecutedCommandList()) {
            String string = (String)iSQLCommand.getProperty("EXECUTEFAILED");
            if (string != null || SQLCommand.StmtSubType.G_S_COMMENT_PLUS == iSQLCommand.getStmtSubType()) continue;
            return true;
        }
        return false;
    }

    protected abstract void tailoredRunCommand(ISQLCommand var1, boolean var2, boolean var3, int var4);

    public ConsumerManager getConsumerManager() {
        return this.m_consumerManager;
    }

    public DBCommandRunnerTask(WorksheetContext worksheetContext, ConsumerManager consumerManager, String string, IRaptorTaskRunMode iRaptorTaskRunMode, String string2) {
        super(string2, iRaptorTaskRunMode, true, true);
        ScriptRunnerContext scriptRunnerContext;
        this.m_id = string;
        this.m_connectionName = worksheetContext.getConnectionName();
        this.m_worksheetContext = worksheetContext;
        this.m_consumerManager = consumerManager;
        this.m_runMode = iRaptorTaskRunMode;
        try {
            this.m_connection = Connections.getInstance().getConnection(this.m_connectionName);
        }
        catch (DBException dBException) {
            this.m_logger.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
        ScriptRunnerContext scriptRunnerContext2 = (ScriptRunnerContext)worksheetContext.getEditor().getProperty("ScriptRunnerContext");
        if (scriptRunnerContext2 != null) {
            this.m_scriptRunnerContext = scriptRunnerContext2;
            this.m_scriptRunnerContext.reInitNoExit();
        } else {
            scriptRunnerContext = (ScriptRunnerContext)Connections.getInstance().getConnectionInfo(this.m_connectionName).get("GLOGIN");
            if (scriptRunnerContext != null) {
                this.m_scriptRunnerContext = scriptRunnerContext.clone();
                worksheetContext.setScriptRunnerContext(this.m_scriptRunnerContext);
            } else {
                this.m_scriptRunnerContext = new ScriptRunnerContext();
                worksheetContext.setScriptRunnerContext(this.m_scriptRunnerContext);
            }
        }
        this.m_scriptRunnerContext.putProperty("sqldev.script.runner.connection.properties", (Object)this.getDatabaseProductName());
        scriptRunnerContext = worksheetContext.getEditor();
        TextBuffer textBuffer = ((BasicDocument)scriptRunnerContext.getDocument()).getTextBuffer();
        this.m_reader = new TextBufferReader(textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_scriptRunnerContext.putProperty("DBConfig.DEFAULT_PATH", (Object)dBConfig.getString("DEFAULTPATH"));
        this.m_scriptRunnerContext.putProperty("DBConfig.GLOGIN", (Object)new Boolean(dBConfig.getBoolean("GLOGIN")));
        this.m_scriptRunnerContext.putProperty("DBConfig.GLOGIN_FILE", (Object)dBConfig.getString(""));
        this.m_scriptRunnerContext.putProperty("script.runner.autocommit.checkbox", (Object)dBConfig.getBoolean("AUTOCOMMIT"));
        this.m_scriptRunnerContext.putProperty("script.runner.node.url", (Object)worksheetContext.getFileURL());
        this.m_scriptRunnerContext.setEditorComponenet((BasicEditorPane)scriptRunnerContext);
        this.m_scriptRunnerContext.setIsRunScript("Worksheet.RunScript".equals(this.m_id));
        this.m_scriptRunnerContext.setCurrentConnection(this.m_connection);
        this.m_scriptRunnerContext.setBaseConnection(this.m_connection);
        this.m_scriptRunnerContext.setNLSMap(DBConfig.getInstance().getNLSMap());
        this.m_scriptRunnerContext.putProperty("current_cmd_count", (Object)0);
        Boolean bl = dBConfig.getBoolean("REINIT_ON_EXIT");
        if (bl != null) {
            this.m_scriptRunnerContext.putProperty("script.runner.reinitOnExit", (Object)bl);
        }
        if (DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable()).isEnabled(this.getScriptRunnerContext().getCurrentConnection())) {
            this.getScriptRunnerContext().putProperty("script.runner.dbmsouputpane", (Object)Boolean.TRUE);
        } else {
            this.getScriptRunnerContext().putProperty("script.runner.dbmsouputpane", (Object)Boolean.FALSE);
        }
    }

    protected abstract IScriptConsumer getInitialConsumer();

    protected void setDbmsOutputDockable(String string) {
        AbstractOutputPane abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable());
        abstractOutputPane.setOutputResult(this.getScriptRunnerContext(), string);
    }

    protected void enableDbmsOutput() {
        AbstractOutputPane abstractOutputPane = DbmsOutputPane.getInstance((View)DbmsOutputDockableFactory.getDbmsDockable());
        if (abstractOutputPane.getCurrentConnection() != null) {
            abstractOutputPane.enableOutput(this.getScriptRunnerContext());
        }
    }

    protected Connection getCurrentConnection() {
        return this.m_scriptRunnerContext.getCurrentConnection();
    }

    protected ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    private void highLightThisStatement(ISQLCommand iSQLCommand) {
        SwingUtilities.invokeLater(new HighlightRunningStatement(iSQLCommand.getStartLine(), iSQLCommand.getEndLine()));
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public String getQuery() {
        return "";
    }

    protected WorksheetContext getWorksheetContext() {
        return this.m_worksheetContext;
    }

    private class HighlightRunningStatement
    implements Runnable {
        final BasicEditorPane bep;
        int m_startLine;
        int m_endLine;

        public HighlightRunningStatement(int n, int n2) {
            this.bep = DBCommandRunnerTask.this.m_scriptRunnerContext.getEditorComponenet();
            this.m_startLine = 0;
            this.m_endLine = 0;
            this.m_startLine = n;
            this.m_endLine = n2;
        }

        @Override
        public void run() {
            try {
                this.bep.setCaretPosition(this.m_startLine);
                if (this.m_startLine >= 0 && this.m_endLine >= 0) {
                    this.bep.select(this.bep.getLineStartOffset(this.m_startLine), this.bep.getLineEndOffset(this.m_endLine));
                }
                this.bep.ensureCaretVisible();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

