/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ide.util.MetaResource;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.BindDialog;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisor;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorArb;

public class SqlTuningCommon {
    private Connection m_conn = null;
    static final String PRIVILEGE_SQL = "privilege_sql";
    static final String TASKNAME_SQL = "taskName_sql";
    static final String CREATESST_SQL = "createSST_sql";
    static final String STATUSCHECK_SQL = "statusCheck_sql";
    static final String TOT_FINDINGS_SQL = "tot_findings_sql";
    static final String EXECUTESTT_SQL = "executeSTT_sql";
    static final String REPORTSSTT_SQL = "reportSTT_sql";
    static final String ALL_REPORTSSTT_SQL = "allReportSTT_sql";
    static final String IMPLEMENTSCRIPT_SQL = "implementScript_sql";
    static final String ALL_IMPLEMENTSCRIPT_SQL = "allImplementScript_sql";
    static final String DROPSTT_SQL = "dropSTT_sql";
    static final String REPORT_XML = "report_xml";
    static final String CREATESQLSET_SQL = "createSqlSet_sql";
    static final String SQLSETNAME_SQL = "sqlSetName_sql";
    static final String LOADSQLSET_SQL = "loadSqlSet_sql";
    static final String CREATESQLSETTASK_SQL = "createSqlSetTask_sql";
    static final String advisor = "ADVISOR";
    static final String ADMINISTER_SQLTUNING_SET = "ADMINISTER SQL TUNING SET";
    private String m_sqlTuningTaskName = "staName";
    private String m_sqlSetName = "sqlSet";
    private String m_findingType = "STATISTICS, INDEXES, SQL PROFILE, RESTRUCTURE SQL";
    public static final String STATISTICS = "STATISTICS";
    public static final String INDEX = "INDEX";
    public static final String SQL_PROFILE = "SQL PROFILE";
    public static final String RESTRUCTURE_SQL = "RESTRUCTURE SQL";
    public static final String RECORD_PROFILES = "PROFILES";
    public static final String RECORD_STATISTICS = "STATISTICS";
    public static final String RECORD_INDEXES = "INDEXES";
    private String m_sqlSelectedSQLScript = null;
    private String m_schemaName = null;
    private String m_recordType = null;
    private SqlTuningAdvisor m_STAdvisor = null;
    public static final String FINDINGS = SqlTuningAdvisorArb.getString("TABLE_COL_FINDINGS_NAME");
    public static final String RECOMMENDATIONS = SqlTuningAdvisorArb.getString("TABLE_COL_RECOMMENDATIONS_NAME");
    public static final String RATIONALE = SqlTuningAdvisorArb.getString("TABLE_COL_RATIONALE_NAME");
    public static String m_owner = null;
    public static String m_STA_Name = null;
    public static String m_SqlSet_Name = null;
    public static boolean m_isSQLSetCreation = false;
    private String[] m_sqlSelectedSQLScriptsForSqlSets;
    private Hashtable<String, String> m_sqlIdSQLScript;
    private String m_bindValues = null;
    private boolean m_isBindVariables = false;

    public SqlTuningCommon(SqlTuningAdvisor sqlTuningAdvisor) {
        this.setSqlTuningAdvisor(sqlTuningAdvisor);
    }

    public void setConnection(Connection connection) throws SQLException {
        this.m_conn = connection;
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        if (connectionResolver == null) {
            DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        }
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void checkForBindVariables(String string) {
        Map map = BindDialog.getBindValues((String)string);
        if (map.size() == 0) {
            this.setBindVariablesString("null");
            this.setIsBindVariables(false);
        } else {
            this.setBindVariablesString(this.generateBindVariableString(map));
            this.setIsBindVariables(true);
        }
    }

    public String checkAndSetBindVariables(String string) {
        String string2 = null;
        Map map = BindDialog.getBindValues((String)string);
        if (map.size() == 0) {
            string2 = string.trim().replace('\n', ' ').replace('\r', ' ').replaceAll("'", "''");
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                String string5 = this.containsOnlyNumbers(string4) ? string4 : "'" + string4 + "'";
                string2 = string.trim().replace('\n', ' ').replace('\r', ' ').replaceAll(":" + string3, string5);
            }
        }
        return string2;
    }

    public String getQueryFile() {
        return "/oracle/dbtools/worksheet/commands/sqltuningadvisor/SqlTuningQueries.xml";
    }

    public String getQueryKey(String string) {
        return string;
    }

    public Map<String, Object> getObjectBinds(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string.indexOf(":SQL_TEXT") > 0) {
            hashMap.put("SQL_TEXT", this.getSelectedSQLScript());
        }
        if (string.indexOf(":OWNER") > 0) {
            hashMap.put("OWNER", this.getOwnerName());
        }
        if (string.indexOf(":SQLTUNINGTASK_NAME") > 0) {
            hashMap.put("SQLTUNINGTASK_NAME", this.getSQLTuningTaskName());
        }
        if (string.indexOf(":FINDING_TYPE") > 0) {
            hashMap.put("FINDING_TYPE", this.getFindingType());
        }
        if (string.indexOf(":RECORD_TYPE") > 0) {
            hashMap.put("RECORD_TYPE", this.getRecordType());
        }
        return hashMap;
    }

    public String getSelectedSQLScript() {
        if (!this.getSqlSetsCreation()) {
            return this.getSelectedSingleSQLScript();
        }
        return this.getSQLScriptsForSqlSets();
    }

    public String getSelectedSingleSQLScript() {
        return this.m_sqlSelectedSQLScript;
    }

    public void setSelectedSingleSQLScript(String string) {
        this.m_sqlSelectedSQLScript = string;
    }

    public String getOwnerName() {
        return this.m_schemaName;
    }

    public void setOwnerName(String string) {
        this.m_schemaName = string;
        m_owner = string;
    }

    public String getSQLTuningTaskName() {
        return this.m_sqlTuningTaskName;
    }

    public String getSQLTuningSetName() {
        return this.m_sqlSetName;
    }

    public String getFindingType() {
        return this.m_findingType;
    }

    public String getRecordType() {
        return this.m_recordType;
    }

    public final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getQueryFile());
        if (query == null) {
            // empty if block
        }
        return query.getSql();
    }

    public Query getQueryFromFile(Connection connection, String string, String string2) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(SqlTuningAdvisor.class.getClassLoader(), string2));
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    public SqlTuningAdvisor getSqlTuningAdvisor() {
        return this.m_STAdvisor;
    }

    public void setSqlTuningAdvisor(SqlTuningAdvisor sqlTuningAdvisor) {
        this.m_STAdvisor = sqlTuningAdvisor;
    }

    public void sqlTuningNameResolver(ArrayList<String> arrayList) {
        String string = this.m_sqlTuningTaskName + this.generateRandomNumber();
        while (arrayList.contains(string)) {
            string = this.m_sqlTuningTaskName + this.generateRandomNumber();
        }
        this.m_sqlTuningTaskName = string;
        m_STA_Name = string;
    }

    public void sqlSetNameResolver(ArrayList<String> arrayList) {
        String string = this.m_sqlSetName + this.generateRandomNumber();
        while (arrayList.contains(string)) {
            string = this.m_sqlSetName + this.generateRandomNumber();
        }
        this.m_sqlSetName = string;
        m_SqlSet_Name = string;
    }

    public int generateRandomNumber() {
        int n = 1;
        int n2 = 100000;
        int n3 = (int)((double)n + Math.random() * (double)(n2 - n));
        return n3;
    }

    public void setSqlSetsCreation(boolean bl) {
        m_isSQLSetCreation = bl;
    }

    public boolean getSqlSetsCreation() {
        return m_isSQLSetCreation;
    }

    public String[] getSelectedSQLScriptsForSqlSets() {
        return this.m_sqlSelectedSQLScriptsForSqlSets;
    }

    public String getSQLScriptsForSqlSets() {
        String[] stringArray = this.getSelectedSQLScriptsForSqlSets();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + "\n";
        }
        return string;
    }

    public void setSelectedSQLScriptsForSqlSets(String[] stringArray) {
        this.m_sqlSelectedSQLScriptsForSqlSets = stringArray;
    }

    public Hashtable<String, String> getSqlIdAndSqlScript() {
        return this.m_sqlIdSQLScript;
    }

    public void setSqlIdAndSqlScript(Hashtable<String, String> hashtable) {
        this.m_sqlIdSQLScript = hashtable;
    }

    public String getSQLTuningSetRows() {
        String string = "";
        String string2 = "SELECT SYS.SQLSET_ROW(";
        String string3 = ",null,null, 0,0,0,0,0,0,0,0,0,0,null,0,0,null,0,0,null,0, null, null) from dual";
        String string4 = " UNION all ";
        Hashtable<String, String> hashtable = this.getSqlIdAndSqlScript();
        int n = 0;
        int n2 = hashtable.size();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = enumeration.nextElement();
            String string6 = hashtable.get(string5);
            string = string + string2 + "'" + string5 + "', 0, '" + string6.replaceAll("'", "''") + "', null, null, '" + this.getOwnerName() + "' " + string3;
            if (++n >= n2) continue;
            string = string + string4;
        }
        string = string + " ;";
        return string;
    }

    public void setBindVariablesString(String string) {
        this.m_bindValues = string;
    }

    public String getBindVariablesString() {
        return this.m_bindValues;
    }

    public void setIsBindVariables(boolean bl) {
        this.m_isBindVariables = bl;
    }

    public boolean getIsBindVariables() {
        return this.m_isBindVariables;
    }

    public String generateBindVariableString(Map<String, Object> map) {
        String string = "sql_binds(";
        int n = map.size();
        int n2 = 0;
        Object object = null;
        for (String string2 : map.keySet()) {
            object = map.get(string2);
            string = this.containsOnlyNumbers((String)object) ? string + "anydata.ConvertNumber(" + object + ")" : string + "anydata.ConvertVarchar2('" + object + "')";
            if (n > ++n2) {
                string = string + ",";
                continue;
            }
            string = string + ")";
        }
        return string;
    }

    private boolean containsOnlyNumbers(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

