/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SQLTuningXmlReport;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SortComparator;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisor;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorArb;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningCommon;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public class SqlTuningReport {
    private SqlTuningCommon m_STCommon = null;
    private SqlTuningAdvisor m_STAdvisor = null;
    private String m_allsummaryReport = null;
    private String m_statisticsDetailedReport = null;
    private String m_sqlProfileDetailedReport = null;
    private String m_indexDetailedReport = null;
    private String m_restructureSqlDetailedReport = null;
    private String m_xmlReport = null;
    private String statsStr = SqlTuningAdvisorArb.getString("REPORT_STRING_STATISTICS");
    private String indexStr = SqlTuningAdvisorArb.getString("REPORT_STRING_INDEXES");
    private String sqlProfileStr = SqlTuningAdvisorArb.getString("REPORT_STRING_SQL_PROFILE");
    private String restructSqlStr = SqlTuningAdvisorArb.getString("REPORT_STRING_RESTRUCTURE_SQL");
    private String explainPlanStr = SqlTuningAdvisorArb.getString("REPORT_STRING_EXPLAIN_PLAN");
    private String findingSectionStr = SqlTuningAdvisorArb.getString("REPORT_STRING_FINDING_SECTION");

    public SqlTuningReport(SqlTuningAdvisor sqlTuningAdvisor) {
        this.setSqlTuningAdvisor(sqlTuningAdvisor);
        this.setSqlTuningCommon(sqlTuningAdvisor.getSqlTuningCommon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClobObject() {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        String string2 = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("allReportSTT_sql"));
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.m_STCommon.getConnection().prepareCall(string2);
                oracleCallableStatement.setString(2, this.m_STCommon.getSQLTuningTaskName());
                oracleCallableStatement.registerOutParameter(1, 2005);
                oracleCallableStatement.execute();
                CLOB cLOB = oracleCallableStatement.getCLOB(1);
                long l = cLOB.length();
                string = cLOB.getSubString(1L, (int)l);
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        this.setAllSummaryReport(string);
        if (!this.m_STCommon.getSqlSetsCreation()) {
            this.parseAllSummaryReport();
        } else {
            this.parseAllSqlSetSummaryReport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getXMLBasedReport() {
        OracleCallableStatement oracleCallableStatement = null;
        XMLType xMLType = null;
        String string = null;
        String string2 = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("report_xml"));
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.m_STCommon.getConnection().prepareCall(string2);
                oracleCallableStatement.setString(1, this.m_STCommon.getSQLTuningTaskName());
                oracleCallableStatement.registerOutParameter(2, 2007, "SYS.XMLTYPE");
                oracleCallableStatement.execute();
                xMLType = XMLType.createXML((OPAQUE)oracleCallableStatement.getOPAQUE(2));
                string = xMLType.getStringVal();
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        this.setXmlReport(string);
        this.parseXmlFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllSqlTuningReport() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("reportSTT_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = new String[3];
        String string2 = null;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        hashMap.clear();
        hashMap.put("FINDING_TYPE", this.m_STCommon.getFindingType());
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        string2 = resultSet.getString(1);
                        stringArray[0] = resultSet.getString(2);
                        stringArray[1] = resultSet.getString(3);
                        stringArray[2] = resultSet.getString(4);
                        if (string2.equals("STATISTICS")) {
                            this.m_STAdvisor.getSqlTuningAdvisorStatisticsReport().put(new Integer(n), stringArray);
                            ++n;
                        } else if (string2.equals("INDEX")) {
                            this.m_STAdvisor.getSqlTuningAdvisorIndexesReport().put(new Integer(n2), stringArray);
                            ++n2;
                        } else if (string2.equals("SQL PROFILE")) {
                            this.m_STAdvisor.getSqlTuningAdvisorProfilesReport().put(new Integer(n3), stringArray);
                            ++n3;
                        } else if (string2.equals("RESTRUCTURE SQL")) {
                            this.m_STAdvisor.getSqlTuningAdvisorRestructuresSQLReport().put(new Integer(n4), stringArray);
                            ++n4;
                        }
                        stringArray = new String[3];
                    }
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
    }

    public SqlTuningCommon getSqlTuningCommon() {
        return this.m_STCommon;
    }

    public void setSqlTuningCommon(SqlTuningCommon sqlTuningCommon) {
        this.m_STCommon = sqlTuningCommon;
    }

    public SqlTuningAdvisor getSqlTuningAdvisor() {
        return this.m_STAdvisor;
    }

    public void setSqlTuningAdvisor(SqlTuningAdvisor sqlTuningAdvisor) {
        this.m_STAdvisor = sqlTuningAdvisor;
    }

    public void printAllSQLTuningResult() {
        this.printSqlTuningAdvisorIndexesReport();
        this.printSqlTuningAdvisorStatisticsReport();
        this.printSqlTuningAdvisorProfilesReport();
        this.printSqlTuningAdvisorRestructuresSQLReport();
    }

    public String printSqlTuningAdvisorIndexesReport() {
        Hashtable<Integer, String[]> hashtable = this.m_STAdvisor.getSqlTuningAdvisorIndexesReport();
        Set<Integer> set = hashtable.keySet();
        String string = new String();
        Integer n2 = null;
        string = "\nIndex Report :\n";
        for (Integer n2 : set) {
            String[] stringArray = hashtable.get(n2);
            string = string + "    Findings :\n";
            string = string + "      " + stringArray[0];
            string = string + "\n";
            string = string + "    Recommendations :\n";
            string = string + "      " + stringArray[1];
            string = string + "\n";
            string = string + "    Rationale :\n";
            string = string + "      " + stringArray[2];
            string = string + "\n";
            string = string + "\n";
        }
        return string;
    }

    public String printSqlTuningAdvisorStatisticsReport() {
        Hashtable<Integer, String[]> hashtable = this.m_STAdvisor.getSqlTuningAdvisorStatisticsReport();
        String string = new String();
        string = "\nStatistics Report :\n";
        Enumeration<Integer> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = enumeration.nextElement();
            String[] stringArray = hashtable.get(n);
            string = string + "    Findings :\n";
            string = string + "      " + stringArray[0];
            string = string + "\n";
            string = string + "    Recommendations :\n";
            string = string + "      " + stringArray[1];
            string = string + "\n";
            string = string + "    Rationale :\n";
            string = string + "      " + stringArray[2];
            string = string + "\n";
            string = string + "\n";
        }
        return string;
    }

    public String printSqlTuningAdvisorProfilesReport() {
        Hashtable<Integer, String[]> hashtable = this.m_STAdvisor.getSqlTuningAdvisorProfilesReport();
        Set<Integer> set = hashtable.keySet();
        Integer n2 = null;
        String string = new String();
        string = "\nSQL Profile Report :\n";
        for (Integer n2 : set) {
            String[] stringArray = hashtable.get(n2);
            string = string + "    Findings :\n";
            string = string + "      " + stringArray[0];
            string = string + "\n";
            string = string + "    Recommendations :\n";
            string = string + "      " + stringArray[1];
            string = string + "\n";
            string = string + "    Rationale :\n";
            string = string + "      " + stringArray[2];
            string = string + "\n";
            string = string + "\n";
        }
        return string;
    }

    public String printSqlTuningAdvisorRestructuresSQLReport() {
        Hashtable<Integer, String[]> hashtable = this.m_STAdvisor.getSqlTuningAdvisorRestructuresSQLReport();
        Set<Integer> set = hashtable.keySet();
        Integer n2 = null;
        String string = new String();
        string = "\nRestructure SQL Report :\n";
        for (Integer n2 : set) {
            String[] stringArray = hashtable.get(n2);
            string = string + "    Findings :\n";
            string = string + "      " + stringArray[0];
            string = string + "\n";
            string = string + "    Recommendations :\n";
            string = string + "      " + stringArray[1];
            string = string + "\n";
            string = string + "    Rationale :\n";
            string = string + "      " + stringArray[2];
            string = string + "\n";
            string = string + "\n";
        }
        return string;
    }

    public void parseXmlFile() {
        if (this.getXmlReport() != null) {
            SQLTuningXmlReport sQLTuningXmlReport = new SQLTuningXmlReport(this.getXmlReport());
            sQLTuningXmlReport.unmarshallXML();
        }
    }

    public void parseAllSummaryReport() {
        StringBuffer stringBuffer = new StringBuffer(this.getAllSummaryReport());
        Hashtable<Integer, String> hashtable = new Hashtable();
        HashMap<String, String> hashMap = new HashMap();
        hashtable = this.getAllStartPointArray(stringBuffer);
        hashMap = this.getAllIndividualDetailedReport(stringBuffer, hashtable);
        this.setAllIndividualReports(hashMap);
    }

    private Hashtable<Integer, String> getAllStartPointArray(StringBuffer stringBuffer) {
        int n;
        ArrayList<Object> arrayList = new ArrayList();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        arrayList = this.getStartPointForReportIdentifier(stringBuffer, "- " + this.statsStr);
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((Integer)arrayList.get(n), this.statsStr);
        }
        arrayList = this.getStartPointForReportIdentifier(stringBuffer, "- " + this.indexStr);
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((Integer)arrayList.get(n), this.indexStr);
        }
        arrayList = this.getStartPointForReportIdentifier(stringBuffer, "- " + this.sqlProfileStr);
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((Integer)arrayList.get(n), this.sqlProfileStr);
        }
        arrayList = this.getStartPointForReportIdentifier(stringBuffer, "- " + this.restructSqlStr);
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((Integer)arrayList.get(n), this.restructSqlStr);
        }
        arrayList = this.getStartPointForReportIdentifier(stringBuffer, this.explainPlanStr);
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put((Integer)arrayList.get(n), this.explainPlanStr);
        }
        return hashtable;
    }

    private ArrayList<Integer> getStartPointForReportIdentifier(StringBuffer stringBuffer, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = stringBuffer.length() - 1;
        int n2 = 0;
        while (n2 != -1 && n2 < n) {
            if ((n2 = stringBuffer.indexOf(string, n2)) == -1) continue;
            arrayList.add(new Integer(n2));
            n2 += string.length();
        }
        return arrayList;
    }

    private HashMap<String, String> getAllIndividualDetailedReport(StringBuffer stringBuffer, Hashtable<Integer, String> hashtable) {
        SortComparator sortComparator = new SortComparator();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = hashtable.entrySet().toArray();
        Arrays.sort(objectArray, sortComparator);
        for (int i = 0; i < objectArray.length; ++i) {
            String string6 = (String)((Map.Entry)objectArray[i]).getValue();
            int n = (Integer)((Map.Entry)objectArray[i]).getKey();
            int n2 = 0;
            n2 = i + 1 < objectArray.length ? (Integer)((Map.Entry)objectArray[i + 1]).getKey() : stringBuffer.length() - 1;
            if (string6.equals(this.statsStr)) {
                if (string == null) {
                    string = stringBuffer.substring(n + 2, n2 - 2);
                    continue;
                }
                string = string + "\n" + stringBuffer.substring(n + 2, n2 - 2);
                continue;
            }
            if (string6.equals(this.indexStr)) {
                if (string2 == null) {
                    string2 = stringBuffer.substring(n + 2, n2 - 2);
                    continue;
                }
                string2 = string2 + "\n" + stringBuffer.substring(n + 2, n2 - 2);
                continue;
            }
            if (string6.equals(this.sqlProfileStr)) {
                if (string3 == null) {
                    string3 = stringBuffer.substring(n + 2, n2 - 2);
                    continue;
                }
                string3 = string3 + "\n" + stringBuffer.substring(n + 2, n2 - 2);
                continue;
            }
            if (string6.equals(this.restructSqlStr)) {
                if (string4 == null) {
                    string4 = stringBuffer.substring(n + 2, n2 - 2);
                    continue;
                }
                string4 = string4 + "\n" + stringBuffer.substring(n + 2, n2 - 2);
                continue;
            }
            if (!string6.equals(this.explainPlanStr)) continue;
            string5 = string5 == null ? stringBuffer.substring(n, n2) : string5 + "\n" + stringBuffer.substring(n, n2);
        }
        hashMap.put(this.statsStr, string);
        hashMap.put(this.indexStr, string2);
        hashMap.put(this.sqlProfileStr, string3);
        hashMap.put(this.restructSqlStr, string4);
        hashMap.put(this.explainPlanStr, string5);
        return hashMap;
    }

    private void setAllIndividualReports(Map<String, String> map) {
        String string = map.get(this.statsStr);
        String string2 = map.get(this.indexStr);
        String string3 = map.get(this.sqlProfileStr);
        String string4 = map.get(this.restructSqlStr);
        String string5 = map.get(this.explainPlanStr);
        if (string != null) {
            this.setStatisticsDetailedReport(string);
        }
        if (string2 != null) {
            this.setIndexDetailedReport(string2);
        }
        if (string3 != null) {
            if (string5 == null) {
                this.setSqlProfileDetailedReport(string3);
            } else {
                this.setSqlProfileDetailedReport(string3 + "\n\n" + string5);
            }
        }
        if (string4 != null) {
            if (string5 == null) {
                this.setRestructureSqlDetailedReport(string4);
            } else {
                this.setRestructureSqlDetailedReport(string4 + "\n\n" + string5);
            }
        }
    }

    public void parseAllSqlSetSummaryReport() {
        ArrayList<String> arrayList = this.getReportOnEachSqlSetScript();
        Hashtable<String, String[]> hashtable = this.processEachSqlSetSection(arrayList);
        this.setDetailedReport(hashtable);
    }

    public ArrayList<String> getReportOnEachSqlSetScript() {
        StringBuffer stringBuffer = new StringBuffer(this.getAllSummaryReport());
        int n = stringBuffer.length() - 1;
        String string = SqlTuningAdvisorArb.getString("REPORT_STRING_OBJECT_ID");
        int n2 = stringBuffer.indexOf(string);
        int n3 = 0;
        int n4 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n3 < n) {
            n2 = stringBuffer.indexOf(string, n3 + string.length());
            if (n2 != -1 && n4 != 0) {
                arrayList.add(stringBuffer.substring(n3, n2));
            }
            if (n2 == -1) {
                arrayList.add(stringBuffer.substring(n3, n));
                n2 = n;
            }
            n3 = n2;
            ++n4;
        }
        Object[] objectArray = arrayList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
        }
        return arrayList;
    }

    private Hashtable<String, String[]> processEachSqlSetSection(ArrayList<String> arrayList) {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        Object[] objectArray = arrayList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            String[] stringArray = new String[4];
            String string2 = null;
            int n = string.indexOf(this.findingSectionStr);
            if (n != -1) {
                string2 = string.substring(0, string.indexOf(this.findingSectionStr));
            } else {
                int n2 = string.indexOf(this.explainPlanStr);
                if (n2 == -1) continue;
                string2 = string.substring(0, string.indexOf(this.explainPlanStr));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            Hashtable<Integer, String> hashtable2 = new Hashtable();
            HashMap<Object, Object> hashMap = new HashMap();
            hashtable2 = this.getAllStartPointArray(stringBuffer);
            hashMap = this.getAllIndividualDetailedReport(stringBuffer, hashtable2);
            String string3 = (String)hashMap.get(this.statsStr);
            String string4 = (String)hashMap.get(this.indexStr);
            String string5 = (String)hashMap.get(this.sqlProfileStr);
            String string6 = (String)hashMap.get(this.restructSqlStr);
            String string7 = (String)hashMap.get(this.explainPlanStr);
            if (string5 != null && string7 != null) {
                string5 = string5 + "\n\n" + string7;
            }
            if (string6 != null && string7 != null) {
                string6 = string6 + "\n\n" + string7;
            }
            stringArray[0] = string3;
            stringArray[1] = string4;
            stringArray[2] = string5;
            stringArray[3] = string6;
            hashtable.put(string2, stringArray);
        }
        return hashtable;
    }

    public void setDetailedReport(Hashtable<String, String[]> hashtable) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string5 = enumeration.nextElement();
            String[] stringArray = hashtable.get(string5);
            if (stringArray[0] != null) {
                string = string + string5 + "\n";
                string = string + stringArray[0] + "\n";
            }
            if (stringArray[1] != null) {
                string2 = string2 + string5 + "\n";
                string2 = string2 + stringArray[1] + "\n";
            }
            if (stringArray[2] != null) {
                string3 = string3 + string5 + "\n";
                string3 = string3 + stringArray[2] + "\n";
            }
            if (stringArray[3] == null) continue;
            string4 = string4 + string5 + "\n";
            string4 = string4 + stringArray[3] + "\n";
        }
        this.setStatisticsDetailedReport(string);
        this.setIndexDetailedReport(string2);
        this.setSqlProfileDetailedReport(string3);
        this.setRestructureSqlDetailedReport(string4);
    }

    public String getAllSummaryReport() {
        return this.m_allsummaryReport;
    }

    public void setAllSummaryReport(String string) {
        this.m_allsummaryReport = string;
    }

    public String getStatisticsDetailedReport() {
        return this.m_statisticsDetailedReport;
    }

    public void setStatisticsDetailedReport(String string) {
        this.m_statisticsDetailedReport = string;
    }

    public String getSqlProfileDetailedReport() {
        return this.m_sqlProfileDetailedReport;
    }

    public void setSqlProfileDetailedReport(String string) {
        this.m_sqlProfileDetailedReport = string;
    }

    public String getIndexDetailedReport() {
        return this.m_indexDetailedReport;
    }

    public void setIndexDetailedReport(String string) {
        this.m_indexDetailedReport = string;
    }

    public String getRestructureSqlDetailedReport() {
        return this.m_restructureSqlDetailedReport;
    }

    public void setRestructureSqlDetailedReport(String string) {
        this.m_restructureSqlDetailedReport = string;
    }

    public String getXmlReport() {
        return this.m_xmlReport;
    }

    public void setXmlReport(String string) {
        this.m_xmlReport = string;
    }
}

