/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.PlsNode;
import oracle.dbtools.worksheet.TextView;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.extension.WorksheetConnectionListener;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MenuSpec;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Holder;
import oracle.jdeveloper.db.ConnectionException;

public class OpenWorksheetWizard
extends Wizard {
    private static final Logger LOGGER = Logger.getLogger(OpenWorksheetWizard.class.getName());
    private MenuSpec _menuSpec;

    public final String getShortLabel() {
        return null;
    }

    public final Icon getIcon() {
        return this.getMenuSpecification() != null ? this.getMenuSpecification().getIcon() : null;
    }

    public boolean invoke(Context context) {
        Object object;
        Object object2;
        String string = (String)context.getProperty("Connections.db_name");
        if (string == null) {
            object2 = context.getElement();
            if (object2 instanceof Locatable) {
                String string2;
                object = null;
                object = object2 instanceof IViewerNode ? ((IViewerNode)object2).getBaseNode().getURL() : ((Locatable)object2).getURL();
                if (string == null && object != null && DBURLFormatHelper.isDBURL((URL)object) && (string2 = DBURLFormatHelper.getConnectionName((URL)object)) != null) {
                    string = string2;
                }
            }
            string = ConnectionSelectorUI.getConnection((String)ControlsArb.getString((String)"TITLE_CONNECTION"), (String)ControlsArb.getString((String)"MESSAGE_CONNECTION_PROMPT"), (String)string, (boolean)false);
        }
        if (string != null) {
            object2 = string;
            object = new RaptorTask<Void>(ConnectionArb.getString((String)"OPENING_WORKSHEET"), true, IRaptorTaskRunMode.IDE_STATUSBAR, (String)object2){
                final /* synthetic */ String val$cName;
                {
                    this.val$cName = string2;
                    super(string, bl, iRaptorTaskRunMode);
                }

                protected Void doWork() throws TaskException {
                    try {
                        OpenWorksheetWizard.this.open(this.val$cName);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            object.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)object);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void open(String string) throws InterruptedException, InvocationTargetException {
        block11: {
            Connection connection = null;
            try {
                ConnectionSelectorUI.SELECTOR_ACTIVE = true;
                boolean bl = DBConfig.getInstance().getBoolean("UNSHAREDWORKSHEETOPEN");
                connection = Connections.getInstance().getConnection(string, false);
                if (connection == null || !bl) {
                    connection = Connections.getInstance().getConnection(string, true);
                } else {
                    string = Connections.getInstance().createPrivateConnection(string);
                    connection = Connections.getInstance().getConnection(string);
                }
                final String string2 = string;
                if (connection != null && Connections.getInstance().lock(connection)) {
                    WorksheetConnectionListener.isOpenable = false;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            OpenWorksheetWizard.openNewTempWorksheet(string2);
                        }
                    });
                }
                ConnectionSelectorUI.SELECTOR_ACTIVE = false;
                Connections.getInstance().unlock(connection);
            }
            catch (DBException dBException) {
                if (dBException.getCause() instanceof SQLException) {
                    ExceptionHandler.handleException((Throwable)((SQLException)dBException.getCause()));
                }
            }
            catch (ConnectionException connectionException) {
                ExceptionHandler.handleException((Throwable)connectionException);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            String string = ConnectionArb.getString((String)"SQL_VIEWER_NAME");
            String string2 = StringUtils.stripMnemonic((String)string);
            int n = StringUtils.getMnemonicKeyCode((String)string);
            this._menuSpec = new MenuSpec(string2, n != 0 ? new Integer(n) : null, null);
        }
        return this._menuSpec;
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public static View openNewTempWorksheet(String string) {
        return OpenWorksheetWizard.openNewTempWorksheet(string, null);
    }

    public static View openNewTempWorksheet(String string, String string2) {
        try {
            URL uRL = WorksheetURLFileSystemHelper.createWorksheetURL(string);
            SqlNode sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
            Icon icon = Connections.isUnsharedWorksheetConnection((String)string) ? CommonArb.getIcon((String)"UNSHAREDWORKSHEET_ICON") : CommonArb.getIcon((String)"SQLWORKSHEET_ICON");
            sqlNode.setIcon(icon);
            sqlNode.addNodeListener((NodeListener)new NL());
            Context context = Context.newIdeContext((Node)sqlNode);
            context.setProperty("Connections.db_name", (Object)string);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, Worksheet.class);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
            if (editor instanceof TextView) {
                if (string2 != null) {
                    ((TextView)editor).replaceText(string2);
                }
                return editor;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
        return null;
    }

    public static View openNewWorksheet(String string, URL uRL) {
        try {
            SqlNode sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
            Icon icon = Connections.isUnsharedWorksheetConnection((String)string) ? CommonArb.getIcon((String)"UNSHAREDWORKSHEET_ICON") : CommonArb.getIcon((String)"SQLWORKSHEET_ICON");
            sqlNode.setIcon(icon);
            Context context = Context.newIdeContext((Node)sqlNode);
            context.setProperty("Connections.db_name", (Object)string);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, Worksheet.class);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
        }
        return null;
    }

    private static class NL
    extends NodeListener {
        private static boolean s_prompt;
        private URL m_url;
        public URL m_temp_url;
        private transient boolean m_processingSave = false;
        private boolean m_userCanceledSave;
        protected int m_saveState;

        private NL() {
        }

        public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
            if (bl && !s_prompt) {
                final Node node = nodeEvent.getNode();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        node.markDirty(false);
                    }
                });
            }
        }

        public void nodeRenamed(NodeEvent nodeEvent, URL uRL, URL uRL2) {
            if (WorksheetURLFileSystemHelper.isWorksheetURL(uRL) && !WorksheetURLFileSystemHelper.isWorksheetURL(uRL2)) {
                Node node = nodeEvent.getNode();
                node.removeNodeListener((NodeListener)this);
                this.deleteTempFile(uRL);
                node.getAttributes().set(ElementAttributes.SAVEABLE);
            }
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
            SqlNode sqlNode = (SqlNode)nodeEvent.getNode();
            sqlNode.removeNodeListener((NodeListener)this);
            this.deleteTempFile(nodeEvent.getNodeURL());
        }

        public void nodeSaved(NodeEvent nodeEvent) {
            final Node node = nodeEvent.getNode();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean bl;
                    NL nL = NL.this;
                    synchronized (nL) {
                        bl = NL.this.m_processingSave;
                    }
                    if (bl) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (NL.this.m_url != null) {
                        try {
                            URLFileSystem.copy((URL)node.getURL(), (URL)NL.this.m_url);
                            node.setURL(NL.this.m_url);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    UpdateMessage.fireObjectRenamed((Subject)node);
                                }
                            });
                        }
                        catch (IOException iOException) {
                            ExceptionHandler.handleException((Throwable)iOException);
                        }
                        node.getAttributes().set(ElementAttributes.EDITOR_SAVEABLE_AS);
                        node.removeNodeListener((NodeListener)NL.this);
                    } else if (NL.this.m_userCanceledSave) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                node.markDirty(true);
                            }
                        });
                    } else {
                        node.getAttributes().set(ElementAttributes.EDITOR_SAVEABLE_AS);
                    }
                }
            };
            runnable.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeWillBeSaved(final NodeEvent nodeEvent) {
            this.m_url = nodeEvent.getNodeURL();
            this.m_userCanceledSave = false;
            Node node = nodeEvent.getNode();
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    NL.this.m_url = NL.this.getSaveURL(nodeEvent.getNodeURL());
                }
            };
            if (s_prompt) {
                URL uRL = nodeEvent.getNodeURL();
                if (WorksheetURLFileSystemHelper.isWorksheetURL(uRL)) {
                    Object object = this;
                    synchronized (object) {
                        this.m_processingSave = true;
                    }
                    object = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                runnable.run();
                            }
                            finally {
                                5 var1_1 = this;
                                synchronized (var1_1) {
                                    NL.this.m_processingSave = false;
                                }
                            }
                        }
                    };
                    if (Ide.isQuitting()) {
                        object.run();
                    } else {
                        UIUtils.runOnEventDispatchThread((Runnable)object);
                    }
                } else {
                    this.m_url = null;
                }
            }
        }

        private void deleteTempFile(URL uRL) {
            URLFileSystem.delete((URL)uRL);
        }

        private URL getNewURL(URL uRL) {
            String string = WorksheetURLFileSystemHelper.isWorksheetURL(uRL) ? URLFileSystem.getPlatformPathName((URL)uRL) : "Untitled";
            URL uRL2 = DBConfig.getInstance().getScriptDirectory();
            if (!URLFileSystem.exists((URL)uRL2)) {
                uRL2 = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
            }
            URL uRL3 = URLFactory.newUniqueURL((URL)uRL2, (NameGenerator)new DefaultNameGenerator(string, ".sql", -1));
            return uRL3;
        }

        private URL getSaveURL(final URL uRL) {
            boolean bl = false;
            final Holder holder = new Holder();
            Runnable runnable = new Runnable(){
                URLFileChooser tdlg = new URLFileChooser((Context)null);

                @Override
                public void run() {
                    this.tdlg.setSelectedURL(NL.this.getNewURL(uRL));
                    this.tdlg.clearChooseableURLFilters();
                    this.tdlg.addChooseableURLFilter(PlsNode.PLS_FILTER);
                    this.tdlg.addChooseableURLFilter(PlsNode.PLB_FILTER);
                    this.tdlg.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
                    this.tdlg.setURLFilter(SqlNode.SQL_FILTER);
                    holder.set((Object)this.tdlg.showSaveDialog((Component)Ide.getMainWindow()));
                    NL.this.m_temp_url = this.tdlg.getSelectedURL();
                }
            };
            while (!bl) {
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    int n = (Integer)holder.get();
                    if (n == 0) {
                        if (URLFileSystem.exists((URL)this.m_temp_url)) {
                            final Holder holder2 = new Holder();
                            Runnable runnable2 = new Runnable(){

                                @Override
                                public void run() {
                                    holder2.set((Object)MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)WorksheetResources.format("WORKSHEET_OVERWRITE_PROMPT", URLFileSystem.getPlatformPathName((URL)NL.this.m_temp_url)), (String)WorksheetResources.getString("WORKSHEET_OVERWRITE_TITLE")));
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable2.run();
                            } else {
                                SwingUtilities.invokeAndWait(runnable2);
                            }
                            int n2 = (Integer)holder2.get();
                            switch (n2) {
                                case 1: {
                                    bl = true;
                                    break;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    this.m_temp_url = null;
                                    bl = true;
                                    this.m_userCanceledSave = true;
                                    break;
                                }
                            }
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    this.m_userCanceledSave = true;
                    bl = true;
                    this.m_temp_url = null;
                }
                catch (Exception exception) {}
            }
            return this.m_temp_url;
        }

        static {
            DBConfig dBConfig = DBConfig.getInstance();
            s_prompt = dBConfig.getBoolean("PROMPTWHENCLOSE");
            dBConfig.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                        if (!"PROMPTWHENCLOSE".equals(changeInfo.getPropertyName())) continue;
                        s_prompt = changeInfo.getNewValueAsBoolean();
                    }
                }
            });
        }
    }
}

