/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.net.Authenticator;
import java.util.EmptyStackException;
import java.util.Stack;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.IdeAuthenticator;

public class AuthenticatorManager {
    private static AuthenticatorManager _instance;
    private Stack<Authenticator> _authenticators = new Stack();
    private Authenticator _defaultAuthenticator;

    private AuthenticatorManager() {
    }

    public static synchronized AuthenticatorManager getInstance() {
        if (_instance == null) {
            _instance = new AuthenticatorManager();
        }
        return _instance;
    }

    public void initialize() {
        this._defaultAuthenticator = new IdeAuthenticator();
        this.pushAuthenticator(this._defaultAuthenticator);
    }

    public synchronized void pushAuthenticator(Authenticator authenticator) {
        this._authenticators.push(authenticator);
        Authenticator.setDefault(this._authenticators.peek());
    }

    public synchronized Authenticator popAuthenticator() throws IllegalStateException {
        if (this._authenticators.size() > 1) {
            Authenticator _oldAuthenticator = this._authenticators.pop();
            Authenticator.setDefault(this._authenticators.peek());
            return _oldAuthenticator;
        }
        throw new IllegalStateException(BrowserArb.getString(17));
    }

    public synchronized Authenticator getCurrentAuthenticator() throws EmptyStackException {
        return this._authenticators.peek();
    }

    public Authenticator getDefaultAuthenticator() {
        return this._defaultAuthenticator;
    }
}

