/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser.osx;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.ideimpl.webbrowser.osx.LaunchService;

public class MacBrowserUtil {
    private static final String SAFARI_ID = "safari";
    private static final String FIREFOX_ID = "firefox";
    private static final String CHROME_ID = "chrome";
    private static final String OPERA_ID = "opera";
    private static final Logger _LOGGER = Logger.getLogger(MacBrowserUtil.class.getName());

    public static Set<BrowserName> getWebBrowsers() {
        String[] idList = null;
        try {
            if (LaunchService.getInstance().isLoaded()) {
                idList = LaunchService.getInstance().getAllHandlersForURLScheme("https");
            }
        }
        catch (Exception e) {
            _LOGGER.warning("The web browser list cannot be queried from LaunchService (" + e + "). The default value will be used.");
        }
        catch (Error e) {
            _LOGGER.warning("The web browser list cannot be queried from LaunchService (" + e + "). The default value will be used.");
        }
        HashSet<BrowserName> ret = new HashSet<BrowserName>(10);
        if (idList != null) {
            if (MacBrowserUtil.include(idList, SAFARI_ID)) {
                ret.add(BrowserName.Safari);
            }
            if (MacBrowserUtil.include(idList, FIREFOX_ID)) {
                ret.add(BrowserName.Firefox);
            }
            if (MacBrowserUtil.include(idList, CHROME_ID)) {
                ret.add(BrowserName.Chrome);
            }
            if (MacBrowserUtil.include(idList, OPERA_ID)) {
                ret.add(BrowserName.Opera);
            }
        }
        if (ret.size() == 0) {
            ret.add(BrowserName.Safari);
        }
        return ret;
    }

    public static BrowserName getDefaultWebBrowser() {
        String id = null;
        try {
            if (LaunchService.getInstance().isLoaded()) {
                id = LaunchService.getInstance().getDefaultHandlerForURLScheme("https");
            }
        }
        catch (Exception e) {
            _LOGGER.warning("The system web browser cannot be queried (" + e + "). The default value will be used.");
        }
        catch (Error e) {
            _LOGGER.warning("The system web browser cannot be queried (" + e + "). The default value will be used.");
        }
        if (id != null) {
            if (id.contains(SAFARI_ID)) {
                return BrowserName.Safari;
            }
            if (id.contains(FIREFOX_ID)) {
                return BrowserName.Firefox;
            }
            if (id.contains(CHROME_ID)) {
                return BrowserName.Chrome;
            }
            if (id.contains(OPERA_ID)) {
                return BrowserName.Opera;
            }
        }
        return BrowserName.Safari;
    }

    private static boolean include(String[] idList, String substringToSearch) {
        for (String id : idList) {
            if (!id.toLowerCase().contains(substringToSearch)) continue;
            return true;
        }
        return false;
    }

    public static enum BrowserName {
        Safari,
        Firefox,
        Chrome,
        Opera;

    }
}

