/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.Cache;
import oracle.adfinternal.model.dvt.util.transform.Cube;
import oracle.adfinternal.model.dvt.util.transform.DataTable;
import oracle.adfinternal.model.dvt.util.transform.DeleteChanges;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.InsertInfo;
import oracle.adfinternal.model.dvt.util.transform.MemberCacheKey;
import oracle.adfinternal.model.dvt.util.transform.Page;
import oracle.adfinternal.model.dvt.util.transform.PageInfo;
import oracle.adfinternal.model.dvt.util.transform.PagedEdgeTreeMap;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.ResultTableInsert;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.RowInfo;
import oracle.adfinternal.model.dvt.util.transform.SliceInsertInfo;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.MetadataMap;

class CubeImpl
implements Cloneable,
Cube {
    protected static final TransformUtils.NullMarker m_nullMarker = new TransformUtils.NullMarker();
    private Hashtable<Integer, Boolean> m_isOutline = new Hashtable();
    private boolean m_outlineChecked = false;
    private PagedEdgeTreeMap m_mainCube = null;
    private List<EdgeTreeImpl> m_pages = new ArrayList<EdgeTreeImpl>();
    private boolean[] m_hasEdge = null;

    public CubeImpl() {
        this(new PageInfo());
    }

    public CubeImpl(PageInfo pageInfo) {
        this.m_mainCube = new PagedEdgeTreeMap(pageInfo.isConstantCube());
    }

    public Object clone() throws CloneNotSupportedException {
        CubeImpl newCube = null;
        try {
            newCube = (CubeImpl)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        newCube.m_isOutline = (Hashtable)this.m_isOutline.clone();
        newCube.m_outlineChecked = this.m_outlineChecked;
        newCube.m_mainCube = (PagedEdgeTreeMap)this.m_mainCube.clone();
        newCube.m_pages = (List)((ArrayList)this.m_pages).clone();
        if (this.m_hasEdge != null) {
            newCube.m_hasEdge = (boolean[])this.m_hasEdge.clone();
        }
        return newCube;
    }

    public void setHasEdge(boolean[] hasEdge) {
        this.m_hasEdge = hasEdge;
    }

    public boolean[] getHasEdge() {
        return this.m_hasEdge;
    }

    public void clear() {
        this.m_mainCube.clear();
        this.m_pages.clear();
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        CubeImpl cube = null;
        try {
            cube = (CubeImpl)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        cube.m_mainCube = (PagedEdgeTreeMap)this.m_mainCube.clone(caching);
        for (EdgeTreeImpl tree : this.m_pages) {
            try {
                cube.m_pages.add((EdgeTreeImpl)tree.clone(caching));
            }
            catch (CloneNotSupportedException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        cube.m_isOutline = (Hashtable)this.m_isOutline.clone();
        if (this.m_hasEdge != null) {
            cube.m_hasEdge = (boolean[])this.m_hasEdge.clone();
        }
        return cube;
    }

    public void release() {
        this.m_isOutline.clear();
        this.m_isOutline = null;
        for (EdgeTreeImpl tree : this.m_pages) {
            if (tree == null) continue;
            tree.release();
        }
        List cubeVal = null;
        Page key = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTreeImpl tree : cubeVal) {
                if (tree == null) continue;
                tree.release();
            }
        }
    }

    protected boolean isOutline(int edge) {
        if (this.m_outlineChecked) {
            return this.m_isOutline.get(edge);
        }
        this.m_isOutline = new Hashtable();
        boolean anyOutline = false;
        for (EdgeTreeImpl tree : this.m_pages) {
            if (tree == null) continue;
            boolean outline = tree.isOutline();
            if (outline) {
                anyOutline = true;
            }
            this.m_isOutline.put(tree.getEdge(), outline);
        }
        List cubeVal = null;
        Page key = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTreeImpl tree : cubeVal) {
                if (tree == null) continue;
                boolean outline = tree.isOutline();
                if (outline) {
                    anyOutline = true;
                }
                this.m_isOutline.put(tree.getEdge(), outline);
            }
        }
        this.m_outlineChecked = true;
        this.m_isOutline.put(-1, anyOutline);
        return this.m_isOutline.get(edge);
    }

    public EdgeTreeImpl getEdgeTree(int edge, Page page) {
        if (edge < this.getEdgeCount()) {
            if (edge >= 2) {
                return this.m_pages.get(edge - 2);
            }
            List<EdgeTreeImpl> edgeList = this.m_mainCube.get(page);
            if (edgeList != null && edge < edgeList.size()) {
                return edgeList.get(edge);
            }
        }
        return null;
    }

    protected void walkData(ResultTable rt, Cache cache, Page page, boolean[] alwaysAdd, boolean keepNulls, boolean placeTotals, LayerSortInfo[] sortInfo) throws TransformException {
        this.walkData(new ResultTableInsert(rt, null), cache, page, alwaysAdd, keepNulls, placeTotals, sortInfo);
    }

    private boolean _notPaged(String[][] layout, Page sortPage) {
        boolean pages = false;
        if (layout.length > 2 && !this.m_mainCube.isNotPaged()) {
            for (int e = 2; e < layout.length; ++e) {
                if (layout[e] == null || layout[e].length <= 0) continue;
                pages = true;
                break;
            }
        }
        return sortPage != null && (this.m_mainCube.isNotPaged() || !pages);
    }

    protected void walkData(ResultTableInsert rti, Cache cache, Page sortPage, boolean[] alwaysAdd, boolean keepNulls, boolean placeTotals, LayerSortInfo[] sortInfo) throws TransformException {
        RowInfo[] column = null;
        RowInfo[] row = null;
        ResultTable rt = rti.getResultTable();
        String[] measList = TransformUtils.getMeasList(rt.getProjection());
        DataTable dt = rt.getDataTable();
        String[][] layout = rt.getProjection().getLayout();
        long rowCount = dt.getRowCount();
        Row rowData = null;
        MemberInterface[][][] pageVals = null;
        InsertInfo[] edgeInserts = rti.getEdgeInserts(true);
        InsertInfo colInsert = null;
        InsertInfo rowInsert = null;
        QDRLite[] qdrs = null;
        Cube.PageRowInfo pri = null;
        EdgeTreeImpl colEdgeTree = null;
        EdgeTreeImpl rowEdgeTree = null;
        boolean notPaged = this._notPaged(layout, sortPage);
        if (notPaged) {
            colEdgeTree = this._getOrCreateEdgeTree(0, sortPage);
            rowEdgeTree = this._getOrCreateEdgeTree(1, sortPage);
            colInsert = colEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 0) : null;
            rowInsert = rowEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 1) : null;
        }
        if (!notPaged & rowCount == 0L) {
            pri = this.addPageRows(rowData, layout, edgeInserts, alwaysAdd, keepNulls, placeTotals, sortInfo, rt);
            pageVals = pri.getMembers();
            for (Page page : pri.getPages()) {
                if (notPaged) continue;
                colEdgeTree = this._getOrCreateEdgeTree(0, page);
                rowEdgeTree = this._getOrCreateEdgeTree(1, page);
            }
        }
        int r = 0;
        while ((long)r < rowCount) {
            rowData = dt.getRow(r);
            pri = this.addPageRows(rowData, layout, edgeInserts, alwaysAdd, keepNulls, placeTotals, sortInfo, rt);
            pageVals = pri.getMembers();
            for (Page page : pri.getPages()) {
                if (!notPaged) {
                    colEdgeTree = this._getOrCreateEdgeTree(0, page);
                    rowEdgeTree = this._getOrCreateEdgeTree(1, page);
                    if (colInsert == null) {
                        InsertInfo insertInfo = colInsert = colEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 0) : null;
                    }
                    if (rowInsert == null) {
                        InsertInfo insertInfo = rowInsert = rowEdgeTree != null ? InsertInfo.getEdgeInsert(edgeInserts, 1) : null;
                    }
                }
                if (colEdgeTree != null && layout.length > 0) {
                    column = colEdgeTree.addRow(rowData, layout[0], colInsert, TransformUtils.alwaysAdd(alwaysAdd, 0), keepNulls, placeTotals, sortInfo, rt);
                }
                if (rowEdgeTree != null && layout.length > 1) {
                    row = rowEdgeTree.addRow(rowData, layout[1], rowInsert, TransformUtils.alwaysAdd(alwaysAdd, 1), keepNulls, placeTotals, sortInfo, rt);
                }
                if (cache.m_caching && (qdrs = this._getQDRs(rt.getProjection().getLayout(), pageVals, column, row)) != null && this.getRealQDRs() != null) {
                    for (int i = 0; i < qdrs.length; ++i) {
                        this.getRealQDRs().add(qdrs[i]);
                    }
                }
                rowData.setLocation(column, row, pri);
                if (!rt.isLocalStorage() && !rowData.hasCalcColumns() && (!placeTotals || !rowData.isCalculatedValue())) continue;
                MemberCacheKey cacheKey = null;
                DataCellInterface value = null;
                if (measList == null) continue;
                for (int m = 0; m < measList.length; ++m) {
                    boolean isCalcColumn = rowData.isCalcColumn(measList[m]);
                    if (!rt.isLocalStorage() && (!placeTotals || !rowData.isCalculatedValue()) && !isCalcColumn) continue;
                    cacheKey = row != null && row.length > 0 && row[0].hasMeasure() ? cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row != null && row.length > m && row[m] != null ? row[m].getValues() : null, column != null && column.length > 0 && column[0] != null ? column[0].getValues() : null) : (column != null && column.length > 0 && column[0].hasMeasure() ? cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row != null && row.length > 0 && row[0] != null ? row[0].getValues() : null, column != null && column.length > m && column[m] != null ? column[m].getValues() : null) : cache.m_memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, m), row != null && row.length > 0 && row[0] != null ? row[0].getValues() : null, column != null && column.length > 0 && column[0] != null ? column[0].getValues() : null));
                    value = isCalcColumn ? new CellInterfaceImpl(rowData.getValue(measList[m])) : rowData.getCell(measList[m]);
                    this.storeData(value, cacheKey, cache.m_dataCache);
                    cache.m_memberKeyPool.returnCacheKeyToPool(cacheKey);
                }
            }
            ++r;
        }
    }

    protected Cube.PageRowInfo addPageRows(Row rowData, String[][] layout, InsertInfo[] edgeInserts, boolean[] alwaysAdd, boolean keepNulls, boolean placeTotals, LayerSortInfo[] sortInfo, ResultTable rt) throws TransformException {
        int edgeCount = this.getEdgeCount();
        int edgeCountBeyondRow = edgeCount < 2 ? 0 : edgeCount - 2;
        MemberInterface[][][] retVal = new MemberInterface[edgeCountBeyondRow][][];
        if (edgeCountBeyondRow == 0) {
            return new Cube.PageRowInfo();
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(new Page());
        String[] measList = null;
        for (int i = 0; i < retVal.length; ++i) {
            RowInfo[] ri;
            if (layout.length <= 1 + i + 1 || (ri = this.getEdgeTree(i + 1 + 1, null).addRow(rowData, layout[1 + i + 1], InsertInfo.getEdgeInsert(edgeInserts, 2 + i), TransformUtils.alwaysAdd(alwaysAdd, 1 + i + 1), keepNulls, placeTotals, sortInfo, rt)) == null) continue;
            retVal[i] = new MemberInterface[ri.length][];
            if (ri.length > 1) {
                measList = new String[ri.length];
                try {
                    for (int a = 0; a < ri.length - 1; ++a) {
                        pages.add((Page)((Page)pages.get(0)).clone());
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new TransformException(e.getMessage(), e);
                }
            }
            for (int m = 0; m < ri.length; ++m) {
                ((Page)pages.get(m)).setPage(i + 1 + 1, ri[m].getStringValues());
                retVal[i][m] = ri[m].getValues();
                if (ri.length <= 1) continue;
                measList[m] = ri[m].getMeasure();
            }
        }
        return new Cube.PageRowInfo(retVal, measList, pages);
    }

    private EdgeTreeImpl _getOrCreateEdgeTree(int edge, Page page) throws TransformException {
        if (edge < this.getEdgeCount()) {
            if (edge >= 2) {
                return this.m_pages.get(edge - 2);
            }
            List<EdgeTreeImpl> edgeList = this.m_mainCube.get(page);
            if (edgeList != null && edge < edgeList.size()) {
                return edgeList.get(edge);
            }
        }
        if (this.m_hasEdge != null && edge < this.m_hasEdge.length && this.m_hasEdge[edge]) {
            return this.setEdgeTree(edge, page);
        }
        return null;
    }

    protected EdgeTreeImpl setEdgeTree(int edge, Page page) throws TransformException {
        return null;
    }

    private QDRLite[] _getQDRs(String[][] layout, MemberInterface[][][] pageVals, RowInfo[] column, RowInfo[] row) throws TransformException {
        if (row != null && row.length > 0 && row[0].hasMeasure()) {
            QDRLite[] qdrs = new QDRLite[row.length];
            for (int m = 0; m < row.length; ++m) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row[m].getValues(), column != null ? column[0].getValues() : null);
            }
            return qdrs;
        }
        if (column != null && column[0].hasMeasure()) {
            QDRLite[] qdrs = new QDRLite[column.length];
            for (int m = 0; m < column.length; ++m) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row != null && row.length > 0 ? row[0].getValues() : null, column != null ? column[m].getValues() : null);
            }
            return qdrs;
        }
        QDRLite[] qdrs = new QDRLite[pageVals != null && pageVals.length > 0 && pageVals[0] != null ? pageVals[0].length : 0];
        for (int m = 0; m < qdrs.length; ++m) {
            qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, m), row != null ? row[0].getValues() : null, column != null ? column[0].getValues() : null);
        }
        return qdrs;
    }

    private MemberInterface[][] getNthMeasureTuple(MemberInterface[][][] pageVals, int m) {
        if (pageVals == null) {
            return new MemberInterface[0][];
        }
        MemberInterface[][] retVal = new MemberInterface[pageVals.length][];
        for (int e = 0; e < retVal.length; ++e) {
            retVal[e] = pageVals[e] != null && pageVals[e].length > m ? pageVals[e][m] : new MemberInterface[0];
        }
        return retVal;
    }

    private QDRLite _getQDR(String[][] layout, MemberInterface[][] pages, MemberInterface[] row, MemberInterface[] col) throws TransformException {
        int l;
        QDRLite qdr = new QDRLite();
        if (pages != null) {
            for (int e = 2; e < pages.length + 2; ++e) {
                if (pages[e - 2] == null) continue;
                for (int l2 = 0; l2 < pages[e - 2].length; ++l2) {
                    qdr.addDimMemberPair(layout[e][l2], pages[e - 2][l2].getValue());
                }
            }
        }
        if (row != null) {
            for (l = 0; l < row.length; ++l) {
                qdr.addDimMemberPair(layout[1][l], row[l].getValue());
            }
        }
        if (col != null) {
            for (l = 0; l < col.length; ++l) {
                qdr.addDimMemberPair(layout[0][l], col[l].getValue());
            }
        }
        return qdr;
    }

    public int getEdgeCount() {
        return this.m_pages.size() + this.m_mainCube.getEdgeCount();
    }

    protected void setEdgeTree(int edge, EdgeTreeImpl et, Page page) throws TransformException {
        if (edge >= 2) {
            this._setEdge(edge - 2, this.m_pages, et);
        } else {
            Page myPage = null;
            try {
                myPage = (Page)page.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            List<EdgeTreeImpl> currMain = this.m_mainCube.get(myPage);
            if (currMain == null) {
                currMain = new ArrayList<EdgeTreeImpl>();
            }
            this._setEdge(edge, currMain, et);
            this.m_mainCube.put(myPage, currMain);
        }
    }

    private void _setEdge(int edge, List<EdgeTreeImpl> edgeList, EdgeTreeImpl et) {
        int currEdgeCount = edgeList.size();
        if (edge < currEdgeCount) {
            edgeList.set(edge, et);
        } else {
            for (int i = currEdgeCount; i < edge; ++i) {
                edgeList.add(null);
            }
            edgeList.add(et);
        }
    }

    public EdgeTreeImpl getColumnEdgeTree(Page page) {
        return this.getEdgeTree(0, page);
    }

    public EdgeTreeImpl getRowEdgeTree(Page page) {
        return this.getEdgeTree(1, page);
    }

    public void lockTrees() {
        for (EdgeTreeImpl et : this.m_pages) {
            if (et == null) continue;
            et.lock();
        }
        List cubeVal = null;
        Page key = null;
        for (Map.Entry entry : this.m_mainCube.entrySet()) {
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTreeImpl et : cubeVal) {
                if (et == null) continue;
                et.lock();
            }
        }
    }

    public void invalidate(QDRLite[] qdr, Page page) throws TransformException {
        EdgeTreeImpl et = null;
        int edgeCount = this.getEdgeCount();
        for (int i = 0; i < qdr.length; ++i) {
            for (int e = 0; e < edgeCount; ++e) {
                et = this.getEdgeTree(e, page);
                if (et == null) continue;
                et.invalidate(qdr[i]);
            }
        }
    }

    public QDRAndPosition insert(SliceInsertInfo sliceToInsert, String dataLayer, MemberInterface[] dataMemberInterfaces, Page page, MetadataMap map) throws TransformException {
        EdgeTreeImpl et = null;
        int edgeCount = this.getEdgeCount();
        boolean inserted = false;
        QDRAndPosition allQDRs = new QDRAndPosition();
        for (int e = 0; e < edgeCount; ++e) {
            QDRAndPosition qdrsAdded;
            et = this.getEdgeTree(e, page);
            if (et == null || (qdrsAdded = et.insert(sliceToInsert, dataLayer, dataMemberInterfaces, map)).isEmpty()) continue;
            inserted = true;
            allQDRs.addAll(qdrsAdded);
        }
        return allQDRs;
    }

    public DeleteChanges delete(QDRLite[] qdr, Page page) throws TransformException {
        DeleteChanges delChanges = new DeleteChanges();
        EdgeTreeImpl et = null;
        int edgeCount = this.getEdgeCount();
        for (int i = 0; i < qdr.length; ++i) {
            for (int e = 0; e < edgeCount; ++e) {
                et = this.getEdgeTree(e, page);
                if (et == null) continue;
                delChanges.addAll(et.delete(qdr[i]));
            }
        }
        return delChanges;
    }

    public ArrayList<QDRLite> getRealQDRs() {
        return new ArrayList<QDRLite>();
    }

    protected void storeData(DataCellInterface data, MemberCacheKey cacheKey, Hashtable<MemberCacheKey, Object> memberCache) {
        if (data == null) {
            memberCache.put((MemberCacheKey)cacheKey.clone(), m_nullMarker);
        } else {
            memberCache.put((MemberCacheKey)cacheKey.clone(), data);
        }
    }

    protected String getColumn(InsertInfo[] edgeInserts, int edge) {
        InsertInfo info = InsertInfo.getEdgeInsert(edgeInserts, edge);
        if (info != null) {
            return info.getColumn();
        }
        return null;
    }

    protected class CellInterfaceImpl
    implements DataCellInterface {
        private Object m_value = null;

        public CellInterfaceImpl(Object value) {
            this.m_value = value;
        }

        @Override
        public Object getData(String type) {
            return this.m_value;
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }
    }

    protected static class QDRAndPosition {
        private List<Map<String, Map<String, Object>>> m_qdr = new ArrayList<Map<String, Map<String, Object>>>();
        private List<DeleteChanges.Positions> m_pos = new ArrayList<DeleteChanges.Positions>();

        protected QDRAndPosition() {
        }

        protected void addAll(QDRAndPosition list) {
            List<Map<String, Map<String, Object>>> qdrs = list.getQDR();
            List<DeleteChanges.Positions> pos = list.getPositions();
            this.m_qdr.addAll(qdrs);
            this.m_pos.addAll(pos);
        }

        protected boolean isEmpty() {
            return this.m_qdr.isEmpty();
        }

        protected void add(Map<String, Map<String, Object>> qdr, DeleteChanges.Positions pos) {
            this.m_qdr.add(qdr);
            this.m_pos.add(pos);
        }

        public List<Map<String, Map<String, Object>>> getQDR() {
            return this.m_qdr;
        }

        public List<DeleteChanges.Positions> getPositions() {
            return this.m_pos;
        }
    }
}

