/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class GroupComponentInfo
extends ComponentInfo {
    private static final long serialVersionUID = 1L;
    private int _group;
    private int m_edge;
    private int m_slice;
    private int m_layer = 0;

    public GroupComponentInfo(int group) {
        this._group = group;
        this.m_edge = 0;
        this.m_slice = group;
    }

    public GroupComponentInfo(int group, int edge, int slice) {
        this._group = group;
        this.m_edge = edge;
        this.m_slice = slice;
    }

    public GroupComponentInfo(int group, int layer, int edge, int slice) {
        this._group = group;
        this.m_edge = edge;
        this.m_slice = slice;
        this.m_layer = layer;
    }

    @Override
    public Object clone() {
        return new GroupComponentInfo(this._group, this.m_edge, this.m_slice);
    }

    public int getLayer() {
        return this.m_layer;
    }

    public int getGroup() {
        return this._group;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public int getSlice() {
        return this.m_slice;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GroupComponentInfo)) {
            return false;
        }
        return this.getGroup() == ((GroupComponentInfo)o).getGroup() && this.getEdge() == ((GroupComponentInfo)o).getEdge() && this.getSlice() == ((GroupComponentInfo)o).getSlice();
    }

    @Override
    public QDR getQDR(DataAccess dataAccess, int flags) {
        try {
            return dataAccess.getSliceQDR(this.m_edge, this.m_slice, flags);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        return this._group ^ this._group >> 32;
    }

    public String toString() {
        return "group=" + this._group + ",layer=" + this.m_layer;
    }
}

