/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.ErrorHandlerCallback;

public class Timer
implements ErrorHandlerCallback {
    private static final String CRLF = "\r\n";
    private static final String INTERVAL = "Interval ";
    private static final String PAREN_OPEN = "[";
    private static final String PAREN_CLOSE = "]";
    private static final String RESTART = "Restart  ";
    private static final String SPACE = " ";
    private static final String START = "Start    ";
    private static final String STATE = "State: ";
    private static final String STOP = "Stop     ";
    private static final String TAB = "\t";
    private static final String TIME_INTERVAL = "Interval: ";
    private static final String TIME_TOTAL = "Total: ";
    private static final String TIMER = "Timer: ";
    public static final int OPTION_DATE = 1;
    public static final int OPTION_TIME = 2;
    public static final int OPTION_INTERVAL = 4;
    public static final int OPTION_TOTAL = 8;
    public static final int OPTION_NAME = 16;
    public static final int OPTION_ALL = 31;
    public static final int OPTION_DATE_TIME = 3;
    public static final int OPTION_DEFAULT = 28;
    public static final int INDENT_SPACES = 3;
    public static final String TIMER_NOT_STARTED = "Timer not started.";
    private String m_strName = "My Timer!";
    private Date m_dateLast = null;
    private long m_lTotal = 0L;
    private boolean m_bStarted = false;
    private boolean m_bEnabled = true;
    private int m_nIndentLevel = 0;
    private int m_nIndentSpaces = 3;
    private long m_lOptions = 28L;
    private transient ErrorHandler m_errorHandler = new DefaultErrorHandler();
    private transient PrintWriter m_printWriter = new PrintWriter(System.out);

    public Timer() {
    }

    public Timer(String strName) {
        this.setName(strName);
    }

    public Timer(String strName, long lOptions) {
        this.setName(strName);
        this.setOptions(lOptions);
    }

    public static void main(String[] argv) {
        int i;
        Timer timer = new Timer("Loops!", 28L);
        timer.start("Loop1 is starting.");
        for (i = 0; i < 20000; ++i) {
            if (i != 10000) continue;
            timer.interval("Loop1 has gone half way!");
        }
        timer.stop("Loop1 has ended.");
        timer.setIndentLevel(2);
        timer.setIndentSpaces(2);
        timer.setOptions(10L);
        timer.restart("Loop2 is starting.");
        for (i = 0; i < 50000; ++i) {
            if (i != 25000) continue;
            timer.interval("Loop2 has gone half way!");
        }
        timer.stop("Loop2 has ended.");
    }

    public PrintWriter getPrintWriter() {
        return this.m_printWriter;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.m_printWriter = printWriter;
    }

    public String getName() {
        return this.m_strName;
    }

    public void setName(String strName) {
        this.m_strName = strName;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bEnabled = bEnabled;
    }

    public int getIndentLevel() {
        return this.m_nIndentLevel;
    }

    public void setIndentLevel(int nIndentLevel) {
        this.m_nIndentLevel = nIndentLevel;
    }

    public int getIndentSpaces() {
        return this.m_nIndentSpaces;
    }

    public void setIndentSpaces(int nIndentSpaces) {
        this.m_nIndentSpaces = nIndentSpaces;
    }

    public long getOptions() {
        return this.m_lOptions;
    }

    public void setOptions(long lOptions) {
        this.m_lOptions = lOptions;
    }

    public Date getLastDate() {
        return this.m_dateLast;
    }

    public long getTotal() {
        return this.m_lTotal;
    }

    public boolean isStarted() {
        return this.m_bStarted;
    }

    public boolean start(String strDescription) {
        this.setLastDate(new Date());
        this.setTotal(0L);
        this.setStarted(true);
        this.formatOutput(START, 0L, strDescription, this.getLastDate());
        return true;
    }

    public boolean interval(String strDescription) {
        if (!this.isStarted() && this.getErrorHandler() != null) {
            this.getErrorHandler().log(TIMER_NOT_STARTED, this.getClass().getName(), "interval(String)");
            return false;
        }
        long lInterval = this.updateTimer();
        this.setTotal(this.getTotal() + lInterval);
        this.formatOutput(INTERVAL, lInterval, strDescription, this.getLastDate());
        return true;
    }

    public boolean stop(String strDescription) {
        long lInterval = this.updateTimer();
        this.setTotal(this.getTotal() + lInterval);
        this.formatOutput(STOP, lInterval, strDescription, this.getLastDate());
        this.setStarted(false);
        return true;
    }

    public boolean restart(String strDescription) {
        long lInterval = this.updateTimer();
        this.formatOutput(RESTART, lInterval, strDescription, this.getLastDate());
        this.setStarted(true);
        return true;
    }

    public String formatDateTime(Date date, int nStyle, Locale locale) {
        String strOutput = "";
        long lDateUsed = 3L & this.getOptions();
        if (date != null && lDateUsed != 0L) {
            DateFormat dateFormat = null;
            switch ((int)lDateUsed) {
                case 3: {
                    dateFormat = DateFormat.getDateTimeInstance(nStyle, nStyle, locale);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getDateInstance(nStyle, locale);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getTimeInstance(nStyle, locale);
                }
            }
            dateFormat.setTimeZone(TimeZone.getTimeZone("EST"));
            strOutput = strOutput + PAREN_OPEN;
            strOutput = strOutput + dateFormat.format(date);
            strOutput = strOutput + "] ";
        }
        return strOutput;
    }

    @Override
    public void addErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    @Override
    public void removeErrorHandler() {
        this.m_errorHandler = null;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    protected boolean formatOutput(String strState, long lInterval, String strDescription, Date date) {
        long lOptions = this.getOptions();
        StringBuffer strOutput = new StringBuffer("");
        if (this.isEnabled()) {
            int nSpaces = this.getIndentLevel() * this.getIndentSpaces();
            for (int nIndex = 0; nIndex < nSpaces; ++nIndex) {
                strOutput.append(SPACE);
            }
            strOutput.append(this.formatDateTime(date, 2, Locale.US));
            if (this.getName() != null && (lOptions & 0x10L) != 0L) {
                strOutput.append(TIMER + this.getName() + TAB);
            }
            strOutput.append(STATE + strState + TAB);
            if ((lOptions & 4L) != 0L) {
                strOutput.append(TIME_INTERVAL + lInterval + TAB);
            }
            if ((lOptions & 8L) != 0L) {
                strOutput.append(TIME_TOTAL + this.getTotal() + TAB);
            }
            if (strDescription != null) {
                strOutput.append(strDescription);
            }
            if (this.getPrintWriter() != null) {
                this.getPrintWriter().println(strOutput.toString());
                this.getPrintWriter().flush();
            }
        }
        return true;
    }

    protected void setTotal(long lTime) {
        this.m_lTotal = lTime;
    }

    protected void setStarted(boolean bStarted) {
        this.m_bStarted = bStarted;
    }

    protected void setLastDate(Date date) {
        this.m_dateLast = date;
    }

    protected long updateTimer() {
        Date dateCurrent = new Date();
        Date dateLast = this.getLastDate();
        if (dateLast == null && this.getErrorHandler() != null) {
            this.getErrorHandler().log(TIMER_NOT_STARTED, this.getClass().getName(), "updateTimer()");
            return 0L;
        }
        long lInterval = dateCurrent.getTime() - dateLast.getTime();
        this.setLastDate(dateCurrent);
        return lInterval;
    }
}

