/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.RowsetRecord;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;

@Deprecated
public class RowsetCollection
implements Collection<RowsetRecord> {
    protected RowProjection m_projection = null;
    protected String[] m_cols = null;
    protected int m_size = -1;
    protected String[] m_colsForColumnType = null;
    protected HashMap<String, String> m_map = null;
    protected Map<String, Map<String, String>> m_interfaceAttrs = null;
    protected List<RowsetRecord> m_list = new ArrayList<RowsetRecord>();
    protected List<String> m_keys = new ArrayList<String>();

    public RowsetCollection(RowProjection projection) {
        this.m_projection = projection;
        this.m_cols = this.m_projection.getRowIterator().getColumns();
    }

    protected int getKeyCount() {
        return this.m_keys.size();
    }

    protected Object getKey(int pos) {
        if (pos > -1 && pos < this.m_keys.size()) {
            return this.m_keys.get(pos);
        }
        return null;
    }

    protected int addKey(String key) {
        int pos = this.getKeyPosition(key);
        if (pos == -1) {
            this.m_keys.add(key);
            pos = this.getKeyPosition(key);
        }
        return pos;
    }

    protected Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : keys) {
            keys.add(key);
        }
        return keys;
    }

    protected int getKeyPosition(Object key) {
        if (key instanceof String) {
            return this.m_keys.indexOf(key);
        }
        return -1;
    }

    public void setInterfaceAttrMap(Map<String, Map<String, String>> interfaceAttrs) {
        this.m_interfaceAttrs = interfaceAttrs;
    }

    public void setColumnMap(HashMap<String, String> map) {
        this.m_map = map;
    }

    public String getMappedKey(String key) {
        String retVal;
        if (this.m_map != null && (retVal = this.m_map.get(key)) != null) {
            return retVal;
        }
        return key;
    }

    public String[] getColumns() {
        return this.m_cols;
    }

    public boolean isDataItem(String col) throws TransformException {
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        String columnType = "value";
        if (dataItems != null) {
            for (int i = 0; i < dataItems.length; ++i) {
                String name;
                if (dataItems[i] == null || !col.equals(name = (String)dataItems[i].getMetadata(columnType))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        if (this.m_size == -1) {
            try {
                RowIterator iter = this.m_projection.getRowIterator();
                this.m_size = 0;
                while (iter.hasMoreRows()) {
                    ++this.m_size;
                    iter.nextRow();
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return this.m_size;
    }

    @Override
    public boolean contains(Object o) {
        for (RowsetRecord record : this) {
            if (!record.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (RowsetRecord record : c) {
            if (this.contains(record)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RowsetCollection)) {
            return false;
        }
        RowsetCollection coll = (RowsetCollection)o;
        if (this.size() == coll.size()) {
            return this.containsAll(coll);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (RowsetRecord record : this) {
            hash += record.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(RowsetRecord o) {
        return this.m_list.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends RowsetRecord> c) {
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] recs = new RowsetRecord[this.size()];
        int count = 0;
        for (RowsetRecord record : this) {
            recs[count++] = record;
        }
        return recs;
    }

    public RowsetRecord[] toArray(Object[] obj) {
        return (RowsetRecord[])this.toArray();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        if (this.m_list != null) {
            for (RowsetRecord val : this) {
                if (val == null) continue;
                val.clear();
            }
            this.m_list.clear();
            this.m_list = null;
        }
        this.m_projection = null;
        this.m_cols = null;
        int m_size = -1;
        this.m_colsForColumnType = null;
        if (this.m_map != null) {
            this.m_map.clear();
            this.m_map = null;
        }
        if (this.m_interfaceAttrs != null) {
            this.m_interfaceAttrs.clear();
            this.m_interfaceAttrs = null;
        }
    }

    @Override
    public Iterator<RowsetRecord> iterator() {
        return new RowsetIterator(this, this.m_projection.getRowIterator());
    }

    protected LayerInterface getLayer(String col) {
        return this.m_projection.getLayer(col);
    }

    protected String getInterfaceAttrName(String column, String type) {
        if (this.m_interfaceAttrs == null) {
            return null;
        }
        Map<String, String> colMap = this.m_interfaceAttrs.get(column);
        if (colMap != null) {
            return colMap.get(type);
        }
        return null;
    }

    public class RowsetIterator
    implements Iterator<RowsetRecord> {
        protected RowsetCollection m_coll = null;
        protected RowIterator m_iter = null;

        public RowsetIterator(RowsetCollection c, RowIterator iter) {
            this.m_coll = c;
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.m_iter.hasMoreRows();
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
        }

        @Override
        public RowsetRecord next() {
            try {
                RowsetRecord rec = new RowsetRecord(this.m_iter, this.m_coll);
                return rec;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
    }
}

