/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.util.xml.NoSuchObjectException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class CommonHelper {
    public static Color readColor(ObjectNode node) {
        if (node.isReference()) {
            try {
                return (Color)node.getReference();
            }
            catch (NoSuchObjectException nsoe) {
                return null;
            }
        }
        Color _color = null;
        try {
            int _rgb = node.getPropertyValueAsInteger("rgb");
            _color = new Color(_rgb);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (_color != null) {
            node.registerObject(_color);
        }
        return _color;
    }

    public static void writeColor(ObjectNode node, Color color) {
        if (color != null) {
            if (node == null) {
                node = new ObjectNode(color.getClass().getName());
            }
            node.addProperty("rgb", color.getRGB());
        }
    }

    public static Font readFont(ObjectNode node) {
        if (node.isReference()) {
            try {
                return (Font)node.getReference();
            }
            catch (NoSuchObjectException nsoe) {
                return null;
            }
        }
        Font _font = null;
        try {
            String _name = node.getPropertyValueAsString("name");
            int _style = node.getPropertyValueAsInteger("style");
            int _size = node.getPropertyValueAsInteger("size");
            _font = new Font(_name, _style, _size);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (_font != null) {
            node.registerObject(_font);
        }
        return _font;
    }

    public static void writeFont(ObjectNode node, Font font) {
        if (font != null) {
            if (node == null) {
                node = new ObjectNode(font.getClass().getName());
            }
            node.addProperty("name", font.getName());
            node.addProperty("style", font.getStyle());
            node.addProperty("size", font.getSize());
        }
    }

    public static Rectangle readRectangle(ObjectNode node) {
        if (node.isReference()) {
            try {
                return (Rectangle)node.getReference();
            }
            catch (NoSuchObjectException nsoe) {
                return null;
            }
        }
        Rectangle _rect = null;
        try {
            int _x = node.getPropertyValueAsInteger("x");
            int _y = node.getPropertyValueAsInteger("y");
            int _width = node.getPropertyValueAsInteger("width");
            int _height = node.getPropertyValueAsInteger("height");
            _rect = new Rectangle(_x, _y, _width, _height);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (_rect != null) {
            node.registerObject(_rect);
        }
        return _rect;
    }

    public static void writeRectangle(ObjectNode node, Rectangle rect) {
        if (rect != null) {
            if (node == null) {
                node = new ObjectNode(rect.getClass().getName());
            }
            node.addProperty("x", rect.getLocation().x);
            node.addProperty("y", rect.getLocation().y);
            node.addProperty("width", rect.getSize().width);
            node.addProperty("height", rect.getSize().height);
        }
    }

    public static Vector readStringVector(ObjectNode node) {
        if (node.isReference()) {
            try {
                return (Vector)node.getReference();
            }
            catch (NoSuchObjectException nsoe) {
                return null;
            }
        }
        Vector<String> _vector = new Vector<String>();
        try {
            int _size = node.getPropertyValueAsInteger("size");
            for (int i = 0; i < _size; ++i) {
                _vector.addElement(node.getPropertyValueAsString("element_" + i));
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        node.registerObject(_vector);
        return _vector;
    }

    public static void writeStringVector(ObjectNode node, Vector vec) {
        if (vec != null) {
            if (node == null) {
                node = new ObjectNode("StringVector");
            }
            node.addProperty("size", vec.size());
            for (int i = 0; i < vec.size(); ++i) {
                node.addProperty("element_" + i, (String)vec.elementAt(i));
            }
        }
    }
}

