/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ParameterToXMLConverter;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.express.olapi.data.full.SourceToXMLConverterPrior10105;
import oracle.express.olapi.data.full.SourceToXMLConverterSince10105;
import oracle.olapi.Debug;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelSolutionDefinition;
import oracle.olapi.data.source.NullSourceDefinition;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceDefinitionTraverser;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.version.Version;

public abstract class SourceToXMLConverter
extends SourceConverter {
    private DefinitionManager m_definitionManager = null;
    private ParameterToXMLConverter m_ParameterToXMLConverter = new ParameterToXMLConverter();
    private boolean m_NeedToSendDefinitions = false;
    private boolean m_NeedToRespecifyCursorManagers = false;
    private List m_CursorManagerInfoList = null;
    private MethodArguments m_MethodArguments = null;
    private SourceDefinitionTraverser m_Traverser = null;

    public static SourceToXMLConverter createSourceToXMLConverter(Version version, DefinitionManager definitionManager) {
        if (version.supportsDefinitionManagerTag()) {
            return new SourceToXMLConverterSince10105(definitionManager);
        }
        return new SourceToXMLConverterPrior10105(definitionManager);
    }

    protected SourceToXMLConverter(DefinitionManager definitionManager) {
        super(definitionManager);
        this.m_definitionManager = definitionManager;
        this.m_CursorManagerInfoList = new ArrayList(10);
        this.m_Traverser = new SourceDefinitionTraverser(this.getTransaction(), null, new TraversalVisitor());
    }

    protected Version getServerVersion() {
        return this.m_definitionManager.getDataProvider().getServerVersion();
    }

    @Override
    protected DefinitionManager getDefinitionManager() {
        return this.m_definitionManager;
    }

    protected ParameterToXMLConverter getParameterToXMLConverter() {
        return this.m_ParameterToXMLConverter;
    }

    protected MethodArguments getMethodArguments() {
        return this.m_MethodArguments;
    }

    protected boolean needToSendDefinitions() {
        return this.m_NeedToSendDefinitions;
    }

    protected void setNeedToSendDefinitions(boolean bl) {
        this.m_NeedToSendDefinitions = bl;
    }

    @Override
    protected boolean needToRespecifyCursorManagers(boolean bl) {
        return this.m_NeedToRespecifyCursorManagers || bl;
    }

    protected void setNeedToRespecifyCursorManagers(boolean bl) {
        this.m_NeedToRespecifyCursorManagers = bl;
    }

    SourceDefinitionTraverser getTraverser() {
        return this.m_Traverser;
    }

    @Override
    protected void setWriter(XMLWriter xMLWriter) {
        super.setWriter(xMLWriter);
        this.getParameterToXMLConverter().setWriter(xMLWriter);
    }

    @Override
    protected void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        this.getTraverser().setTransaction(transaction);
    }

    protected abstract boolean needToSend(TransactionalObject var1);

    protected abstract void queueForSending(TransactionalObject var1);

    protected final void queueObjectsInDefinitionTree(SourceDefinition sourceDefinition, Source[] sourceArray) {
        for (int i = 0; i < sourceArray.length; ++i) {
            this.getTraverser().traverseDefinitionTree(sourceArray[i].getDefinition());
        }
        this.getTraverser().traverseDefinitionTree(sourceDefinition);
    }

    protected final void writeXML(Object object) {
        if (object instanceof Model) {
            this.visitModel((Model)object);
        } else if (object instanceof SourceDefinition) {
            ((SourceDefinition)object).acceptVisitor(this, null);
        } else if (object instanceof Parameter) {
            this.getParameterToXMLConverter().visitParameter((Parameter)object);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected void beginElement(String string) {
        this.getWriter().beginElement(string);
    }

    protected void closeTag() {
        this.getWriter().closeTag();
    }

    protected void endElement() {
        this.getWriter().endElement();
    }

    protected void endElement(String string, boolean bl) {
        if (bl) {
            this.closeTag();
        }
        this.getWriter().endElement(string);
        this.getWriter().newLine();
    }

    protected void appendAttribute(String string, String string2) {
        this.getWriter().appendAttribute(string, string2);
    }

    protected void appendAttribute(String string, SourceDefinition sourceDefinition) {
        this.getWriter().appendAttribute(string, sourceDefinition.getSource().getID());
    }

    private void appendBooleanAttribute(String string, boolean bl) {
        SourceToXMLConverter.appendBooleanAttribute(this.getWriter(), string, bl);
    }

    private static void appendBooleanAttribute(XMLWriter xMLWriter, String string, boolean bl) {
        if (bl) {
            xMLWriter.appendAttribute(string, "True");
        } else {
            xMLWriter.appendAttribute(string, "False");
        }
    }

    private void appendComparisonRuleAttribute(int n) {
        if (0 == n) {
            this.appendAttribute("ComparisonRule", "Select");
        } else if (3 == n) {
            this.appendAttribute("ComparisonRule", "Remove");
        } else if (1 == n || 1 == n) {
            this.appendAttribute("ComparisonRule", "Asc");
        } else if (4 == n) {
            this.appendAttribute("ComparisonRule", "AscNullsFirst");
        } else if (2 == n || 2 == n) {
            this.appendAttribute("ComparisonRule", "Desc");
        } else if (5 == n) {
            this.appendAttribute("ComparisonRule", "DescNullsLast");
        }
    }

    @Override
    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        this.beginElement("AliasDef");
        this.appendAttribute("ID", aliasDefinition);
        this.appendAttribute("BaseID", aliasDefinition.getBase());
        this.endElement("AliasDef", true);
        return null;
    }

    @Override
    public Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
        this.beginElement("DistinctDef");
        this.appendAttribute("ID", distinctDefinition);
        this.appendAttribute("BaseID", distinctDefinition.getBase());
        this.endElement("DistinctDef", true);
        return null;
    }

    @Override
    public Object visitNullDefinition(NullSourceDefinition nullSourceDefinition, Object object) {
        this.beginElement("NullDef");
        this.appendAttribute("ID", nullSourceDefinition);
        this.appendAttribute("BaseID", nullSourceDefinition.getBase());
        this.endElement("NullDef", true);
        return null;
    }

    @Override
    public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        this.beginElement("ExtractDef");
        this.appendAttribute("ID", extractDefinition);
        this.appendAttribute("BaseID", extractDefinition.getBase());
        this.endElement("ExtractDef", true);
        return null;
    }

    @Override
    public Object visitParameterizedSourceDefinition(ParameterizedSourceDefinition parameterizedSourceDefinition, Object object) {
        this.beginElement("ParamDef");
        this.appendAttribute("ID", parameterizedSourceDefinition);
        this.appendAttribute("ParamID", parameterizedSourceDefinition.getParameter().getID());
        this.endElement("ParamDef", true);
        return null;
    }

    @Override
    public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        boolean bl = this.getServerVersion().supportsZeroBasedPositions();
        if (positionDefinition.isZeroBased() && !bl) {
            throw new UnsupportedOperationException();
        }
        this.beginElement("PositionDef");
        this.appendAttribute("ID", positionDefinition);
        this.appendAttribute("BaseID", positionDefinition.getBase());
        if (bl) {
            this.appendBooleanAttribute("ZeroBased", positionDefinition.isZeroBased());
        }
        this.endElement("PositionDef", true);
        return null;
    }

    @Override
    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        this.beginElement("ValueDef");
        this.appendAttribute("ID", valueDefinition);
        this.appendAttribute("BaseID", valueDefinition.getBase());
        this.appendAttribute("InputID", valueDefinition.getInput());
        this.endElement("ValueDef", true);
        return null;
    }

    @Override
    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        this.beginElement("JoinDef");
        this.appendAttribute("ID", joinDefinition);
        this.appendAttribute("BaseID", joinDefinition.getBase());
        this.appendAttribute("JoineeID", joinDefinition.getJoined());
        this.appendAttribute("ComparisonID", joinDefinition.getComparison());
        this.appendComparisonRuleAttribute(joinDefinition.getComparisonRule());
        this.appendBooleanAttribute("IsVisible", joinDefinition.isVisible());
        this.endElement("JoinDef", true);
        return null;
    }

    @Override
    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        this.beginElement("RecursiveJoinDef");
        this.appendAttribute("ID", recursiveJoinDefinition);
        this.appendAttribute("BaseID", recursiveJoinDefinition.getBase());
        this.appendAttribute("JoineeID", recursiveJoinDefinition.getJoined());
        this.appendAttribute("ComparisonID", recursiveJoinDefinition.getComparison());
        this.appendAttribute("ParentID", recursiveJoinDefinition.getParent());
        this.appendComparisonRuleAttribute(recursiveJoinDefinition.getComparisonRule());
        this.appendBooleanAttribute("ParentsFirst", recursiveJoinDefinition.isParentsFirst());
        this.appendBooleanAttribute("ParentsRestrictedToBase", recursiveJoinDefinition.isParentsRestrictedToBase());
        this.appendBooleanAttribute("IsVisible", recursiveJoinDefinition.isVisible());
        this.appendAttribute("MaxIterations", Integer.toString(recursiveJoinDefinition.getMaxRecursions()));
        this.endElement("RecursiveJoinDef", true);
        return null;
    }

    @Override
    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        List list = constantListDefinition.getTuples();
        Object var4_4 = null;
        if (!list.isEmpty()) {
            var4_4 = list.get(0);
        }
        this.beginElement("ConstListDef");
        this.appendAttribute("ID", constantListDefinition);
        if (var4_4 instanceof SourceDefinition) {
            this.appendAttribute("Datatype", "SourceDefinition");
            this.closeTag();
            for (int i = 0; i < list.size(); ++i) {
                SourceDefinition sourceDefinition = (SourceDefinition)list.get(i);
                this.beginElement("Element");
                this.appendAttribute("Value", sourceDefinition.getSource().getID());
                this.endElement();
            }
        } else if (var4_4 instanceof ArrayList) {
            this.closeTag();
            ArrayList arrayList = var4_4;
            Object object2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = arrayList.get(i);
                this.beginElement("Datatype");
                if (object2 instanceof String) {
                    this.appendAttribute("ID", "Wstring");
                } else if (object2 instanceof Date) {
                    this.appendAttribute("ID", "Date");
                } else if (object2 instanceof Boolean) {
                    this.appendAttribute("ID", "Boolean");
                } else if (object2 instanceof Integer) {
                    this.appendAttribute("ID", "LongLong");
                } else if (object2 instanceof Double) {
                    this.appendAttribute("ID", "Double");
                } else if (object2 instanceof Float) {
                    this.appendAttribute("ID", "Float");
                } else if (object2 instanceof Short) {
                    this.appendAttribute("ID", "Short");
                }
                this.endElement();
                for (int j = 0; j < list.size(); ++j) {
                    arrayList = (ArrayList)list.get(j);
                    object2 = arrayList.get(i);
                    if (object2 instanceof Date) {
                        this.beginElement("Element");
                        Date date = (Date)object2;
                        long l = this.getServerVersion().supportsNativeDate() ? date.getTime() / 1000L : (long)((int)(date.getTime() / 1000L));
                        this.appendAttribute("Value", Long.toString(l));
                        this.endElement();
                        continue;
                    }
                    if (object2 instanceof Boolean) {
                        this.beginElement("Element");
                        if (((Boolean)object2).booleanValue()) {
                            this.appendAttribute("Value", "True");
                        } else {
                            this.appendAttribute("Value", "False");
                        }
                        this.endElement();
                        continue;
                    }
                    this.beginElement("Element");
                    this.appendAttribute("Value", object2.toString());
                    this.endElement();
                }
            }
        } else {
            if (var4_4 instanceof String) {
                this.appendAttribute("Datatype", "Wstring");
            } else if (var4_4 instanceof Date) {
                this.appendAttribute("Datatype", "Date");
            } else if (var4_4 instanceof Boolean) {
                this.appendAttribute("Datatype", "Boolean");
            } else if (var4_4 instanceof Integer) {
                this.appendAttribute("Datatype", "Long");
            } else if (var4_4 instanceof Double) {
                this.appendAttribute("Datatype", "Double");
            } else if (var4_4 instanceof Float) {
                this.appendAttribute("Datatype", "Float");
            } else {
                this.appendAttribute("Datatype", "Short");
            }
            this.closeTag();
            if (var4_4 instanceof Date) {
                for (int i = 0; i < list.size(); ++i) {
                    this.beginElement("Element");
                    Date date = (Date)list.get(i);
                    long l = this.getServerVersion().supportsNativeDate() ? date.getTime() / 1000L : (long)((int)(date.getTime() / 1000L));
                    this.appendAttribute("Value", Long.toString(l));
                    this.endElement();
                }
            } else if (var4_4 instanceof Boolean) {
                for (int i = 0; i < list.size(); ++i) {
                    this.beginElement("Element");
                    if (((Boolean)list.get(i)).booleanValue()) {
                        this.appendAttribute("Value", "True");
                    } else {
                        this.appendAttribute("Value", "False");
                    }
                    this.endElement();
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.beginElement("Element");
                    this.appendAttribute("Value", list.get(i).toString());
                    this.endElement();
                }
            }
        }
        this.endElement("ConstListDef", false);
        return null;
    }

    @Override
    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        this.beginElement("RangeDef");
        this.appendAttribute("ID", rangeDefinition);
        this.appendAttribute("StartID", rangeDefinition.getBottom());
        this.appendAttribute("EndID", rangeDefinition.getTop());
        this.endElement("RangeDef", true);
        return null;
    }

    @Override
    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        this.beginElement("HiddenDef");
        this.appendAttribute("ID", hiddenDefinition);
        this.appendAttribute("MetadataProviderID", hiddenDefinition.getSource().getMetadataProvider().getID());
        this.appendAttribute("PersistentId", hiddenDefinition.getSource().getPersistentID());
        this.endElement("HiddenDef", true);
        return null;
    }

    @Override
    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        dynamicDefinition.getTemplate().addCursorLock(this.getCursorLock());
        this.beginElement("DynamicDef");
        this.appendAttribute("ID", dynamicDefinition);
        this.appendAttribute("CurrentID", dynamicDefinition.getCurrent(this.getTransaction()));
        if (this.getServerVersion().supportsRecommendedMaterializations() && dynamicDefinition.isMaterializationRecommended()) {
            this.appendBooleanAttribute("Materialize", true);
        }
        this.endElement("DynamicDef", true);
        return null;
    }

    @Override
    public Object visitModelSolutionDefinition(ModelSolutionDefinition modelSolutionDefinition, Object object) {
        this.beginElement("ModelSolutionDef");
        this.appendAttribute("ID", modelSolutionDefinition);
        this.appendAttribute("DefaultValuesID", modelSolutionDefinition.getDefaultValuesDefinition());
        this.appendAttribute("ModelID", modelSolutionDefinition.getModel().getID());
        this.endElement("ModelSolutionDef", true);
        return null;
    }

    protected void visitModel(Model model) {
        if (model instanceof CustomModel) {
            this.visitCustomModel((CustomModel)model);
        }
    }

    protected void visitCustomModel(CustomModel customModel) {
        this.beginElement("CustomModel");
        this.appendAttribute("ID", customModel.getID());
        this.appendAttribute("TypeID", customModel.getType().getID());
        this.closeTag();
        this.appendSourceList("InputRef", customModel.getInputs());
        this.appendSourceList("OutputRef", customModel.getOutputs());
        for (Model model : customModel.getParentModels()) {
            this.beginElement("ParentModelRef");
            this.appendAttribute("ID", model.getID());
            this.endElement();
        }
        customModel.writeXMLForAssignments(this.getWriter(), this.getTransaction());
        this.endElement("CustomModel", false);
    }

    protected void appendSourceList(String string, List list) {
        for (Source source : list) {
            this.beginElement(string);
            this.appendAttribute("ID", source.getID());
            this.endElement();
        }
    }

    protected void populateParametersList(List list) {
        Set set = this.getParameterToXMLConverter().getVisitedParameters();
        if (list == null) {
            return;
        }
        list.clear();
        if (set.isEmpty()) {
            return;
        }
        list.addAll(set);
        for (int i = 1; i < list.size(); ++i) {
            int n;
            Parameter parameter = (Parameter)list.get(i);
            for (n = i - 1; n >= 0; --n) {
                Parameter parameter2 = (Parameter)list.get(n);
                if (parameter.getID().compareTo(parameter2.getID()) > 0) break;
                list.set(n + 1, list.get(n));
            }
            list.set(n + 1, parameter);
        }
    }

    protected void addCursorManagerInfo(SourceDefinition sourceDefinition, Source[] sourceArray) {
        CursorManagerInfo cursorManagerInfo = new CursorManagerInfo(sourceDefinition, sourceArray);
        this.m_CursorManagerInfoList.add(cursorManagerInfo);
    }

    protected List getCursorManagerInfoList() {
        return this.m_CursorManagerInfoList;
    }

    @Override
    protected boolean localConvertDefinitionTree(SourceDefinition sourceDefinition, Source[] sourceArray, boolean bl, boolean bl2, List list) {
        this.getParameterToXMLConverter().getVisitedParameters().clear();
        this.addCursorManagerInfo(sourceDefinition, sourceArray);
        this.queueObjectsInDefinitionTree(sourceDefinition, sourceArray);
        this.populateParametersList(list);
        boolean bl3 = bl2 || this.needToSendDefinitions();
        this.setNeedToSendDefinitions(bl3);
        return bl3;
    }

    @Override
    protected abstract void recover();

    @Override
    protected void localReset() {
        this.setNeedToSendDefinitions(false);
        this.getParameterToXMLConverter().getVisitedParameters().clear();
        this.getTraverser().reset();
        this.m_CursorManagerInfoList.clear();
        this.m_MethodArguments = null;
        this.success();
        this.getParameterToXMLConverter().setWriter(this.getWriter());
    }

    @Override
    protected abstract void mergeChildTransactionOnCommit(SourceConverter var1);

    @Override
    protected abstract XMLWriter finishup(InterfaceStub var1, Properties var2);

    void convertParametersForCreateCursorManager(boolean bl, long l, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        MethodArgumentsForCreateCursorManager methodArgumentsForCreateCursorManager = new MethodArgumentsForCreateCursorManager();
        this.m_MethodArguments = methodArgumentsForCreateCursorManager;
        methodArgumentsForCreateCursorManager.sendGenerationInfoType = bl;
        methodArgumentsForCreateCursorManager.valueOfGenerationInfoType = l;
        methodArgumentsForCreateCursorManager.sendCreateCountColumn = bl2;
        methodArgumentsForCreateCursorManager.valueOfCreateCountColumn = bl3;
        methodArgumentsForCreateCursorManager.sendGenerateSQL = bl4;
        methodArgumentsForCreateCursorManager.valueOfGenerateSQL = bl5;
    }

    void convertParametersForPrepare3(long[] lArray, boolean bl) {
        MethodArgumentsForPrepare3 methodArgumentsForPrepare3 = new MethodArgumentsForPrepare3();
        this.m_MethodArguments = methodArgumentsForPrepare3;
        methodArgumentsForPrepare3.cursorManagerIDArray = lArray;
        methodArgumentsForPrepare3.generateSQL = bl;
    }

    protected class TraversalVisitor
    extends SourceDefinitionTraverser.SimpleTraversalVisitor {
        protected TraversalVisitor() {
        }

        @Override
        public void visitDefinition(SourceDefinition sourceDefinition) {
            if (SourceToXMLConverter.this.needToSend(sourceDefinition)) {
                SourceToXMLConverter.this.setNeedToSendDefinitions(true);
                SourceToXMLConverter.this.queueForSending(sourceDefinition);
            }
        }

        @Override
        public void visitParameter(Parameter parameter) {
            SourceToXMLConverter.this.getParameterToXMLConverter().addParameter(parameter);
            if (SourceToXMLConverter.this.needToSend(parameter)) {
                SourceToXMLConverter.this.setNeedToSendDefinitions(true);
                SourceToXMLConverter.this.queueForSending(parameter);
            }
        }

        @Override
        public void visitMdmObject(MdmObject mdmObject) {
            ArrayList arrayList = new ArrayList();
            boolean bl = SourceToXMLConverter.this.getMetadataToXMLConverter().addMetadataObject(mdmObject, arrayList);
            if (bl) {
                SourceToXMLConverter.this.setNeedToSendDefinitions(true);
            }
            SourceToXMLConverter.this.getTraverser().traverseDefinitionTree(arrayList);
        }

        @Override
        public void visitMtmObject(MtmObject mtmObject) {
            ArrayList arrayList = new ArrayList();
            boolean bl = SourceToXMLConverter.this.getMetadataToXMLConverter().addMetadataObject(mtmObject, arrayList);
            if (bl) {
                SourceToXMLConverter.this.setNeedToSendDefinitions(true);
            }
            Debug._assert(arrayList.isEmpty());
        }

        @Override
        public void visitModel(Model model) {
            if (model instanceof MdmModel) {
                this.visitMdmObject((MdmModel)model);
            } else if (SourceToXMLConverter.this.needToSend(model)) {
                SourceToXMLConverter.this.setNeedToSendDefinitions(true);
                SourceToXMLConverter.this.queueForSending((CustomModel)model);
            }
        }
    }

    protected static class MethodArgumentsForCreateCursorManager
    extends MethodArguments {
        boolean sendGenerationInfoType;
        long valueOfGenerationInfoType;
        boolean sendCreateCountColumn;
        boolean valueOfCreateCountColumn;
        boolean sendGenerateSQL;
        boolean valueOfGenerateSQL;

        protected MethodArgumentsForCreateCursorManager() {
        }

        @Override
        void writeXML(XMLWriter xMLWriter) {
            xMLWriter.beginElement("MethodArguments");
            if (this.sendGenerationInfoType) {
                xMLWriter.appendAttribute("GenerationInfoType", Long.toString(this.valueOfGenerationInfoType));
            }
            if (this.sendCreateCountColumn) {
                SourceToXMLConverter.appendBooleanAttribute(xMLWriter, "CreateCountColumn", this.valueOfCreateCountColumn);
            }
            if (this.sendGenerateSQL) {
                SourceToXMLConverter.appendBooleanAttribute(xMLWriter, "GenerateSQL", this.valueOfGenerateSQL);
            }
            xMLWriter.closeTag();
            xMLWriter.endElement("MethodArguments");
        }
    }

    protected static class MethodArgumentsForPrepare3
    extends MethodArguments {
        long[] cursorManagerIDArray;
        boolean generateSQL;

        protected MethodArgumentsForPrepare3() {
        }

        @Override
        void writeXML(XMLWriter xMLWriter) {
            xMLWriter.beginElement("MethodArguments");
            for (int i = 0; i < this.cursorManagerIDArray.length; ++i) {
                xMLWriter.appendAttribute("CursorManagerID", Long.toString(this.cursorManagerIDArray[i]));
            }
            SourceToXMLConverter.appendBooleanAttribute(xMLWriter, "GenerateSQL", this.generateSQL);
            xMLWriter.closeTag();
            xMLWriter.endElement("MethodArguments");
        }
    }

    protected static abstract class MethodArguments {
        protected MethodArguments() {
        }

        abstract void writeXML(XMLWriter var1);
    }

    protected static class CursorManagerInfo {
        SourceDefinition m_RootDefinition;
        Source[] m_InputSources;

        CursorManagerInfo(SourceDefinition sourceDefinition, Source[] sourceArray) {
            this.m_RootDefinition = sourceDefinition;
            this.m_InputSources = sourceArray;
        }
    }
}

