/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import oracle.express.olapi.replay.XMLDocumentFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OracleXMLDocumentFactory
implements XMLDocumentFactory {
    private static OracleXMLDocumentFactory _instance = null;
    protected static NodeFactory nodeFactory = null;
    public static final String VERSION = "1.0";

    private OracleXMLDocumentFactory() {
        if (nodeFactory == null) {
            nodeFactory = new NodeFactory(){};
        }
    }

    public static OracleXMLDocumentFactory getInstance() {
        try {
            if (_instance == null) {
                _instance = new OracleXMLDocumentFactory();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return _instance;
    }

    @Override
    public Document createDocument() {
        XMLDocument xMLDocument = nodeFactory.createDocument();
        xMLDocument.setVersion(VERSION);
        return xMLDocument;
    }

    @Override
    public Document parse(Reader reader) throws IOException {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(reader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            return xMLDocument;
        }
        catch (XMLParseException xMLParseException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    @Override
    public void print(Node node, Writer writer) throws IOException {
        XMLNode xMLNode = (XMLNode)node;
        xMLNode.print(new PrintWriter(writer));
    }

    @Override
    public NodeList selectNodes(Node node, String string) {
        try {
            return ((XMLNode)node).selectNodes(string);
        }
        catch (XSLException xSLException) {
            return null;
        }
    }
}

