/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.util.Properties;
import oracle.olapi.log.LogEndEvent;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogLocator;
import oracle.olapi.log.LogSession;
import oracle.olapi.log.LogStartEvent;

public final class OlapiLog {
    private static LogLocator _instance = null;

    private OlapiLog() {
    }

    public static synchronized void init(Properties properties) {
        if (_instance == null) {
            _instance = LogLocator.createInstance("olapi", properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() {
        Properties properties = null;
        try {
            properties = System.getProperties();
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        finally {
            OlapiLog.init(properties);
        }
    }

    public static synchronized void destroy() {
        _instance.destroy();
        _instance = null;
    }

    public static synchronized LogSession getSession() {
        if (_instance == null) {
            OlapiLog.init();
        }
        return _instance.getSession();
    }

    public static void addMessage(LogEvent logEvent) {
        OlapiLog.getSession().addMessage(logEvent);
    }

    public static synchronized boolean hasHandlers() {
        return OlapiLog.getSession().hasHandlers();
    }

    public static LogEvent createEvent(int n, String string) {
        return OlapiLog.getSession().createEvent(n, string);
    }

    public static LogStartEvent createStartEvent(int n, String string) {
        return OlapiLog.getSession().createStartEvent(n, string);
    }

    public static LogEndEvent createElapsedEvent(LogEvent logEvent, String string) {
        return OlapiLog.getSession().createElapsedEvent(logEvent, string);
    }

    public static LogEndEvent createEndEvent(LogStartEvent logStartEvent, String string) {
        return OlapiLog.getSession().createEndEvent(logStartEvent, string);
    }

    public static LogEndEvent createEndEvent(LogStartEvent logStartEvent) {
        return OlapiLog.getSession().createEndEvent(logStartEvent);
    }

    public static LogEvent createExceptionEvent(int n, String string, Throwable throwable) {
        return OlapiLog.getSession().createExceptionEvent(n, string, throwable);
    }
}

