/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public abstract class MtmBaseCube
extends MtmCube {
    MtmBaseCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public List getDimensionality() {
        return this.getPropertyListValues(MtmXMLTags.DIMENSIONALITY);
    }

    public MtmTabularSource getTable() {
        return (MtmTabularSource)this.getPropertyObjectValue(MtmXMLTags.TABLE);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.PARTITIONED_CUBE.matches(string, string2)) {
            return MtmXMLTags.PARTITIONED_CUBE;
        }
        if (MtmXMLTags.TABLE.matches(string, string2)) {
            return MtmXMLTags.TABLE;
        }
        if (MtmXMLTags.DIMENSIONALITY.matches(string, string2)) {
            return MtmXMLTags.DIMENSIONALITY;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    void setTable(MtmTabularSource mtmTabularSource) {
        this.setPropertyObjectValue(MtmXMLTags.TABLE, mtmTabularSource);
    }

    public void addMeasure(MdmMeasure mdmMeasure, MtmValueExpression mtmValueExpression) {
        this.addToListProperty(MtmXMLTags.MEAS_MAP_REF, mdmMeasure.getMeasureMap());
        if (mtmValueExpression != null) {
            mdmMeasure.getMeasureMap().setMappedExpression(this, mtmValueExpression);
        }
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty(MtmXMLTags.MEAS_MAP_REF, mdmMeasure.getMeasureMap());
    }

    public void addDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        this.addToListProperty(MtmXMLTags.DIMENSIONALITY, mtmCubeDimensionality);
        this.addToListProperty(MtmXMLTags.DIM_MAP_REF, mtmCubeDimensionality.getDimensionMap());
    }

    public void removeDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        this.removeFromListProperty(MtmXMLTags.DIMENSIONALITY, mtmCubeDimensionality);
        this.removeFromListProperty(MtmXMLTags.DIM_MAP_REF, mtmCubeDimensionality.getDimensionMap());
    }

    private MtmCubeDimensionality getDimensionalityForDimension(MdmDimension mdmDimension) {
        for (MtmCubeDimensionality mtmCubeDimensionality : this.getDimensionality()) {
            if (mtmCubeDimensionality.getDimensionMap().getMdmSource() != mdmDimension) continue;
            return mtmCubeDimensionality;
        }
        return null;
    }

    public void removeDimension(MdmDimension mdmDimension) {
        MtmCubeDimensionality mtmCubeDimensionality = this.getDimensionalityForDimension(mdmDimension);
        if (mtmCubeDimensionality != null) {
            this.removeDimensionality(mtmCubeDimensionality);
        }
        this.removeFromListProperty(MtmXMLTags.DIM_MAP_REF, (MtmDimensionMap)mdmDimension.getSourceMap());
    }

    public MtmPartitionedCube getPartitionedCube() {
        return (MtmPartitionedCube)this.getPropertyObjectValue(MtmXMLTags.PARTITIONED_CUBE);
    }

    void setPartitionedCube(MtmPartitionedCube mtmPartitionedCube) {
        this.setPropertyObjectValue(MtmXMLTags.PARTITIONED_CUBE, mtmPartitionedCube);
    }
}

