/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public class DimensionArgument
extends DataObject
implements FunctionArgument {
    private BaseMetadataObjectReference m_Dimension;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_Dimension.toSyntax(syntaxPrintingContext);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitDimensionArgument(this, object);
    }

    public DimensionArgument(MdmDimension mdmDimension) {
        DimensionArgument.validateValue(mdmDimension);
        this.m_Dimension = new MetadataObjectReference(mdmDimension, MdmDimension.class);
        this.initialize();
    }

    public DimensionArgument(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference) {
        DimensionArgument.validateValue(baseMetadataObjectReference);
        this.m_Dimension = baseMetadataObjectReference;
        this.initialize();
    }

    public MdmDimension getDimension() {
        return (MdmDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        return this.m_Dimension.getIdentifier().toString();
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        return this;
    }
}

