/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

public final class FunctionCondition
extends Condition {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 128, "UnknownConditionFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        return this;
    }

    public FunctionCondition(String string, FunctionArgument[] functionArgumentArray) {
        FunctionCondition.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = FunctionCondition.getFunctionArgumentArrayClone(functionArgumentArray);
        this.initialize();
    }

    public FunctionCondition(String string) {
        this(string, new FunctionArgument[0]);
    }

    public FunctionCondition(String string, FunctionArgument functionArgument) {
        this(string, new FunctionArgument[]{functionArgument});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4});
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitFunctionCondition(this, object);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }
}

