/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class OLAPDMLExpression
extends TypedExpression {
    private TypedExpression m_OlapDML;
    private BaseMetadataObjectReference[] m_Dimensions;
    private SQLDataType m_SQLDataType;

    private BaseMetadataObjectReference[] getDimensionsInternal() {
        return this.m_Dimensions;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("OLAP_DML_EXPRESSION(");
        syntaxPrintingContext.print(this.getOlapDML());
        syntaxPrintingContext.append(", ");
        syntaxPrintingContext.append(this.getSQLDataType().getSQLText());
        for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
            syntaxPrintingContext.newLineAndIndent();
            if (0 == i) {
                syntaxPrintingContext.append(" DIMENSION BY ");
            } else {
                syntaxPrintingContext.append(", ");
            }
            this.getDimensionsInternal()[i].toSyntax(syntaxPrintingContext);
        }
        syntaxPrintingContext.append(")");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        if (null != this.getDimensionsInternal()) {
            for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
                this.getDimensionsInternal()[i] = (BaseMetadataObjectReference)validationContext.validate(this.getDimensionsInternal()[i]);
            }
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getDimensionsInternal()) {
            for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
                if (this.getDimensionsInternal()[i].isDefinitionComplete()) continue;
                return false;
            }
        }
        return super.checkIfDefinitionIsComplete();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = new BaseMetadataObjectReference[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            this.m_Dimensions[i] = new MetadataObjectReference(mdmPrimaryDimensionArray[i], MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = new BaseMetadataObjectReference[list.size()];
        int n = 0;
        for (MdmPrimaryDimension mdmPrimaryDimension : list) {
            this.m_Dimensions[n++] = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(ExpParser expParser, TypedExpression typedExpression, DataType dataType, List<BaseMetadataObjectReference> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        if (null == list) {
            this.m_Dimensions = null;
        } else {
            BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
            list.toArray(baseMetadataObjectReferenceArray);
            this.m_Dimensions = baseMetadataObjectReferenceArray;
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = new BaseMetadataObjectReference[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            this.m_Dimensions[i] = new MetadataObjectReference(mdmPrimaryDimensionArray[i], MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = new BaseMetadataObjectReference[list.size()];
        int n = 0;
        for (MdmPrimaryDimension mdmPrimaryDimension : list) {
            this.m_Dimensions[n++] = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(ExpParser expParser, TypedExpression typedExpression, SQLDataType sQLDataType, List<BaseMetadataObjectReference> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        if (null == list) {
            this.m_Dimensions = null;
        } else {
            BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
            list.toArray(baseMetadataObjectReferenceArray);
            this.m_Dimensions = baseMetadataObjectReferenceArray;
        }
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOLAPDMLExpression(this, object);
    }

    public TypedExpression getOlapDML() {
        return this.m_OlapDML;
    }

    public MdmPrimaryDimension[] getDimensions() {
        if (null != this.getDimensionsInternal()) {
            MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[this.getDimensionsInternal().length];
            for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
                mdmPrimaryDimensionArray[i] = (MdmPrimaryDimension)this.getDimensionsInternal()[i].getBaseMetadataObject();
            }
            return mdmPrimaryDimensionArray;
        }
        return null;
    }

    public SQLDataType getSQLDataType() {
        return this.m_SQLDataType;
    }
}

