/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public final class DropShadow {
    private static int SHADOW_DEPTH = 7;
    private static Image leftImage;
    private static Image rightImage;
    private static BufferedImage bottomImage;

    private DropShadow() {
    }

    public static JComponent createShadowedComponent(JComponent c) {
        if (leftImage == null) {
            try {
                URL leftImageURL = DropShadow.class.getResource("/oracle/jdevimpl/help/images/button_shadow_left.png");
                URL bottomImageURL = DropShadow.class.getResource("/oracle/jdevimpl/help/images/button_shadow_bottom.png");
                URL rightImageURL = DropShadow.class.getResource("/oracle/jdevimpl/help/images/button_shadow_right.png");
                leftImage = ImageIO.read(leftImageURL);
                rightImage = ImageIO.read(rightImageURL);
                bottomImage = ImageIO.read(bottomImageURL);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JXLayer layer = new JXLayer((Component)c, (LayerUI)new ShadowLayerUI());
        layer.setBorder(BorderFactory.createEmptyBorder(0, 7, SHADOW_DEPTH, 7));
        return layer;
    }

    private static class ShadowLayerUI
    extends LayerUI {
        private ShadowLayerUI() {
        }

        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.dispose();
            super.paint(g, c);
            try {
                Image image = bottomImage.getScaledInstance(c.getWidth() - 15, 7, 1);
                g.drawImage(image, 7, c.getHeight() - 7, null);
                g.drawImage(leftImage, 0, 0, null);
                g.drawImage(rightImage, c.getWidth() - 8, 0, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

