/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.internal.UICUtils;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public final class BlockingComponent {
    private static final Color blockedColor = new Color(255, 255, 255, 128);
    private static final Font textFont = UIManager.getFont("Label.font").deriveFont(1, 13.0f);
    private static final Color bgColor = new Color(255, 255, 255, 216);
    private static final Color textColor = new Color(10, 10, 60);
    private static final int ICON_TEXT_GAP = 10;
    private static final int LEFT_RIGHT_GAP = 20;
    private static final int TOP_BOTTOM_GAP = 15;
    private static final Icon icon = OracleIcons.getIcon((String)"throbber25.gif");
    private static final int SHADOW_DEPTH = 9;
    private final BlockingLayerUI blockingLayerUI;
    private State state;
    private Message message;
    private JXLayer jxlayer;
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_MESSAGE = "message";
    private List<PropertyChangeListener> pcls;

    public BlockingComponent(JComponent componentToBlock) {
        ImageIcon imgIcon = (ImageIcon)icon;
        imgIcon.setImageObserver(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (BlockingComponent.this.state == State.UNBLOCKED) {
                    return false;
                }
                BlockingComponent.this.jxlayer.repaint();
                return true;
            }
        });
        this.state = State.UNBLOCKED;
        this.message = Message.NO_MESSAGE;
        this.pcls = new CopyOnWriteArrayList<PropertyChangeListener>();
        this.blockingLayerUI = new BlockingLayerUI();
        this.jxlayer = new JXLayer((Component)componentToBlock, (LayerUI)this.blockingLayerUI);
    }

    public JComponent getBlockingComponent() {
        return this.jxlayer;
    }

    public void setState(State state) {
        if (this.state == state) {
            return;
        }
        this.blockingLayerUI.componentImageRef = null;
        State oldState = this.state;
        this.state = state;
        switch (state) {
            case UNBLOCKED: {
                this.jxlayer.getGlassPane().setCursor(Cursor.getDefaultCursor());
                break;
            }
            default: {
                this.jxlayer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        this.jxlayer.repaint();
        PropertyChangeEvent event = new PropertyChangeEvent(this, PROPERTY_STATE, (Object)oldState, (Object)state);
        for (PropertyChangeListener l : this.pcls) {
            l.propertyChange(event);
        }
    }

    public void setMessage(Message message) {
        if (message == this.message) {
            return;
        }
        this.blockingLayerUI.componentImageRef = null;
        Message oldMessage = this.message;
        this.message = message;
        this.jxlayer.repaint();
        PropertyChangeEvent event = new PropertyChangeEvent(this, PROPERTY_MESSAGE, (Object)oldMessage, (Object)message);
        for (PropertyChangeListener l : this.pcls) {
            l.propertyChange(event);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public State getState() {
        return this.state;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (!this.pcls.contains(pcl)) {
            this.pcls.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcls.remove(pcl);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("nogrid, fill"));
        final JComboBox<State> states = new JComboBox<State>(State.values());
        final JComboBox<Message> messages = new JComboBox<Message>(Message.values());
        panel.add(states, "growx 0");
        panel.add(messages, "growx 0");
        panel.setOpaque(false);
        JPanel blockedPanel = new JPanel((LayoutManager)new MigLayout("nogrid, fill"));
        blockedPanel.setOpaque(false);
        blockedPanel.add(new JTree());
        blockedPanel.add(new JButton("Press Me"));
        blockedPanel.add((Component)new JTextArea("This whole panel can be blocked by switching\nthe combo box.\n\nComponents outside the panel are unaffected."), "newline");
        blockedPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        final BlockingComponent blockingComponent = new BlockingComponent(blockedPanel);
        panel.add((Component)blockingComponent.getBlockingComponent(), "newline");
        panel.add((Component)new JButton("I do not get blocked"), "newline");
        states.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                blockingComponent.setState((State)((Object)states.getSelectedItem()));
            }
        });
        messages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                blockingComponent.setMessage((Message)((Object)messages.getSelectedItem()));
            }
        });
        UICUtils.runComponent(panel);
    }

    private class BlockingLayerUI
    extends AbstractLayerUI<JComponent> {
        private SoftReference<Image> componentImageRef;
        private int iconX;
        private int iconY;
        private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);

        public void installUI(JComponent component) {
            super.installUI(component);
            ((JXLayer)component).setLayerEventMask(56L);
        }

        public void uninstallUI(JComponent component) {
            assert (component == BlockingComponent.this.jxlayer);
            BlockingComponent.this.jxlayer.setLayerEventMask(0L);
            BlockingComponent.this.jxlayer.getGlassPane().setCursor(Cursor.getDefaultCursor());
            super.uninstallUI(component);
        }

        protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
            if (BlockingComponent.this.state == State.UNBLOCKED) {
                super.paintLayer(g2, l);
                return;
            }
            Image componentImage = this.componentImageRef == null ? null : this.componentImageRef.get();
            JComponent c = (JComponent)l.getView();
            if (componentImage != null && componentImage.getWidth(null) == c.getWidth() && componentImage.getHeight(null) == c.getHeight()) {
                this.paintCached(g2, c, componentImage);
            } else {
                this.paintUncached(g2, c, l);
            }
        }

        private void paintUncached(Graphics2D g, JComponent c, JXLayer<? extends JComponent> l) {
            BufferedImage img = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics2D imgG = (Graphics2D)((Image)img).getGraphics();
            super.paintLayer(imgG, l);
            imgG.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            imgG.setColor(blockedColor);
            imgG.fillRect(0, 0, c.getWidth(), c.getHeight());
            if (BlockingComponent.this.message != Message.NO_MESSAGE) {
                String text = BlockingComponent.this.message.getText();
                FontMetrics fm = imgG.getFontMetrics(textFont);
                int w = 20 + icon.getIconWidth() + 10 + fm.stringWidth(text) + 20;
                int h = 15 + Math.max(fm.getHeight(), icon.getIconHeight()) + 15;
                int x = c.getWidth() / 2 - w / 2;
                int y = c.getHeight() / 2 - h / 2;
                imgG.setColor(bgColor);
                imgG.fillRect(x, y, w, h);
                this.paintShadow(imgG, new Rectangle(x, y, w, h));
                this.iconX = x += 20;
                this.iconY = c.getHeight() / 2 - icon.getIconHeight() / 2;
                imgG.setColor(textColor);
                imgG.setFont(textFont);
                imgG.drawString(text, x += icon.getIconWidth() + 10, c.getHeight() / 2 - fm.getHeight() / 2 + fm.getAscent());
            }
            this.componentImageRef = new SoftReference<BufferedImage>(img);
            this.paintCached(g, c, img);
        }

        private void paintCached(Graphics2D g, JComponent c, Image cachedImage) {
            g.drawImage(cachedImage, 0, 0, null);
            if (BlockingComponent.this.message != Message.NO_MESSAGE) {
                icon.paintIcon(c, g, this.iconX, this.iconY);
            }
        }

        private Object[] getCachedImage(SoftReference<BufferedImage> imageRef, int width, int height) {
            BufferedImage image = imageRef.get();
            if (image != null && (image.getWidth() != width || image.getHeight() != height)) {
                image = null;
            }
            Object[] ret = new Object[2];
            ret[1] = imageRef;
            if (image == null) {
                image = new BufferedImage(width, height, 2);
                ret[1] = new SoftReference<BufferedImage>(image);
            } else {
                Graphics2D g2D = image.createGraphics();
                g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
                g2D.fill(rect);
            }
            ret[0] = image;
            return ret;
        }

        private void paintShadow(Graphics2D g2, Rectangle r) {
            Area clipArea = new Area(new Rectangle(0, 0, BlockingComponent.this.jxlayer.getWidth(), BlockingComponent.this.jxlayer.getHeight()));
            clipArea.subtract(new Area(r));
            r.x -= 4;
            r.y -= 4;
            r.width += 9;
            r.height += 9;
            Object[] cacheImage = this.getCachedImage(this.shadowImageRef, r.width + 18, r.height + 18);
            int elementCount = 81;
            float i = 1.0f / (float)elementCount;
            float[] elements = new float[elementCount];
            for (int n = 0; n < elementCount; ++n) {
                elements[n] = i;
            }
            Kernel myKernel = new Kernel(9, 9, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            BufferedImage shadowImage = (BufferedImage)cacheImage[0];
            this.shadowImageRef = (SoftReference)cacheImage[1];
            Graphics2D shadowG = shadowImage.createGraphics();
            shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            shadowG.setColor(new Color(0, 0, 0, 63));
            shadowG.translate(-r.x + 9, -r.y + 9);
            shadowG.fill(r);
            shadowG.translate(r.x - 9, r.y - 9);
            Graphics2D tempG = (Graphics2D)g2.create();
            tempG.setComposite(AlphaComposite.getInstance(3, 0.5f));
            tempG.setClip(clipArea);
            tempG.drawImage(shadowImage, simpleBlur, r.x - 9, r.y - 9);
            tempG.dispose();
            shadowG.dispose();
        }

        public void eventDispatched(AWTEvent e, JXLayer<? extends JComponent> layer) {
            if (BlockingComponent.this.state != State.UNBLOCKED && e instanceof InputEvent) {
                ((InputEvent)e).consume();
                return;
            }
            super.eventDispatched(e, layer);
        }
    }

    public static enum Message {
        NO_MESSAGE,
        BUSY,
        STARTING,
        STOPPING,
        SAVING,
        CANCELLING,
        LOADING;


        public String getText() {
            switch (this) {
                case BUSY: {
                    return UIBundle.get("BLOCKED_BUSY");
                }
                case STARTING: {
                    return UIBundle.get("BLOCKED_STARTING");
                }
                case SAVING: {
                    return UIBundle.get("BLOCKED_SAVING");
                }
                case CANCELLING: {
                    return UIBundle.get("BLOCKED_CANCELLNG");
                }
                case LOADING: {
                    return UIBundle.get("BLOCKED_LOADING");
                }
                case STOPPING: {
                    return UIBundle.get("BLOCKED_STOPPING");
                }
            }
            return null;
        }
    }

    public static enum State {
        UNBLOCKED,
        BLOCKED;

    }
}

