/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public final class ComponentFaderFactory {
    private ComponentFaderFactory() {
    }

    public static JComponent createFadedComponent(JComponent component, FadePolicy policy) {
        final JXLayer fadedComponent = new JXLayer((Component)component, (LayerUI)new FadeLayerUI(policy));
        fadedComponent.setMinimumSize(component.getMinimumSize());
        fadedComponent.setMaximumSize(component.getMinimumSize());
        fadedComponent.setPreferredSize(component.getMinimumSize());
        policy.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fade")) {
                    fadedComponent.repaint();
                }
            }
        });
        return fadedComponent;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        JComboBox<String> combo = new JComboBox<String>(new String[]{"Apple", "Banana", "Cherry"});
        combo.setEditable(true);
        panel.add(ComponentFaderFactory.createFadedComponent(combo, new MouseOverFadePolicy(combo)));
        panel.add(ComponentFaderFactory.createFadedComponent(new JButton("BasicFade"), new BasicFadePolicy(0.8f)));
        JTextField mouseOverTF = new JTextField("Mouse Over", 10);
        JButton mouseOverButton = new JButton("MouseOverFade");
        panel.add(mouseOverTF);
        panel.add(ComponentFaderFactory.createFadedComponent(mouseOverButton, new MouseOverFadePolicy(mouseOverButton, mouseOverTF)));
        JFrame frame = new JFrame("ComponentFaderFactory Test");
        frame.setLayout((LayoutManager)new MigLayout("fill"));
        frame.add((Component)panel, "aligny top, alignx left");
        panel.setOpaque(false);
        frame.setDefaultCloseOperation(3);
        frame.setSize(450, 70);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setBackground(Color.WHITE);
        frame.setVisible(true);
    }

    public static class FadeLayerUI
    extends AbstractLayerUI {
        private final FadePolicy policy;

        public FadeLayerUI(FadePolicy policy) {
            this.policy = policy;
        }

        protected void paintLayer(Graphics2D g2, JXLayer l) {
            super.paintLayer(g2, l);
            float fade = this.policy.getFade();
            if (fade > 0.0f) {
                g2.setComposite(AlphaComposite.getInstance(3, fade));
                g2.setColor(this.fadeColor(l.getView().getParent()));
                g2.fillRect(0, 0, l.getWidth(), l.getHeight());
            }
        }

        private Color fadeColor(Component c) {
            if (c.isOpaque()) {
                return c.getBackground();
            }
            if ((c = c.getParent()) != null) {
                return this.fadeColor(c);
            }
            return UIManager.getColor("Panel.background");
        }
    }

    public static class MouseOverFadePolicy
    extends BasicFadePolicy {
        private final Listener listener = new Listener();
        private float maxFadeOut = 0.8f;
        private int mouseInCount = 0;
        private int focusCount = 0;
        private Timer timer = new Timer(25, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MouseOverFadePolicy.this.stepFade();
            }
        });

        public MouseOverFadePolicy(Component ... component) {
            super(0.0f);
            this.timer.setRepeats(true);
            this.setFade(this.maxFadeOut);
            for (Component c : component) {
                this.add(c);
            }
            if (this.focusCount > 0) {
                this.setFade(0.0f);
            }
        }

        public void add(Component component) {
            component.addMouseListener(this.listener);
            component.addFocusListener(this.listener);
            if (component.hasFocus()) {
                ++this.focusCount;
            }
            if (component instanceof JComponent) {
                for (Component c : ((JComponent)component).getComponents()) {
                    this.add(c);
                }
            }
        }

        public void remove(Component component) {
            component.removeMouseListener(this.listener);
            component.removeFocusListener(this.listener);
            if (component.hasFocus()) {
                --this.focusCount;
            }
            if (component instanceof JComponent) {
                for (Component c : ((JComponent)component).getComponents()) {
                    this.remove(c);
                }
            }
        }

        private void stepFade() {
            float fade = this.getFade();
            if (this.mouseInCount > 0 || this.focusCount > 0) {
                if ((fade -= 0.05f) <= 0.0f) {
                    fade = 0.0f;
                    this.timer.stop();
                }
            } else if ((fade += 0.05f) >= this.maxFadeOut) {
                fade = this.maxFadeOut;
                this.timer.stop();
            }
            this.setFade(fade);
        }

        public final void setMaxFadeOut(float maxFadeOut) {
            this.maxFadeOut = maxFadeOut;
        }

        public final float getMaxFadeOut() {
            return this.maxFadeOut;
        }

        private class Listener
        extends MouseAdapter
        implements FocusListener {
            private Listener() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseOverFadePolicy.this.mouseInCount++;
                MouseOverFadePolicy.this.timer.restart();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseOverFadePolicy.this.mouseInCount--;
                MouseOverFadePolicy.this.timer.restart();
            }

            @Override
            public void focusGained(FocusEvent e) {
                MouseOverFadePolicy.this.mouseInCount++;
                MouseOverFadePolicy.this.timer.restart();
            }

            @Override
            public void focusLost(FocusEvent e) {
                MouseOverFadePolicy.this.mouseInCount--;
                MouseOverFadePolicy.this.timer.restart();
            }
        }
    }

    public static class BasicFadePolicy
    implements FadePolicy {
        private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
        private float fade = 0.0f;

        public BasicFadePolicy(float fade) {
            this.setFade(fade);
        }

        @Override
        public float getFade() {
            return this.fade;
        }

        public void setFade(float fade) {
            if (fade < 0.0f || fade > 1.0f) {
                throw new IllegalArgumentException("fadeAmount out of bounds 0f->1f: " + fade);
            }
            float oldFade = this.fade;
            this.fade = fade;
            if (oldFade != fade) {
                PropertyChangeEvent evt = new PropertyChangeEvent(this, "fade", Float.valueOf(oldFade), Float.valueOf(fade));
                for (PropertyChangeListener l : this.listeners) {
                    l.propertyChange(evt);
                }
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.remove(listener);
        }
    }

    public static interface FadePolicy {
        public static final String PROPERTY_FADE = "fade";

        public float getFade();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

