/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.StatusIndicator;

public final class ComponentWithTitlebar<T extends JComponent>
extends JPanel {
    private T _component;
    private final JPanel _title = new JPanel();
    private final JPanel _statusPanel = new JPanel((LayoutManager)new MigLayout("ins 0, filly, hidemode 2"));
    private StatusIndicator _statusIndicator;
    private JLabel _label;
    private ControlBar _controlBar;

    public ComponentWithTitlebar() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._title, "North");
        this._title.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0, hidemode 2", "[left]5px:push[right]"));
        this._title.add((Component)this._statusPanel, "dock west");
        this._statusPanel.setVisible(false);
        this._statusPanel.setOpaque(false);
        this.configureTitleAppearance();
    }

    public ComponentWithTitlebar(T component, JLabel label, ControlBar controlBar) {
        this();
        this.setComponent(component);
        this.setLabel(label);
        this.setControlBar(controlBar);
    }

    public void setLabel(JLabel label) {
        if (this._label == label) {
            return;
        }
        this.installLabelBorder(label);
        this.swapComponent(this._title, this._label, label, "dock west");
        JLabel oldLabel = this._label;
        this._label = label;
        this.firePropertyChange("label", oldLabel, label);
    }

    public JLabel getLabel() {
        return this._label;
    }

    public void setControlBar(ControlBar controlBar) {
        if (this._controlBar == controlBar) {
            return;
        }
        this.swapComponent(this._title, this._controlBar, controlBar, "dock east");
        ControlBar oldControlbar = this._controlBar;
        this._controlBar = controlBar;
        this.firePropertyChange("controlBar", oldControlbar, controlBar);
    }

    public void setStatusIndicator(StatusIndicator statusIndicator) {
        if (this._statusIndicator != null) {
            this._statusPanel.removeAll();
        }
        if (statusIndicator != null) {
            final JComponent statusIndicatorComp = statusIndicator.configureStandalone(StatusIndicator.OkPolicy.REMOVE);
            this._statusPanel.add((Component)statusIndicatorComp, "dock west, gapleft 3, gapright 2, aligny center");
            this._statusPanel.setVisible(true);
            statusIndicatorComp.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    ComponentWithTitlebar.this._statusPanel.setVisible(statusIndicatorComp.isVisible());
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ComponentWithTitlebar.this._statusPanel.setVisible(statusIndicatorComp.isVisible());
                }
            });
        } else {
            this._statusPanel.setVisible(false);
        }
    }

    public ControlBar getControlBar() {
        return this._controlBar;
    }

    public void setComponent(T component) {
        if (this._component == component) {
            return;
        }
        this.installComponentBorder(component);
        this.swapComponent(this, (Component)this._component, (Component)component, "Center");
        T oldComponent = this._component;
        this._component = component;
        this.firePropertyChange("component", oldComponent, component);
    }

    public T getComponent() {
        return this._component;
    }

    private void installLabelBorder(JLabel label) {
        if (!this.canInstallBorder(label)) {
            return;
        }
        label.setBorder(new BorderUIResource.EmptyBorderUIResource(3, 3, 3, 3));
    }

    private void installComponentBorder(T component) {
        if (!this.canInstallBorder((JComponent)component)) {
            return;
        }
        ((JComponent)component).setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.FLAT_EDITOR_BORDER));
    }

    private boolean canInstallBorder(JComponent c) {
        if (c == null) {
            return false;
        }
        return c.getBorder() == null || c.getBorder() instanceof UIResource;
    }

    private void swapComponent(JComponent parent, Component oldComponent, Component newComponent, String layoutPosition) {
        if (oldComponent != null) {
            parent.remove(oldComponent);
        }
        if (newComponent != null) {
            if (layoutPosition != null) {
                parent.add(newComponent, layoutPosition);
            } else {
                parent.add(newComponent);
            }
        }
        parent.revalidate();
        this.revalidate();
    }

    private void configureTitleAppearance() {
        this._title.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Colors.FLAT_EDITOR_BORDER));
        if (!PlasticLookAndFeel.getHighContrastFocusColorsEnabled()) {
            this._title.setBackground(Colors.TAB_PANE_BACKGROUND);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (!this._title.isOpaque()) {
            this._title.setOpaque(true);
        }
        super.paintChildren(g);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        JLabel label = new JLabel("Label for Component");
        ControlBar controlBar = new ControlBar();
        JButton button = new JButton("Component");
        JButton b1 = new JButton("Add");
        controlBar.add(b1);
        JButton b2 = new JButton("Delete");
        controlBar.add(b2);
        JButton b3 = new JButton("Button Three");
        controlBar.add(b3);
        JButton b4 = new JButton("Button Four");
        controlBar.add(b4);
        ComponentWithTitlebar<JButton> cwt = new ComponentWithTitlebar<JButton>(button, label, controlBar);
        cwt.setStatusIndicator(new StatusIndicator());
        JPanel p = new JPanel(new BorderLayout());
        p.add(cwt, "North");
        JPanel p2 = new JPanel();
        p.add((Component)p2, "Center");
        JSplitPane splitPane = new JSplitPane();
        JButton leftComponent = new JButton("Left Component");
        splitPane.setLeftComponent(leftComponent);
        splitPane.setRightComponent(p);
        f.add((Component)splitPane, "North");
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

