/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import oracle.javatools.ui.InputInfo;
import oracle.javatools.ui.MouseHoverListener;

public class MouseHoverSupport {
    private Timer timer;
    private Point hoverPoint;
    private int hoverZone = 2;
    private Component comp;
    public final int MOUSE_HOVERED = 520;
    private ArrayList<MouseHoverListener> listeners = new ArrayList();

    public MouseHoverSupport(Component comp, int duration, boolean repeat) {
        this.comp = comp;
        Listener l = new Listener();
        comp.addMouseMotionListener(l);
        comp.addMouseListener(l);
        this.timer = new Timer(duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MouseHoverSupport.this.timerUpdate();
            }
        });
        this.timer.setRepeats(repeat);
    }

    public void addMouseHoverListener(MouseHoverListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeMouseHoverListener(MouseHoverListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void timerUpdate() {
        PointerInfo info = MouseInfo.getPointerInfo();
        if (info == null) {
            this.hoverStop();
            return;
        }
        Point location = info.getLocation();
        if (location == null) {
            this.hoverStop();
            return;
        }
        SwingUtilities.convertPointFromScreen(location, this.comp);
        if (location.x <= this.comp.getWidth() && location.y <= this.comp.getHeight() && location.x >= 0 && location.y >= 0) {
            int modifiers = 0;
            if (InputInfo.isControlDown()) {
                modifiers |= 0x80;
            }
            if (InputInfo.isAltDown()) {
                modifiers |= 0x200;
            }
            if (InputInfo.isShiftDown()) {
                modifiers |= 0x40;
            }
            if (InputInfo.isMetaDown()) {
                modifiers |= 0x100;
            }
            if (InputInfo.isButton1Down()) {
                modifiers |= 0x400;
            }
            if (InputInfo.isButton2Down()) {
                modifiers |= 0x800;
            }
            if (InputInfo.isButton3Down()) {
                modifiers |= 0x1000;
            }
            MouseEvent me = new MouseEvent(this.comp, 520, System.currentTimeMillis(), 0, this.hoverPoint.x, this.hoverPoint.y, 0, false);
            for (MouseHoverListener l : this.listeners) {
                l.mouseHovered(me);
            }
            if (!this.timer.isRepeats()) {
                this.hoverStop();
            }
        } else {
            this.hoverStop();
        }
    }

    private void hoverStop() {
        this.timer.stop();
        this.hoverPoint = null;
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.processHover(me);
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.processHover(me);
        }

        private void processHover(MouseEvent me) {
            if (MouseHoverSupport.this.hoverPoint == null) {
                MouseHoverSupport.this.hoverPoint = me.getPoint();
                MouseHoverSupport.this.timer.start();
            } else if (MouseHoverSupport.this.hoverPoint.distance(me.getPoint()) > (double)MouseHoverSupport.this.hoverZone) {
                MouseHoverSupport.this.hoverPoint = me.getPoint();
                MouseHoverSupport.this.timer.restart();
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            MouseHoverSupport.this.hoverStop();
        }

        @Override
        public void mousePressed(MouseEvent me) {
            MouseHoverSupport.this.hoverStop();
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            MouseHoverSupport.this.hoverStop();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            MouseHoverSupport.this.hoverStop();
        }
    }
}

