/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.internal.UICUtils;

public class PopupButton
extends JToggleButton {
    private static final Insets INSETS = new Insets(4, 4, 4, 4);
    private long reactivationTimeLimit = 0L;
    private JComponent popupContent = new JPanel(new BorderLayout());
    private JWindow popup;
    private FocusL focusL;
    private ParentWindowL parentWindowL;

    public PopupButton() {
        super(OracleIcons.getIcon((String)"extras/dropdown.png"));
        this.popupContent.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("InternalFrame.borderDarkShadow")));
        this.focusL = new FocusL();
        this.parentWindowL = new ParentWindowL();
        this.setMargin(INSETS);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupButton.this.toggle();
            }
        });
    }

    public PopupButton(JComponent popupContent) {
        this();
        this.setPopupContent(popupContent);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        PopupButton popupButton = new PopupButton();
        JPanel content = new JPanel((LayoutManager)new MigLayout());
        content.add((Component)new JRadioButton("Simple"), "split, span");
        content.add((Component)new JRadioButton("Complex"), "");
        content.add((Component)new JRadioButton("Custom"), "");
        content.add((Component)new JLabel("Type:"), "newline");
        content.add((Component)new JLabel("Size:"), "");
        content.add((Component)new JLabel("Units:"), "");
        content.add(new JComboBox<Object>(new Object[]{"VARCHAR"}), "newline");
        content.add((Component)new JTextField(4), "");
        content.add(new JComboBox<String>(new String[]{"Characters", "Miles"}), "");
        popupButton.setPopupContent(content);
        JPanel testPanel = new JPanel();
        testPanel.add(new JTextField(20));
        testPanel.add(popupButton);
        UICUtils.runComponent(testPanel);
    }

    public void setPopupContent(JComponent component) {
        this.popupContent.add((Component)component, "Center");
    }

    private void toggle() {
        if (this.isSelected() && System.currentTimeMillis() > this.reactivationTimeLimit) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PopupButton.this.isShowing()) {
                        PopupButton.this.showPopup();
                    }
                }
            });
        } else {
            this.hidePopup();
        }
    }

    protected void showPopup() {
        Point p = this.getLocationOnScreen();
        this.createPopup();
        this.popup.add(this.popupContent);
        this.popup.pack();
        int x = p.x;
        int screenW = this.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth();
        int overrun = p.x + this.popup.getWidth() - screenW;
        if (overrun > 0) {
            x -= overrun;
        }
        int y = p.y + this.getHeight();
        int screenH = this.getGraphicsConfiguration().getDevice().getDisplayMode().getHeight();
        if (y + this.popup.getHeight() > screenH) {
            y = p.y - this.popup.getHeight();
        }
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
        Component focusComp = this.popup.getFocusTraversalPolicy().getFirstComponent(this.popupContent);
        if (focusComp != null) {
            focusComp.requestFocus();
        }
    }

    protected void hidePopup() {
        this.setSelected(false);
        Window parentWin = SwingUtilities.windowForComponent(this);
        if (parentWin != null) {
            parentWin.removeWindowStateListener(this.parentWindowL);
            parentWin.removeComponentListener(this.parentWindowL);
        }
        if (this.popup != null) {
            this.popup.removeWindowFocusListener(this.focusL);
            this.popup.setVisible(false);
            this.popup.dispose();
        }
        this.popup = null;
        this.reactivationTimeLimit = System.currentTimeMillis() + 400L;
    }

    private void createPopup() {
        Window parentWin = SwingUtilities.windowForComponent(this);
        this.popup = new JWindow(parentWin);
        this.popup.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        JComponent content = (JComponent)this.popup.getContentPane();
        String close = "close";
        content.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
        content.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "close");
        content.getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupButton.this.hidePopup();
                PopupButton.this.requestFocus();
            }
        });
        this.popup.addWindowFocusListener(this.focusL);
        parentWin.addWindowStateListener(this.parentWindowL);
        parentWin.addComponentListener(this.parentWindowL);
        this.parentWindowL.location = parentWin.getLocationOnScreen();
    }

    private class ParentWindowL
    extends WindowAdapter
    implements ComponentListener {
        private Point location = new Point(-1, -1);

        private ParentWindowL() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            switch (e.getID()) {
                case 201: 
                case 202: 
                case 203: 
                case 206: {
                    PopupButton.this.hidePopup();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            PopupButton.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Window win = (Window)e.getComponent();
            if (win != null && !win.getLocationOnScreen().equals(this.location)) {
                PopupButton.this.hidePopup();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            PopupButton.this.hidePopup();
        }
    }

    private class FocusL
    implements WindowFocusListener {
        private FocusL() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            PopupButton.this.hidePopup();
        }
    }
}

