/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.StyleSheet;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.UnknownActionException;
import oracle.javatools.ui.ghost.UIConstants;

public final class RichHintLabel
extends JEditorPane {
    private final Map<String, Action> _actions = new HashMap<String, Action>();

    public RichHintLabel() {
        this.configureTextPane();
    }

    private JEditorPane pane() {
        return this;
    }

    public void registerAction(@NotNull String id, @NotNull Action action) {
        if (id == null) {
            throw new NullPointerException("action is null");
        }
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this._actions.put(id, action);
    }

    public void unregisterAction(String id) {
        this._actions.remove(id);
    }

    public void setHtmlText(@NotNull String htmlText) {
        if (htmlText == null) {
            throw new NullPointerException("htmlText is null");
        }
        this.pane().setText(this.adjustHtml(htmlText));
    }

    @NotNull
    public String getHtmlText() {
        return this.pane().getText();
    }

    @Override
    public boolean isFocusable() {
        return this._actions.size() != 0 && super.isFocusable();
    }

    private String adjustHtml(String originalHtml) {
        return this.surroundWithHtml(originalHtml);
    }

    private String surroundWithHtml(String text) {
        return "<html><p>" + text + "</p></html>";
    }

    private void configureTextPane() {
        this.pane().putClientProperty(UIConstants.VETO_CONVERSION, true);
        this.pane().setEditorKit(new RichHintLabelEditorKit());
        this.pane().setBorder(BorderFactory.createEmptyBorder());
        this.pane().setEditable(false);
        this.pane().setHighlighter(new FocusHighlighter());
        this.pane().setOpaque(false);
        this.pane().setCaret(new DefaultCaret(){

            @Override
            public void setSelectionVisible(boolean vis) {
                super.setSelectionVisible(false);
            }
        });
        this.pane().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                Action action;
                if (!fe.isTemporary() && fe.getOppositeComponent() != null && (action = RichHintLabel.this.getActionMap().get("next-link-action")) != null) {
                    RichHintLabel.this.pane().setCaretPosition(0);
                    action.actionPerformed(new ActionEvent(RichHintLabel.this.pane(), 1001, "next-link-action"));
                }
            }

            @Override
            public void focusLost(FocusEvent fe) {
                Highlighter hlter;
                if (!fe.isTemporary() && (hlter = RichHintLabel.this.pane().getHighlighter()) instanceof FocusHighlighter) {
                    ((FocusHighlighter)hlter).clearHighLights();
                }
            }
        });
        this.pane().addHyperlinkListener(new HyperlinkL());
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" color: #5A5A5A; ");
        rule.append(" }");
        return rule.toString();
    }

    static class ActivateLinkAction
    extends TextAction {
        public ActivateLinkAction(String actionName) {
            super(actionName);
        }

        private void activateLink(String href, HTMLDocument doc, JEditorPane editor, int offset) {
            URL url = null;
            try {
                URL page = (URL)doc.getProperty("stream");
                url = new URL(page, href);
            }
            catch (MalformedURLException m) {
                // empty catch block
            }
            HyperlinkEvent linkEvent = new HyperlinkEvent(editor, HyperlinkEvent.EventType.ACTIVATED, url, href, doc.getCharacterElement(offset));
            editor.fireHyperlinkUpdate(linkEvent);
        }

        private void doObjectAction(JEditorPane editor, Element elem) {
            AccessibleAction aa;
            AccessibleContext ac;
            Component comp;
            View view = this.getView(editor, elem);
            if (view != null && view instanceof ObjectView && (comp = ((ObjectView)view).getComponent()) != null && comp instanceof Accessible && (ac = ((Accessible)((Object)comp)).getAccessibleContext()) != null && (aa = ac.getAccessibleAction()) != null) {
                aa.doAccessibleAction(0);
            }
        }

        private View getRootView(JEditorPane editor) {
            return editor.getUI().getRootView(editor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private View getView(JEditorPane editor, Element elem) {
            Object lock = this.lock(editor);
            try {
                View rootView = this.getRootView(editor);
                int start = elem.getStartOffset();
                if (rootView != null) {
                    View view = this.getView(rootView, elem, start);
                    return view;
                }
                View view = null;
                return view;
            }
            finally {
                this.unlock(lock);
            }
        }

        private View getView(View parent, Element elem, int start) {
            if (parent.getElement() == elem) {
                return parent;
            }
            int index = parent.getViewIndex(start, Position.Bias.Forward);
            if (index != -1 && index < parent.getViewCount()) {
                return this.getView(parent.getView(index), elem, start);
            }
            return null;
        }

        private Object lock(JEditorPane editor) {
            Document document = editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
                return document;
            }
            return null;
        }

        private void unlock(Object key) {
            if (key != null) {
                ((AbstractDocument)key).readUnlock();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            if (c.isEditable() || !(c instanceof JEditorPane)) {
                return;
            }
            JEditorPane editor = (JEditorPane)c;
            Document d = editor.getDocument();
            if (d == null || !(d instanceof HTMLDocument)) {
                return;
            }
            HTMLDocument doc = (HTMLDocument)d;
            ElementIterator ei = new ElementIterator(doc);
            int currentOffset = editor.getCaretPosition();
            Object urlString = null;
            Object objString = null;
            Element currentElement = null;
            while ((currentElement = ei.next()) != null) {
                Object obj;
                String name = currentElement.getName();
                AttributeSet attr = currentElement.getAttributes();
                Object href = ActivateLinkAction.getAttrValue(attr, HTML.Attribute.HREF);
                if (href != null) {
                    if (currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                    this.activateLink((String)href, doc, editor, currentOffset);
                    return;
                }
                if (!name.equals(HTML.Tag.OBJECT.toString()) || (obj = ActivateLinkAction.getAttrValue(attr, HTML.Attribute.CLASSID)) == null || currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                this.doObjectAction(editor, currentElement);
                return;
            }
        }

        private static Object getAttrValue(AttributeSet attr, HTML.Attribute key) {
            Enumeration<?> names = attr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object nextKey = names.nextElement();
                Object nextVal = attr.getAttribute(nextKey);
                if (nextVal instanceof AttributeSet) {
                    Object value = ActivateLinkAction.getAttrValue((AttributeSet)nextVal, key);
                    if (value == null) continue;
                    return value;
                }
                if (nextKey != key) continue;
                return nextVal;
            }
            return null;
        }
    }

    private static class FocusHighlighter
    extends DefaultHighlighter {
        private static final String _PAINTER_NAME = "javax.swing.text.html.HTMLEditorKit.NavigateLinkAction.FocusHighlightPainter";
        private static final FocusHighlightPainter _PAINTER = new FocusHighlightPainter();
        private Object _focusTag = null;

        private FocusHighlighter() {
        }

        @Override
        public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
            if (_PAINTER_NAME.equals(p.getClass().getCanonicalName())) {
                this.clearHighLights();
                this._focusTag = super.addHighlight(p0, p1, _PAINTER);
                return null;
            }
            return super.addHighlight(p0, p1, p);
        }

        public void clearHighLights() {
            if (this._focusTag != null) {
                super.removeHighlight(this._focusTag);
            }
        }

        @Override
        public void deinstall(JTextComponent c) {
            this.clearHighLights();
            super.deinstall(c);
        }

        @Override
        public void removeAllHighlights() {
            this.clearHighLights();
            super.removeAllHighlights();
        }

        private static class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public FocusHighlightPainter() {
                super(UIManager.getColor("Button.focus"));
            }

            @Override
            public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                g.setColor(this.getColor());
                if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                    Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                    g.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height - 1);
                    return alloc;
                }
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
                    return r;
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
        }
    }

    private static class RichHintLabelEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;
        private static final Action[] _DEFACTIONS;

        private RichHintLabelEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("a {color: 2255BA; text-decoration:none}"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(RichHintLabel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            StringReader r = null;
            try {
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return ss;
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            return new MyDocument(ss);
        }

        @Override
        public Action[] getActions() {
            return TextAction.augmentList(super.getActions(), _DEFACTIONS);
        }

        static {
            _DEFACTIONS = new Action[]{new ActivateLinkAction("activate-link-action")};
        }
    }

    private class HyperlinkL
    implements HyperlinkListener,
    PropertyChangeListener {
        private Style hoverStyle;
        private Style normalStyle;

        private HyperlinkL() {
            RichHintLabel.this.pane().addPropertyChangeListener("document", this);
            StyledDocument doc = (StyledDocument)RichHintLabel.this.pane().getDocument();
            this.hoverStyle = doc.addStyle("hover", null);
            StyleConstants.setUnderline(this.hoverStyle, true);
            StyleConstants.setForeground(this.hoverStyle, Colors.HYPERLINK_HOVER);
            this.normalStyle = doc.addStyle("normal", null);
            StyleConstants.setUnderline(this.normalStyle, false);
            StyleConstants.setForeground(this.normalStyle, Colors.HYPERLINK);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StyledDocument doc = (StyledDocument)RichHintLabel.this.pane().getDocument();
            Style hoverStyle = doc.addStyle("hover", null);
            StyleConstants.setUnderline(hoverStyle, true);
            Style normalStyle = doc.addStyle("normal", null);
            StyleConstants.setUnderline(normalStyle, false);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            Element element;
            StyledDocument doc = (StyledDocument)RichHintLabel.this.pane().getDocument();
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                element = e.getSourceElement();
                doc.setCharacterAttributes(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), this.hoverStyle, false);
            }
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                element = e.getSourceElement();
                doc.setCharacterAttributes(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), this.normalStyle, false);
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String actionId = null;
                Action action = null;
                if (e.getURL() != null) {
                    URL url = e.getURL();
                    actionId = url.getPath();
                    action = (Action)RichHintLabel.this._actions.get(url.getPath());
                    if (action == null) {
                        action = (Action)RichHintLabel.this._actions.get(url.toExternalForm());
                    }
                } else {
                    actionId = e.getDescription();
                    action = (Action)RichHintLabel.this._actions.get(e.getDescription());
                }
                if (action == null) {
                    throw new UnknownActionException(actionId);
                }
                action.actionPerformed(new ActionEvent(RichHintLabel.this, 1001, actionId));
            }
        }
    }

    private static class MyDocument
    extends HTMLDocument {
        MyDocument(StyleSheet s) {
            super(s);
            this.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        }
    }
}

