/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicSeparatorUI;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.internal.UICUtils;

public class TitledSeparator
extends JPanel {
    private static Stroke dottedStroke = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{0.0f, 4.0f}, 0.0f);
    private static Stroke lineStroke = new BasicStroke(1.0f, 2, 2);
    private JComponent component;
    private final JSeparator leadingSep = new JSeparator();
    private final JSeparator trailingSep = new JSeparator();
    private STYLE style = STYLE.LINE;

    public TitledSeparator(String title) {
        this.component = new JLabel();
        this.init();
        this.setTitle(title);
    }

    public TitledSeparator(String title, STYLE style) {
        this.component = new JLabel();
        this.style = style;
        this.init();
        this.setTitle(title);
    }

    public TitledSeparator(JComponent component, STYLE style) {
        this.style = style;
        this.component = component;
        this.init();
    }

    public void setTitle(String text) {
        if (!(this.component instanceof JLabel)) {
            throw new IllegalStateException("Attempt to set title on a non-label component in a TitledSeparator");
        }
        ((JLabel)this.component).setText(text);
    }

    public String getTitle() {
        if (this.component instanceof JLabel) {
            return ((JLabel)this.component).getText();
        }
        throw new IllegalStateException("Attempt to set title on a non-label component in a TitledSeparator");
    }

    public void setSeparatorColor(Color color) {
        this.leadingSep.setForeground(color);
        this.trailingSep.setForeground(color);
    }

    public Color getSeparatorColor() {
        return this.leadingSep.getForeground();
    }

    private void init() {
        this.setOpaque(false);
        this.component.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.component.setOpaque(false);
        this.setLayout(new BorderLayout(2, 0));
        JPanel labelPanel = new JPanel(new BorderLayout(1, 0));
        labelPanel.setOpaque(false);
        Color sepColor = Colors.isFusionBlueLAF() ? new Color(204, 204, 204) : UIManager.getColor("Label.disabledForeground");
        this.leadingSep.setUI(new DottedSeparatorUI());
        this.leadingSep.setForeground(sepColor);
        this.leadingSep.setPreferredSize(new Dimension(10, 2));
        this.trailingSep.setUI(new DottedSeparatorUI());
        this.trailingSep.setForeground(sepColor);
        labelPanel.add((Component)this.leadingSep, "Before");
        labelPanel.add((Component)this.component, "After");
        this.add((Component)labelPanel, "Before");
        this.add((Component)this.trailingSep, "Center");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        JPanel p = new JPanel((LayoutManager)new MigLayout("fill"));
        p.add((Component)new TitledSeparator("Line"), "w 200");
        p.add((Component)new TitledSeparator("Dotted", STYLE.DOTTED), "newline, w 200");
        p.add((Component)new TitledSeparator(new JCheckBox("JCheckBox"), STYLE.LINE), "newline, w 200");
        p.add((Component)new TitledSeparator(new JCheckBox("JCheckBox"), STYLE.DOTTED), "newline, w 200");
        p.add((Component)new TitledSeparator(new JComboBox<Object>(new Object[]{"ComboBox"}), STYLE.LINE), "newline, w 200");
        p.add((Component)new TitledSeparator(new JComboBox<Object>(new Object[]{"ComboBox"}), STYLE.DOTTED), "newline, w 200");
        UICUtils.runComponent(p);
    }

    private class DottedSeparatorUI
    extends BasicSeparatorUI {
        private DottedSeparatorUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Dimension s = c.getSize();
            int y = 1 + s.height / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(c.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(TitledSeparator.this.style.getStroke());
            g2.drawLine(0, y, s.width, y);
            g2.dispose();
        }
    }

    public static enum STYLE {
        LINE,
        DOTTED;


        public Stroke getStroke() {
            switch (this) {
                case LINE: {
                    return lineStroke;
                }
                case DOTTED: {
                    return dottedStroke;
                }
            }
            return new BasicStroke();
        }
    }
}

