/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

public final class WindowTiler {
    private Component primary;
    private Window primaryWindow;
    private Window secondary;
    private int gap = 4;
    private Listener listener = new Listener();
    private boolean isAdjusting = false;
    private List<Alignment> alignments = new ArrayList<Alignment>();

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public WindowTiler(Component primary, Window secondary) {
        this.alignments.add(Alignment.RIGHT);
        this.alignments.add(Alignment.LEFT);
        this.alignments.add(Alignment.BOTTOM);
        this.alignments.add(Alignment.TOP);
        this.primary = primary;
        this.secondary = secondary;
        primary.addComponentListener(this.listener);
        secondary.addComponentListener(this.listener);
        secondary.addWindowListener(this.listener);
        this.primaryWindow = primary instanceof Window ? (Window)primary : SwingUtilities.getWindowAncestor(primary);
        this.primaryWindow.addWindowListener(this.listener);
        this.primaryWindow.addComponentListener(this.listener);
    }

    private void cleanUp() {
        this.primary.removeComponentListener(this.listener);
        this.secondary.removeComponentListener(this.listener);
        this.secondary.removeWindowListener(this.listener);
        this.primaryWindow.removeWindowListener(this.listener);
        this.primaryWindow.removeComponentListener(this.listener);
        this.primary = null;
        this.secondary = null;
        this.primaryWindow = null;
    }

    public void setAlignment(List<Alignment> alignment) {
        this.alignments.clear();
        this.alignments.addAll(alignment);
        this.updateTiling();
    }

    public List<Alignment> getAlignment() {
        return Collections.unmodifiableList(this.alignments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTiling() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isAdjusting) {
            return;
        }
        if (!this.primary.isShowing()) {
            return;
        }
        this.isAdjusting = true;
        try {
            for (Alignment a : this.alignments) {
                if (!a.tile(this.primary, this.secondary, this.gap, false)) continue;
                return;
            }
            if (this.alignments.size() > 0) {
                this.alignments.get(0).tile(this.primary, this.secondary, this.gap, true);
            }
        }
        finally {
            this.isAdjusting = false;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements WindowListener {
        private Listener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            WindowTiler.this.updateTiling();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WindowTiler.this.updateTiling();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            WindowTiler.this.cleanUp();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;


        private boolean tile(Component primary, Component secondary, int gap, boolean force) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle primaryBounds = primary.getBounds();
            Point loc = primary.getLocationOnScreen();
            primaryBounds.x = loc.x;
            primaryBounds.y = loc.y;
            Rectangle secondaryBounds = secondary.getBounds();
            switch (this) {
                case LEFT: {
                    int x = primaryBounds.x - gap - secondaryBounds.width;
                    int y = primaryBounds.y;
                    if (y + secondaryBounds.height > screen.height) {
                        y = screen.height - secondaryBounds.height;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if (!force && x <= 0) break;
                    secondary.setLocation(x, y);
                    return true;
                }
                case RIGHT: {
                    int x = primaryBounds.x + primaryBounds.width + gap;
                    int y = primaryBounds.y;
                    if (y + secondaryBounds.height > screen.height) {
                        y = screen.height - secondaryBounds.height;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if (!force && x + secondaryBounds.width >= screen.width) break;
                    secondary.setLocation(x, y);
                    return true;
                }
                case TOP: {
                    int y = primaryBounds.y - secondaryBounds.height - gap;
                    int x = primaryBounds.x;
                    if (x + secondaryBounds.width > screen.width) {
                        x = screen.width - secondaryBounds.width;
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if (!force && y <= 0) break;
                    secondary.setLocation(x, y);
                    return true;
                }
                case BOTTOM: {
                    int y = primaryBounds.y + primaryBounds.height + gap;
                    int x = primaryBounds.x;
                    if (x + secondaryBounds.width > screen.width) {
                        x = screen.width - secondaryBounds.width;
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if (!force && y + secondaryBounds.height >= screen.height) break;
                    secondary.setLocation(x, y);
                    return true;
                }
            }
            return false;
        }
    }
}

