/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.border.AbstractBorder;

public class PointingBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private Direction direction;
    private int pointHeight = 8;
    private int pointWidth = 16;
    private static final Color SHADOW_COLOR = new Color(0, 0, 0, 75);
    private static final int SHADOW_WIDTH = 4;
    private static final float CORNER_ARC = 4.0f;
    private static final Insets INTERNAL_INDENT = new Insets(0, 2, 0, 0);
    private static final Insets OUTER_INDENT_NONE = new Insets(1, 1, 6, 7);
    private static final Insets OUTER_INDENT_UP = new Insets(1, 1, 6, 7);
    private static final Insets OUTER_INDENT_DOWN = new Insets(1, 1, 2, 7);
    private static final Insets OUTER_INDENT_LEFT = new Insets(1, 1, 6, 7);
    private static final Insets OUTER_INDENT_RIGHT = new Insets(1, 1, 6, 3);
    private Insets OUTER_INDENT;
    private Insets insets;
    private static final ConvolveOp simpleBlur;
    private Color borderColor = Color.LIGHT_GRAY;
    private Stroke borderStroke = new BasicStroke(1.0f);
    private int xOffset = 0;
    private int yOffset = 0;
    private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);

    public PointingBorder(Direction direction) {
        this.setDirection(direction);
    }

    public void setPointSize(int width, int height) {
        this.pointWidth = width;
        this.pointHeight = height;
        this.setDirection(this.direction);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        switch (direction) {
            case DOWN: {
                this.insets = new Insets(PointingBorder.OUTER_INDENT_DOWN.top + PointingBorder.INTERNAL_INDENT.top, PointingBorder.OUTER_INDENT_DOWN.left + PointingBorder.INTERNAL_INDENT.left, PointingBorder.OUTER_INDENT_DOWN.bottom + this.pointHeight + PointingBorder.INTERNAL_INDENT.bottom, PointingBorder.OUTER_INDENT_DOWN.right + PointingBorder.INTERNAL_INDENT.right);
                this.OUTER_INDENT = OUTER_INDENT_DOWN;
                break;
            }
            case UP: {
                this.insets = new Insets(PointingBorder.OUTER_INDENT_UP.top + this.pointHeight + PointingBorder.INTERNAL_INDENT.top, PointingBorder.OUTER_INDENT_UP.left + PointingBorder.INTERNAL_INDENT.left, PointingBorder.OUTER_INDENT_UP.bottom + PointingBorder.INTERNAL_INDENT.bottom, PointingBorder.OUTER_INDENT_UP.right + PointingBorder.INTERNAL_INDENT.right);
                this.OUTER_INDENT = OUTER_INDENT_UP;
                break;
            }
            case LEFT: {
                this.insets = new Insets(PointingBorder.OUTER_INDENT_LEFT.top + PointingBorder.INTERNAL_INDENT.top, PointingBorder.OUTER_INDENT_LEFT.left + PointingBorder.INTERNAL_INDENT.left + this.pointHeight, PointingBorder.OUTER_INDENT_LEFT.bottom + PointingBorder.INTERNAL_INDENT.bottom, PointingBorder.OUTER_INDENT_LEFT.right + PointingBorder.INTERNAL_INDENT.right);
                this.OUTER_INDENT = OUTER_INDENT_LEFT;
                break;
            }
            case RIGHT: {
                this.insets = new Insets(PointingBorder.OUTER_INDENT_RIGHT.top + PointingBorder.INTERNAL_INDENT.top, PointingBorder.OUTER_INDENT_RIGHT.left + PointingBorder.INTERNAL_INDENT.left, PointingBorder.OUTER_INDENT_RIGHT.bottom + PointingBorder.INTERNAL_INDENT.bottom, PointingBorder.OUTER_INDENT_RIGHT.right + PointingBorder.INTERNAL_INDENT.right + this.pointHeight);
                this.OUTER_INDENT = OUTER_INDENT_RIGHT;
                break;
            }
            case NONE: {
                this.insets = new Insets(PointingBorder.OUTER_INDENT_NONE.top + PointingBorder.INTERNAL_INDENT.top, PointingBorder.OUTER_INDENT_NONE.left + PointingBorder.INTERNAL_INDENT.left, PointingBorder.OUTER_INDENT_NONE.bottom + PointingBorder.INTERNAL_INDENT.bottom, PointingBorder.OUTER_INDENT_NONE.right + PointingBorder.INTERNAL_INDENT.right);
                this.OUTER_INDENT = OUTER_INDENT_NONE;
                break;
            }
            default: {
                throw new IllegalStateException(direction.toString());
            }
        }
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shadow = this.getShape(x, y, width, height, true);
        Shape s = this.getShape(x, y, width, height, false);
        this.paintShadow(g2, shadow, s);
        this.paintBackground(g2, c, s);
        g2.setColor(this.borderColor);
        g2.setStroke(this.borderStroke);
        g2.draw(s);
        g2.dispose();
    }

    protected void paintBackground(Graphics2D g2, Component c, Shape s) {
        g2.setColor(c.getBackground());
        Area a = new Area(s);
        g2.fill(a);
    }

    private void paintShadow(Graphics2D g2, Shape shadowShape, Shape componentShape) {
        Rectangle shadowR = shadowShape.getBounds();
        BufferedImage shadowImage = this.getShadowImage(shadowR.width + 8, shadowR.height + 8);
        Graphics2D shadowG = shadowImage.createGraphics();
        Composite composite = shadowG.getComposite();
        shadowG.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, shadowImage.getWidth(), shadowImage.getHeight());
        shadowG.fill(rect);
        shadowG.setComposite(composite);
        shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        shadowG.setColor(SHADOW_COLOR);
        Area clip = new Area(shadowShape);
        clip.subtract(new Area(componentShape));
        shadowG.setClip(clip);
        shadowG.fill(shadowShape);
        shadowG.dispose();
        Graphics2D imageG = (Graphics2D)g2.create();
        imageG.setComposite(AlphaComposite.getInstance(3, 0.558f));
        imageG.drawImage(shadowImage, simpleBlur, 0, 0);
        imageG.dispose();
    }

    private Shape getShape(int x, int y, int width, int height, boolean isShadow) {
        GeneralPath gp = new GeneralPath();
        int SHADOW_MODIFIER = isShadow ? 4 : 0;
        int top = y + this.OUTER_INDENT.top + SHADOW_MODIFIER;
        int bottom = y + height - this.OUTER_INDENT.bottom + SHADOW_MODIFIER;
        int left = x + this.OUTER_INDENT.left + SHADOW_MODIFIER;
        int right = x + width - this.OUTER_INDENT.right + SHADOW_MODIFIER;
        int leftStop = Math.max(left + 4 + this.pointWidth / 2, Math.min(right - 4 - this.pointWidth / 2, x + this.OUTER_INDENT.left + width / 2 - this.pointWidth / 2 + SHADOW_MODIFIER + this.xOffset));
        int rightStop = Math.max(left + 4 + this.pointWidth / 2, Math.min(right - 4 - this.pointWidth / 2, x + this.OUTER_INDENT.left + width / 2 + this.pointWidth / 2 + SHADOW_MODIFIER + this.xOffset));
        int upStop = Math.max(top + 4 + this.pointWidth / 2, Math.min(bottom - 4 - this.pointWidth / 2, y + this.OUTER_INDENT.top + height / 2 - this.pointWidth / 2 + SHADOW_MODIFIER + this.yOffset));
        int downStop = Math.max(top + 4 + this.pointWidth / 2, Math.min(bottom - 4 - this.pointWidth / 2, y + this.OUTER_INDENT.top + height / 2 + this.pointWidth / 2 + SHADOW_MODIFIER + this.yOffset));
        int upDownPoint = Math.max(left + 4 + this.pointWidth / 2, Math.min(right - 4 - this.pointWidth / 2, x + this.OUTER_INDENT.left + width / 2 + this.xOffset));
        int leftRightPoint = Math.max(top + 4 + this.pointWidth / 2, Math.min(bottom - 4 - this.pointWidth / 2, y + this.OUTER_INDENT.top + height / 2 + this.yOffset));
        if (Math.abs(leftStop - rightStop) < this.pointWidth / 2 && (this.direction == Direction.DOWN || this.direction == Direction.UP)) {
            rightStop += this.pointWidth / 4;
            leftStop -= this.pointWidth / 4;
        }
        if (Math.abs(upStop - downStop) < this.pointWidth / 2 && (this.direction == Direction.LEFT || this.direction == Direction.RIGHT)) {
            upStop -= this.pointWidth / 4;
            downStop += this.pointWidth / 4;
        }
        switch (this.direction) {
            case DOWN: {
                bottom -= this.pointHeight;
                break;
            }
            case UP: {
                top += this.pointHeight;
                break;
            }
            case LEFT: {
                left += this.pointHeight;
                break;
            }
            case RIGHT: {
                right -= this.pointHeight;
            }
        }
        gp.moveTo((float)left + 4.0f, top);
        gp.lineTo(leftStop, top);
        if (this.direction == Direction.UP) {
            gp.lineTo(upDownPoint, top - this.pointHeight - SHADOW_MODIFIER);
        }
        gp.lineTo(rightStop, top);
        gp.lineTo((float)right - 4.0f, top);
        gp.quadTo(right, top, right, (float)top + 4.0f);
        gp.lineTo(right, upStop);
        if (downStop != upStop && this.direction == Direction.RIGHT) {
            gp.lineTo(right + this.pointHeight - SHADOW_MODIFIER, leftRightPoint);
        }
        gp.lineTo(right, downStop);
        gp.lineTo(right, (float)bottom - 4.0f);
        gp.quadTo(right, bottom, (float)right - 4.0f, bottom);
        gp.lineTo(rightStop, bottom);
        if (this.direction == Direction.DOWN) {
            gp.lineTo(upDownPoint, bottom + this.pointHeight - SHADOW_MODIFIER);
        }
        gp.lineTo(leftStop, bottom);
        gp.lineTo((float)left + 4.0f, bottom);
        gp.quadTo(left, bottom, left, (float)bottom - 4.0f);
        gp.lineTo(left, downStop);
        if (downStop != upStop && this.direction == Direction.LEFT) {
            gp.lineTo(left - this.pointHeight - SHADOW_MODIFIER, leftRightPoint);
        }
        gp.lineTo(left, upStop);
        gp.lineTo(left, (float)top + 4.0f);
        gp.quadTo(left, top, (float)left + 4.0f, top);
        return gp;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setXOffset(int offset) {
        this.xOffset = offset;
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }

    private BufferedImage getShadowImage(int width, int height) {
        BufferedImage shadowImage = this.shadowImageRef.get();
        if (shadowImage != null && (shadowImage.getWidth() != width || shadowImage.getHeight() != height)) {
            shadowImage = null;
        }
        if (shadowImage == null) {
            shadowImage = new BufferedImage(width, height, 2);
            this.shadowImageRef = new SoftReference<BufferedImage>(shadowImage);
        }
        return shadowImage;
    }

    static {
        float i = 0.04f;
        float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
        Kernel myKernel = new Kernel(5, 5, elements);
        simpleBlur = new ConvolveOp(myKernel);
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

