/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.ResizeScrollPaneLayout;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.table.EmptyTableTextLayer;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.ui.table.SimpleTableModel;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

class BuiltTableImpl<T>
implements BuiltTable<T> {
    private GenericTable table;
    protected JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
    protected JScrollPane scrollPane = new JScrollPane();
    protected ComponentWithTitlebar componentWithTitlebar;
    protected EmptyTableTextLayer emptyLayer;

    BuiltTableImpl(GenericTable table, TableBuilder.TableInstructions instructions) {
        JXLayer emptyTableLayer;
        this.table = table;
        this.scrollPane.setViewportView(table);
        this.emptyLayer = new EmptyTableTextLayer(table, "");
        Object content = emptyTableLayer = new JXLayer((Component)this.scrollPane, (LayerUI)this.emptyLayer);
        if (instructions.titlebar) {
            content = this.createTitlebarComponent((JComponent)content);
        }
        if (instructions.resize) {
            this.scrollPane.setLayout(new ResizeScrollPaneLayout());
            content = new ResizeComponent((JComponent)content);
        }
        this.contentPanel.add((Component)content, "grow, top, left");
        if (instructions.reorder) {
            ReorderableTable reorderableTable = new ReorderableTable(table);
            ReorderableBar reorderComp = new ReorderableBar(reorderableTable, true);
            this.contentPanel.add((Component)reorderComp, "dock east");
        }
        if (instructions.labelText != null) {
            String text = StringUtils.stripMnemonic((String)instructions.labelText);
            int code = StringUtils.getMnemonicKeyCode((String)instructions.labelText);
            JLabel label = new JLabel(text);
            if (code != 0) {
                label.setDisplayedMnemonic(code);
            }
            label.setLabelFor(table);
            if (instructions.titlebar) {
                this.getComponentWithTitlebar().setLabel(label);
            } else {
                this.contentPanel.add((Component)label, "dock north, gap bottom 4");
            }
        }
    }

    @Override
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public final JComponent getGUI() {
        return this.contentPanel;
    }

    @Override
    public final TextLayer getEmptyTextLayer() {
        return this.emptyLayer;
    }

    @Override
    public final ComponentWithTitlebar getComponentWithTitlebar() {
        return this.componentWithTitlebar;
    }

    protected ComponentWithTitlebar createTitlebarComponent(JComponent component) {
        this.componentWithTitlebar = new ComponentWithTitlebar<JComponent>(component, null, new ControlBar());
        return this.componentWithTitlebar;
    }

    @Override
    public T getSelectedValue() {
        if (!(this.table.getModel() instanceof SimpleTableModel)) {
            throw new IllegalStateException("getSelectedValue() isn't available for custom table models except SimpleTableModel");
        }
        if (!this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()) {
            throw new IllegalStateException("getSelectedValue() only works with row selection, and not column selection");
        }
        SimpleTableModel model = (SimpleTableModel)this.table.getModel();
        int i = this.table.getSelectedRow();
        return i >= 0 ? (T)model.getRow(i) : null;
    }

    @Override
    public int indexOf(T rowObject) {
        if (!(this.table.getModel() instanceof SimpleTableModel)) {
            throw new IllegalStateException("getSelectedValue() isn't available for custom table models except SimpleTableModel");
        }
        if (!this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()) {
            throw new IllegalStateException("getSelectedValue() only works with row selection, and not column selection");
        }
        SimpleTableModel model = (SimpleTableModel)this.table.getModel();
        return model.indexOf(rowObject);
    }

    @Override
    public List<T> getSelectedValues() {
        if (!(this.table.getModel() instanceof SimpleTableModel)) {
            throw new IllegalStateException("getSelectedValues() isn't available for custom table models except SimpleTableModel");
        }
        if (!this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()) {
            throw new IllegalStateException("getSelectedValues() only works with row selection, and not column selection");
        }
        SimpleTableModel model = (SimpleTableModel)this.table.getModel();
        ArrayList list = new ArrayList();
        for (int i : this.table.getSelectedRows()) {
            list.add(model.getRow(i));
        }
        return list;
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    GenericTable getGenericTable() {
        return this.table;
    }

    @Override
    public int getSelectedRow() {
        return BuiltTableImpl.getSelectedRowImpl(this.table);
    }

    @Override
    public List<Integer> getSelectedRows() {
        return BuiltTableImpl.getSelectedRowsImpl(this.table);
    }

    @Override
    public List<Point> getSelectedCells() {
        return BuiltTableImpl.getSelectedCellsImpl(this.table);
    }

    @Override
    public int[] getHiddenColumns() {
        return this.table.getHiddenColumns();
    }

    @Override
    public void setHiddenColumns(int ... hiddenColumns) {
        this.table.setHiddenColumns(hiddenColumns);
    }

    @Override
    public void setHiddenColumnsVisible(int[] columns) {
        this.table.setHiddenColumnsVisible(columns);
    }

    static int getSelectedRowImpl(JTable table) {
        return table.getSelectedRow();
    }

    static List<Integer> getSelectedRowsImpl(JTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : table.getSelectedRows()) {
            list.add(i);
        }
        return list;
    }

    static List<Point> getSelectedCellsImpl(JTable table) {
        ArrayList<Point> list = new ArrayList<Point>();
        int rowIndexStart = table.getSelectedRow();
        int rowIndexEnd = table.getSelectionModel().getMaxSelectionIndex();
        int colIndexStart = table.getSelectedColumn();
        int colIndexEnd = table.getColumnModel().getSelectionModel().getMaxSelectionIndex();
        for (int r = rowIndexStart; r <= rowIndexEnd; ++r) {
            for (int c = colIndexStart; c <= colIndexEnd; ++c) {
                if (!table.isCellSelected(r, c)) continue;
                list.add(new Point(r, c));
            }
        }
        return list;
    }
}

