/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ExpansionTreeTip;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.ResizeScrollPaneLayout;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.builders.BuiltTree;
import oracle.javatools.ui.builders.TreeBuilder;
import oracle.javatools.ui.tree.EmptyTreeTextLayer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

final class BuiltTreeImpl<T>
implements BuiltTree<T> {
    private JTree tree;
    protected JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
    protected JScrollPane scrollPane = new JScrollPane();
    protected ComponentWithTitlebar componentWithTitlebar;
    protected EmptyTreeTextLayer emptyLayer;

    BuiltTreeImpl(TreeBuilder.TreeInstructions instructions) {
        JXLayer emptyTableLayer;
        this.tree = new BetterTree();
        this.tree.setModel(instructions.model);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        this.scrollPane.setViewportView(this.tree);
        this.emptyLayer = new EmptyTreeTextLayer(this.tree, "");
        Object content = emptyTableLayer = new JXLayer((Component)this.scrollPane, (LayerUI)this.emptyLayer);
        if (instructions.titlebar) {
            content = this.createTitlebarComponent((JComponent)content);
        }
        if (instructions.resize) {
            this.scrollPane.setLayout(new ResizeScrollPaneLayout());
            content = new ResizeComponent((JComponent)content);
        }
        this.contentPanel.add((Component)content, "top, left, grow");
        if (instructions.labelText != null) {
            String text = StringUtils.stripMnemonic((String)instructions.labelText);
            int code = StringUtils.getMnemonicKeyCode((String)instructions.labelText);
            JLabel label = new JLabel(text);
            if (code != 0) {
                label.setDisplayedMnemonic(code);
            }
            label.setLabelFor(this.tree);
            if (instructions.titlebar) {
                this.getComponentWithTitlebar().setLabel(label);
            } else {
                this.contentPanel.add((Component)label, "dock north, gap bottom 4");
            }
        }
        if (instructions.doubleClickListener != null) {
            this.tree.addMouseListener(new DoubleClickL(instructions.doubleClickListener));
            this.tree.setToggleClickCount(0);
        }
        if (instructions.contextListener != null) {
            this.tree.addMouseListener(new MouseL(instructions.contextListener));
        }
        if (instructions.renderer != null) {
            this.tree.setCellRenderer(instructions.renderer);
        }
        if (instructions.expandTip) {
            new ExpansionTreeTip(this.tree);
        }
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(instructions.selectionMode);
        this.tree.setSelectionModel(selectionModel);
        this.tree.setVisibleRowCount(instructions.visibleRows);
        this.getEmptyTextLayer().setText(instructions.emptyText);
        this.getEmptyTextLayer().setFont(instructions.emptyTextFont);
    }

    @Override
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public final JComponent getGUI() {
        return this.contentPanel;
    }

    @Override
    public final TextLayer getEmptyTextLayer() {
        return this.emptyLayer;
    }

    @Override
    public final ComponentWithTitlebar getComponentWithTitlebar() {
        return this.componentWithTitlebar;
    }

    protected ComponentWithTitlebar createTitlebarComponent(JComponent component) {
        this.componentWithTitlebar = new ComponentWithTitlebar<JComponent>(component, null, null);
        return this.componentWithTitlebar;
    }

    @Override
    public T getSelectedValue() {
        return null;
    }

    @Override
    public List<T> getSelectedValues() {
        return Collections.emptyList();
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    private static class BetterTree
    extends JTree {
        private BetterTree() {
        }

        @Override
        public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
            TreeCellRenderer renderer = this.getCellRenderer();
            int max = this.getRowCount();
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            if (startingRow < 0 || startingRow >= max) {
                throw new IllegalArgumentException();
            }
            prefix = prefix.toUpperCase();
            int increment = bias == Position.Bias.Forward ? 1 : -1;
            int row = startingRow;
            do {
                TreePath path;
                Component c;
                if (!((c = renderer.getTreeCellRendererComponent(this, (path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), true, row, false)) instanceof JLabel)) {
                    return super.getNextMatch(prefix, startingRow, bias);
                }
                JLabel label = (JLabel)c;
                String text = label.getText();
                if (!(text = text.replaceAll("\\<.*?>", "")).toUpperCase().startsWith(prefix)) continue;
                return path;
            } while ((row = (row + increment + max) % max) != startingRow);
            return null;
        }
    }

    private static class MouseL
    extends MouseAdapter {
        private ActionListener listener;

        private MouseL(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        private void handleContextMenu(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int row = tree.getRowForLocation(e.getX(), e.getY());
            if (row == -1) {
                return;
            }
            Rectangle bounds = tree.getRowBounds(row);
            if (bounds.contains(e.getPoint())) {
                tree.setSelectionRow(row);
            }
            if (e.isPopupTrigger()) {
                this.listener.actionPerformed(new ActionEvent(e, 1001, "context"));
            }
        }
    }

    private static class DoubleClickL
    extends MouseAdapter {
        private ActionListener listener;

        private DoubleClickL(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTree tree;
            int r;
            if (e.getClickCount() == 2 && (r = (tree = (JTree)e.getSource()).getRowForLocation(e.getPoint().x, e.getPoint().y)) > -1 && tree.getRowBounds(r).contains(e.getPoint())) {
                this.listener.actionPerformed(new ActionEvent(tree, 1001, "doubleClick"));
            }
        }
    }
}

