/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.builders.BasicBuilder;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.javatools.ui.list.GenericCheckListCellRenderer;
import oracle.javatools.ui.list.LabelListCellRenderer;

class ExAppListPanel
extends ExAppBasicPanel {
    private static BuiltList<String> lc;
    private Reorder reorder = new Reorder();
    private Editable editable = new Editable();
    private Sort sort = new Sort();
    private Selection selection = new Selection();
    private Renderer renderer = new Renderer();
    private DefaultActions defaultactions = new DefaultActions();
    private RenderUsingMethod renderusingmethod = new RenderUsingMethod();
    protected VisibleRows visiblerows = new VisibleRows();
    private int i = 0;
    private static final String[] ANIMALS;
    private static final String[] COLORS;

    ExAppListPanel() {
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, nogrid, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppListPanel.this.build();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add((Component)ExAppListPanel.headingLabel("Configuration"), "wrap");
        controlPanel.add((Component)new JLabel("Model:"), "");
        controlPanel.add((Component)MODEL_TYPE.combo, "wrap");
        controlPanel.add((Component)new JLabel("Selection:"), "");
        controlPanel.add((Component)SELECTION_MODE.combo, "wrap");
        controlPanel.add((Component)this.rollover.cb, "span, wrap");
        controlPanel.add((Component)this.reorder.cb, "span, wrap");
        controlPanel.add((Component)this.editable.cb, "span");
        controlPanel.add((Component)this.editable.cb2, "gapleft 6, span, wrap");
        controlPanel.add((Component)this.resize.cb, "span, wrap");
        controlPanel.add((Component)this.checkable.cb, "");
        controlPanel.add((Component)this.checkable.b2, "span, wrap");
        controlPanel.add((Component)this.selection.cb, "span, wrap");
        controlPanel.add((Component)this.sort.cb, "span, wrap");
        controlPanel.add((Component)this.doubleclick.cb, "span, wrap");
        controlPanel.add((Component)this.renderer.cb, "span, wrap");
        controlPanel.add((Component)new JLabel("Visible Rows:"), "");
        controlPanel.add((Component)this.visiblerows.sp, "span, wrap");
        controlPanel.add((Component)this.renderusingmethod.cb, "");
        controlPanel.add((Component)this.renderusingmethod.tf, "wrap");
        controlPanel.add((Component)this.actions.cb, "span, wrap");
        controlPanel.add((Component)this.moreactions.cb, "");
        controlPanel.add((Component)this.moreactions.tf, "span, wrap");
        controlPanel.add((Component)this.defaultactions.cb, "span, wrap");
        controlPanel.add((Component)this.emptytext.cb, "");
        controlPanel.add((Component)this.emptytext.tf, "");
        controlPanel.add((Component)this.emptytext.lcb, "wrap");
        controlPanel.add((Component)this.label.cb, "");
        controlPanel.add((Component)this.label.tf, "wrap");
        controlPanel.add((Component)this.titlebar.cb, "span, wrap");
        controlPanel.add((Component)this.selectionenabled.cb, "");
        controlPanel.add((Component)this.selectionenabled.b, "wrap");
        return controlPanel;
    }

    protected void build() {
        ListBuilder builder = new ListBuilder();
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        MODEL_TYPE.build(builder, createSB, selectSB);
        SELECTION_MODE.build(builder, createSB, selectSB);
        this.resize.build(builder, createSB, selectSB);
        this.visiblerows.build(builder, createSB, selectSB);
        this.rollover.build(builder, createSB, selectSB);
        this.reorder.build(builder, createSB, selectSB);
        this.editable.build(builder, createSB, selectSB);
        this.checkable.build(builder, createSB, selectSB);
        this.selection.build(builder, createSB, selectSB);
        this.sort.build(builder, createSB, MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
        this.doubleclick.build(builder, createSB, selectSB);
        this.renderer.build(builder, createSB, selectSB);
        this.renderusingmethod.build(builder, createSB, selectSB);
        this.emptytext.build(builder, createSB, selectSB);
        this.label.build(builder, createSB, selectSB);
        this.selectionenabled.build(builder, createSB, selectSB);
        this.titlebar.build(builder, createSB, selectSB);
        this.actions.build(builder, createSB, selectSB);
        this.moreactions.build(builder, createSB, selectSB);
        this.defaultactions.build(builder, createSB, selectSB);
        switch ((MODEL_TYPE)((Object)MODEL_TYPE.combo.getSelectedItem())) {
            case ARRAY: 
            case LIST: {
                createSB.append("\nBuiltList<String> builtList = builder.build();\n\nadd(builtList.getGUI());");
                break;
            }
            case OBJECT: {
                createSB.append("\nBuiltList<Locale> builtList = builder.build();\n\nadd(builtList.getGUI());");
            }
        }
        this.constructTextArea.setText(createSB.toString());
        this.constructTextArea.setCaretPosition(0);
        this.selectTextArea.setText(selectSB.toString());
        this.selectTextArea.setCaretPosition(0);
        lc = builder.build();
        this.updateComponent(lc.getGUI());
    }

    @Override
    protected void dump() {
        if (lc == null) {
            return;
        }
        System.out.println("Dump as java.util.List (no parameter)");
        List<String> list = lc.getListModel();
        System.out.println(list);
        System.out.println();
        System.out.println("Dump as java.util.List<String>");
        List<String> stringList = lc.getListModel();
        System.out.println(stringList);
        System.out.println();
        System.out.println("Selected item");
        System.out.println((String)lc.getSelectedValue());
        System.out.println();
        System.out.println("Selected items (list)");
        System.out.println(lc.getSelectedValues());
        System.out.println();
        System.out.println("---------------------------------");
    }

    static {
        ANIMALS = new String[]{"Cows", "Mice", "Monkeys", "Birds", "Lions", "Rats", "Rhinos", "Elephants", "Hippos", "Spiders", "Tigers", "Cats", "Dogs"};
        COLORS = new String[]{"Red", "Blue", "Magenta", "Violet", "Yellow", "Cyan", "Green", "Purple", "Mauve", "Beige", "Crimson", "Orange", "Puce"};
    }

    private class DefaultActions {
        JCheckBox cb = new JCheckBox("Default Toolbar Actions");

        private DefaultActions() {
            this.cb.setToolTipText("Add default types action to the toolbar. The builder will automatically take care of setting the correct icon, ordering and enabling them");
        }

        public void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (!this.cb.isSelected()) {
                return;
            }
            builder.setActionsDefault(ListBuilder.DefaultAction.ADD, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                    lc.getListModel().add("Element " + ExAppListPanel.this.i++);
                }
            });
            createSB.append("builder.setActionsDefault(ListBuilder.DefaultAction.ADD, addAction);\n");
            builder.setActionsDefault(ListBuilder.DefaultAction.DELETE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                    lc.getListModel().removeAll(lc.getSelectedValues());
                }
            });
            createSB.append("builder.setActionsDefault(ListBuilder.DefaultAction.DELETE, deleteAction);\n");
            builder.setActionsDefault(ListBuilder.DefaultAction.CLEAR, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(ListBuilder.DefaultAction.CLEAR, clearAction);\n");
            builder.setActionsDefault(ListBuilder.DefaultAction.EDIT, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(ListBuilder.DefaultAction.EDIT, editAction);\n");
            builder.setActionsDefault(ListBuilder.DefaultAction.BROWSE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(ListBuilder.DefaultAction.BROWSE, browseAction);\n");
        }
    }

    protected class VisibleRows {
        int def = 8;
        JSpinner sp = new JSpinner(new SpinnerNumberModel(this.def, 1, 20, 1));

        protected VisibleRows() {
            this.sp.setToolTipText("The default number of rows initially visible");
        }

        void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            int i = (Integer)this.sp.getValue();
            if (i != this.def) {
                builder.setVisibleRows(i);
                createSB.append("builder.setVisibleRows(" + i + ");\n");
            }
        }
    }

    private class Sort {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Sorted");

        private Sort() {
            this.cb.setToolTipText("Initially sort the list, either by their natural ordering or pass a comparator");
        }

        void build(ListBuilder builder, StringBuilder createSB, boolean comparator) {
            if (this.cb.isSelected() != this.def) {
                if (comparator) {
                    builder.setSorter(new Comparator<Locale>(){

                        @Override
                        public int compare(Locale o1, Locale o2) {
                            return o1.getDisplayLanguage().compareTo(o2.getDisplayLanguage());
                        }
                    });
                    createSB.append("builder.setSorter(itemComparator);\n");
                } else {
                    builder.setSortable(this.cb.isSelected());
                    createSB.append("builder.setSortable(" + Boolean.toString(this.cb.isSelected()) + ");\n");
                }
            }
        }
    }

    private class Editable {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Editable", this.def);
        JCheckBox cb2 = new JCheckBox("with Def. Buttons", this.def);

        private Editable() {
            this.cb.setToolTipText("Make the items editable by the user");
            this.cb2.setToolTipText("Include Default Add/Remove Buttons");
        }

        void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setEditable(this.cb.isSelected(), this.cb2.isSelected());
                createSB.append("builder.setEditable(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    private class Reorder {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Reorder", this.def);

        private Reorder() {
            this.cb.setToolTipText("Make the items reorderable by the user");
        }

        void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setReorderable(this.cb.isSelected());
                createSB.append("builder.setReorderable(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    private class Selection {
        JCheckBox cb = new JCheckBox("Selection");

        private Selection() {
            this.cb.setToolTipText("Tell the list which items should be initally selected");
        }

        void build(BasicBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                switch ((MODEL_TYPE)((Object)MODEL_TYPE.combo.getSelectedItem())) {
                    case LIST: {
                        builder.setSelection(COLORS[2], COLORS[5], COLORS[6]);
                        createSB.append("builder.setSelection(COLORS[2], COLORS[5], COLORS[6]);\n");
                        break;
                    }
                    case ARRAY: {
                        builder.setSelection(ANIMALS[2], ANIMALS[5], ANIMALS[6]);
                        createSB.append("builder.setSelection(\"Monkeys\", \"Rats\", \"Rhinos\");\n");
                    }
                }
            }
        }
    }

    private class RenderUsingMethod {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Render Using Method: ", this.def);
        JTextField tf = new JTextField("getDisplayCountry", 16);

        private RenderUsingMethod() {
            this.cb.setToolTipText("Instead of writing a renderer, simply tell the builder which method on the item to call to get the text from");
            this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            this.tf.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            MODEL_TYPE.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RenderUsingMethod.this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                    RenderUsingMethod.this.tf.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                }
            });
        }

        void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isEnabled() && this.cb.isSelected() != this.def) {
                builder.setRenderUsingMethod(this.tf.getText());
                createSB.append("builder.setRenderUsingMethod(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    private class Renderer {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Renderer (for Locale)", this.def);

        private Renderer() {
            this.cb.setToolTipText("Set a renderer for the list");
            this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            MODEL_TYPE.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Renderer.this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                }
            });
        }

        void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isEnabled() && this.cb.isSelected() != this.def) {
                builder.setRenderer((ListCellRenderer)((Object)(ExAppListPanel.this.checkable.cb.isSelected() ? new LocaleCheckRenderer() : new LocaleRenderer())));
                createSB.append("builder.setRenderer(" + (ExAppListPanel.this.checkable.cb.isSelected() ? "new LocaleCheckRenderer()" : "new LocaleRenderer()") + ");\n");
            }
        }

        private class LocaleCheckRenderer
        extends GenericCheckListCellRenderer<Locale> {
            private LocaleCheckRenderer() {
            }

            @Override
            public void formatCheckBox(JCheckBox checkBox, JList list, Locale value, int index, boolean isSelected, boolean cellHasFocus) {
                checkBox.setText(value.getDisplayLanguage());
                checkBox.setSelected(ExAppListPanel.this.checkable.checkedItems.contains((Object)value));
            }
        }

        private class LocaleRenderer
        extends LabelListCellRenderer<Locale> {
            private LocaleRenderer() {
            }

            @Override
            public void formatLabel(JLabel label, JList list, Locale value, int index, boolean isSelected, boolean cellHasFocus) {
                label.setText(value.getDisplayLanguage());
            }
        }
    }

    private static enum SELECTION_MODE {
        SINGLE(0),
        RANGE(1),
        MULTIPLE(2);

        int selectionMode;
        private static JComboBox combo;

        private SELECTION_MODE(int selectionMode) {
            this.selectionMode = selectionMode;
        }

        public String toString() {
            switch (this) {
                case SINGLE: {
                    return "Single";
                }
                case RANGE: {
                    return "Range";
                }
                case MULTIPLE: {
                    return "Multiple";
                }
            }
            return super.toString();
        }

        private static void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            SELECTION_MODE mode = (SELECTION_MODE)((Object)combo.getSelectedItem());
            builder.setSelectionMode(mode.selectionMode);
            if (mode == RANGE) {
                createSB.append("builder.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);\n");
            } else if (mode == MULTIPLE) {
                createSB.append("builder.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);\n");
            }
        }

        static {
            combo = new JComboBox<SELECTION_MODE>(SELECTION_MODE.values());
            combo.setToolTipText("The type of selection to allow in the list");
        }
    }

    private static enum MODEL_TYPE {
        NONE,
        ARRAY,
        LIST,
        OBJECT;

        private static JComboBox combo;

        public String toString() {
            switch (this) {
                case NONE: {
                    return "None";
                }
                case ARRAY: {
                    return "String[] (Animals)";
                }
                case LIST: {
                    return "java.util.List<String> (Colors)";
                }
                case OBJECT: {
                    return "Locale[]";
                }
            }
            return super.toString();
        }

        private static void build(ListBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            switch ((MODEL_TYPE)((Object)combo.getSelectedItem())) {
                case NONE: {
                    createSB.append("ListBuilder builder = new ListBuilder();\n");
                    break;
                }
                case ARRAY: {
                    builder.setModel(ANIMALS);
                    createSB.append("ListBuilder<String> builder = new ListBuilder<String>();\n");
                    createSB.append("builder.setModel(array);\n");
                    if (SELECTION_MODE.combo.getSelectedItem() == SELECTION_MODE.SINGLE) {
                        selectSB.append("String animal = builtList.getSelectedValue();");
                        break;
                    }
                    selectSB.append("List<String> animals = builtList.getSelectedValues();");
                    break;
                }
                case LIST: {
                    builder.setModel(Arrays.asList(COLORS));
                    createSB.append("ListBuilder<String> builder = new ListBuilder<String>();\n");
                    createSB.append("builder.setModel(list);\n");
                    if (SELECTION_MODE.combo.getSelectedItem() == SELECTION_MODE.SINGLE) {
                        selectSB.append("String color = builtList.getSelectedValue();");
                        break;
                    }
                    selectSB.append("List<String> colors = builtList.getSelectedValues();");
                    break;
                }
                case OBJECT: {
                    new DateFormatSymbols();
                    Locale[] availableLocales = DateFormatSymbols.getAvailableLocales();
                    builder.setModel(availableLocales);
                    createSB.append("ListBuilder<Locale> builder = new ListBuilder<Locale>();\n");
                    createSB.append("builder.setModel(Locale.getAvailableLocales());\n");
                    if (SELECTION_MODE.combo.getSelectedItem() == SELECTION_MODE.SINGLE) {
                        selectSB.append("Locale locale = builtList.getSelectedValue();");
                        break;
                    }
                    selectSB.append("List<Locale> locale = builtList.getSelectedValues();");
                }
            }
        }

        static {
            combo = new JComboBox<MODEL_TYPE>(MODEL_TYPE.values());
            combo.setSelectedIndex(1);
            combo.setToolTipText("The ListBuilder takes arrays and java.util.Lists to save you writing a ListModel");
        }
    }
}

