/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.builders.BasicBuilder;
import oracle.javatools.ui.builders.BuiltBasic;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.BuiltTableImpl;
import oracle.javatools.ui.table.CheckRowHeader;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.ReflectiveTableCellRenderer;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.ui.table.TableHelper;

public final class TableBuilder<T>
extends BasicBuilder<T> {
    private TableInstructions tableInstructions;

    @Override
    protected BasicBuilder.Instructions createInstructions() {
        this.tableInstructions = new TableInstructions();
        return this.tableInstructions;
    }

    public BuiltTable<T> build() {
        this.validate();
        TableModel model = this.buildModel();
        if (this.tableInstructions.table == null) {
            this.tableInstructions.table = new GenericTable(model);
        } else {
            this.tableInstructions.table.setModel(model);
        }
        final GenericTable table = this.tableInstructions.table;
        this.buildRenders(table);
        BuiltTableImpl builtTableonent = new BuiltTableImpl(table, this.tableInstructions);
        table.setAutoResizeMode(this.tableInstructions.horizontalScrolling ? 0 : 1);
        table.setSelectionMode(this.tableInstructions.selectionMode);
        table.setRowSelectionAllowed(this.tableInstructions.rowSelectionAllowed);
        table.setColumnSelectionAllowed(this.tableInstructions.columnSelectionAllowed);
        if (this.tableInstructions.visibleRows != -1) {
            table.setPreferredVisibleRowCount(this.tableInstructions.visibleRows);
        }
        table.setShowToolTips(this.tableInstructions.showToolTips);
        table.setRolloverHighlightingEnabled(this.tableInstructions.rollover);
        table.setSelectAllEnabled(this.tableInstructions.selectAllAllowed);
        builtTableonent.getEmptyTextLayer().setText(this.tableInstructions.emptyText);
        builtTableonent.getEmptyTextLayer().setFont(this.tableInstructions.emptyTextFont);
        if (this.tableInstructions.doubleClickListener != null) {
            table.addMouseListener(new DoubleClickL(this.tableInstructions.doubleClickListener));
        }
        this.buildToolbar(builtTableonent);
        table.setRowHeader(this.buildRowHeader(table));
        if (!this.tableInstructions.showGrid) {
            table.setShowGrid(false);
            table.setIntercellSpacing(new Dimension(0, 0));
        }
        if (this.tableInstructions.rowSorter != null) {
            table.setRowSorter(this.tableInstructions.rowSorter);
        } else if (this.tableInstructions.sorted) {
            table.setRowSorter(new TableRowSorter<TableModel>(model));
        }
        table.setColumnSelectorAvailable(this.tableInstructions.hiddenColumnsAllowed);
        if (this.tableInstructions.hiddenColumnsAllowed) {
            table.setColumnSelectorAvailable(true);
        }
        if (this.tableInstructions.hiddenColumns != null) {
            table.setHiddenColumns(this.tableInstructions.hiddenColumns);
        }
        if (model instanceof SimpleTableModel && this.tableInstructions.selection != null) {
            for (Object t : this.tableInstructions.selection) {
                int i = ((SimpleTableModel)model).indexOf(t);
                table.getSelectionModel().addSelectionInterval(i, i);
            }
        }
        if (this.tableInstructions.indexSelection != null) {
            for (int i : this.tableInstructions.indexSelection) {
                table.getSelectionModel().addSelectionInterval(i, i);
            }
        }
        if (this.tableInstructions.autoSize) {
            table.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) > 0L && table.isShowing()) {
                        TableHelper.sizeTableToContents(table);
                        table.removeHierarchyListener(this);
                    }
                }
            });
        }
        this.buildSelectionEnabled(table);
        return builtTableonent;
    }

    private TableModel buildModel() {
        if (this.tableInstructions.model != null) {
            return this.tableInstructions.model;
        }
        if (this.tableInstructions.modelList != null) {
            if (this.tableInstructions.columnList.isEmpty()) {
                throw new IllegalStateException("No columns are specified for this model. Call addColumn(..) at least once to add a column");
            }
            SimpleTableModel model = new SimpleTableModel(this.tableInstructions.modelList, new TableFormat(this.tableInstructions.columnList));
            return model;
        }
        return null;
    }

    private void buildRenders(GenericTable table) {
        table.setRolloverHighlightingEnabled(false);
        for (int i = 0; i < this.tableInstructions.columnList.size(); ++i) {
            table.getColumnModel().getColumn(i).setCellRenderer(((Column)this.tableInstructions.columnList.get(i)).renderer);
        }
    }

    private RowHeader buildRowHeader(JTable table) {
        if (this.tableInstructions.checkedItems != null) {
            CheckRowHeader checkRowHeader = new CheckRowHeader(table, this.tableInstructions.checkedItems);
            checkRowHeader.setShowRowNumber(false);
            return checkRowHeader;
        }
        switch (this.tableInstructions.rowheader) {
            case NONE: {
                return null;
            }
            case GAP: {
                return new RowHeader(table);
            }
            case NUMBERS: {
                RowHeader rowHeader = new RowHeader(table);
                rowHeader.setShowRowNumber(true);
                return rowHeader;
            }
        }
        return null;
    }

    @Override
    protected void buildToolbar(BuiltBasic builtBasic) {
        if (this.instructions.titlebar && !this.tableInstructions.defaultActionMap.isEmpty()) {
            ControlBar controlBar = builtBasic.getComponentWithTitlebar().getControlBar();
            for (DefaultAction defaultAction : DefaultAction.values()) {
                if (!this.tableInstructions.defaultActionMap.containsKey((Object)defaultAction)) continue;
                Action action = defaultAction.buildAction((ActionListener)this.tableInstructions.defaultActionMap.get((Object)defaultAction));
                controlBar.add(action);
                if (!defaultAction.isSelectionEnabled()) continue;
                this.setSelectionEnabledAction(action);
            }
        }
        super.buildToolbar(builtBasic);
    }

    private void buildSelectionEnabled(JTable table) {
        if (this.tableInstructions.selectionEnabledComponents.isEmpty() && this.tableInstructions.selectionEnabledActions.isEmpty()) {
            return;
        }
        table.getSelectionModel().addListSelectionListener(new EnabledSelectionL(table, this.tableInstructions.selectionEnabledComponents, this.tableInstructions.selectionEnabledActions));
        boolean currentSelection = table.getSelectedRow() != -1 || table.getSelectedColumn() != -1;
        for (JComponent component : this.tableInstructions.selectionEnabledComponents) {
            component.setEnabled(currentSelection);
        }
        for (Action action : this.tableInstructions.selectionEnabledActions) {
            action.setEnabled(currentSelection);
        }
    }

    private void validate() {
        if (this.tableInstructions.checkedItems != null && this.tableInstructions.rowheader != RowHeaderType.GAP && this.tableInstructions.rowheader != RowHeaderType.NONE) {
            throw new UnsupportedOperationException("TableBuilder does not support checked items and the specified row header");
        }
        if (this.tableInstructions.checkedItems != null && !(this.tableInstructions.model instanceof SimpleTableModel)) {
            throw new UnsupportedOperationException("TableBuilder does not support checked items and table model type. Use SimpleTableModel");
        }
        if (this.tableInstructions.model == null && this.tableInstructions.modelList == null) {
            throw new UnsupportedOperationException("No table model provided");
        }
    }

    public void setModel(TableModel model) {
        this.tableInstructions.model = model;
    }

    public void setModel(List<T> list) {
        this.tableInstructions.modelList = list;
    }

    public void setModel(T[] array) {
        this.tableInstructions.modelList = new ArrayList<T>(Arrays.asList(array));
    }

    public void addColumn(String name, String renderViaMethodName) {
        this.addColumn(name, new ReflectiveTableCellRenderer(renderViaMethodName));
    }

    public void addColumn(String name, TableCellRenderer renderer) {
        renderer = new GenericTableCellRenderer(renderer);
        this.tableInstructions.columnList.add(new Column(name, renderer));
    }

    public void setSelectionIndices(int ... indexes) {
        TableInstructions.access$902(this.tableInstructions, indexes);
    }

    public void setSelectionMode(int selectionMode) {
        this.tableInstructions.selectionMode = selectionMode;
    }

    public void setRowSelectionAllowed(boolean selectionAllowed) {
        this.tableInstructions.rowSelectionAllowed = selectionAllowed;
    }

    public void setAutoSizeColumns(boolean autoSize) {
        this.tableInstructions.autoSize = autoSize;
    }

    public void setSortable(boolean sortable) {
        this.tableInstructions.sorted = sortable;
    }

    public void setSorter(TableRowSorter sorter) {
        this.tableInstructions.rowSorter = sorter;
    }

    public void setColumnSelectionAllowed(boolean selectionAllowed) {
        this.tableInstructions.columnSelectionAllowed = selectionAllowed;
    }

    public void setHiddenColumnsAllowed(boolean isAvailable) {
        this.tableInstructions.hiddenColumnsAllowed = isAvailable;
    }

    public void setHiddenColumns(int ... hiddenColumns) {
        this.tableInstructions.hiddenColumnsAllowed = true;
        TableInstructions.access$802(this.tableInstructions, hiddenColumns);
    }

    public void setShowToolTips(boolean showToolTips) {
        this.tableInstructions.showToolTips = showToolTips;
    }

    public void setShowGrid(boolean showGrid) {
        this.tableInstructions.showGrid = showGrid;
    }

    public void setReorderable(boolean reorderable) {
        this.tableInstructions.reorder = reorderable;
    }

    public void setSelectAllAllowed(boolean selectAllAllowed) {
        this.tableInstructions.selectAllAllowed = selectAllAllowed;
    }

    public void setActionsDefault(DefaultAction defaultAction, ActionListener listener) {
        this.instructions.titlebar = true;
        this.tableInstructions.defaultActionMap.put(defaultAction, listener);
    }

    public void setHorizontalScrolling(boolean horizontalScrolling) {
        this.tableInstructions.horizontalScrolling = horizontalScrolling;
    }

    public void setVisibleRows(int visibleRows) {
        this.tableInstructions.visibleRows = visibleRows;
    }

    public void setRowHeader(RowHeaderType rowHeader) {
        this.tableInstructions.rowheader = rowHeader;
    }

    void setTable(GenericTable table) {
        this.tableInstructions.table = table;
    }

    private static class EnabledSelectionL
    implements ListSelectionListener {
        private JTable table;
        private Collection<JComponent> components;
        private Collection<Action> actions;

        private EnabledSelectionL(JTable table, Collection<JComponent> components, Collection<Action> actions) {
            this.table = table;
            this.components = components;
            this.actions = actions;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean currentSelection = this.table.getSelectedRow() != -1 || this.table.getSelectedColumn() != -1;
            for (JComponent component : this.components) {
                component.setEnabled(currentSelection);
            }
            for (Action action : this.actions) {
                action.setEnabled(currentSelection);
            }
        }
    }

    private final class TableFormat<T>
    implements SimpleTableFormat<T> {
        private List<Column> columns;

        private TableFormat(List<Column> columns) {
            this.columns = columns;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        @Override
        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns.get(columnIndex).name;
        }

        @Override
        public Object getValueAt(T rowValue, int columnIndex) {
            return rowValue;
        }

        @Override
        public void setValueAt(T rowValue, Object value, int columnIndex) {
        }

        @Override
        public boolean isCellEditable(T rowValue, int columnIndex) {
            return false;
        }
    }

    private static final class Column {
        private String name;
        private TableCellRenderer renderer;

        private Column(String name, TableCellRenderer renderer) {
            this.name = name;
            this.renderer = renderer;
        }
    }

    private static class DoubleClickL
    extends MouseAdapter {
        private ActionListener listener;

        private DoubleClickL(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int c;
            int r;
            JTable table;
            if (e.getClickCount() == 2 && (table = (JTable)e.getSource()).getCellRect(r = table.rowAtPoint(e.getPoint()), c = table.columnAtPoint(e.getPoint()), true).contains(e.getPoint())) {
                this.listener.actionPerformed(new ActionEvent(table, 1001, "Double Click"));
            }
        }
    }

    class TableInstructions
    extends BasicBuilder.Instructions {
        int selectionMode = 0;
        boolean rowSelectionAllowed = true;
        boolean columnSelectionAllowed = false;
        TableModel model = null;
        private List<T> modelList = null;
        private List<Column> columnList = new ArrayList<Column>();
        int visibleRows = -1;
        boolean reorder = false;
        boolean horizontalScrolling;
        RowHeaderType rowheader = RowHeaderType.NONE;
        private boolean showToolTips = true;
        private boolean hiddenColumnsAllowed = true;
        private int[] hiddenColumns;
        private boolean selectAllAllowed = true;
        private int[] indexSelection;
        private boolean sorted = true;
        private RowSorter rowSorter = null;
        private boolean autoSize = true;
        private boolean showGrid = false;
        private Map<DefaultAction, ActionListener> defaultActionMap = new HashMap<DefaultAction, ActionListener>();
        private GenericTable table;

        TableInstructions() {
        }

        static /* synthetic */ int[] access$902(TableInstructions x0, int[] x1) {
            x0.indexSelection = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(TableInstructions x0, int[] x1) {
            x0.hiddenColumns = x1;
            return x1;
        }
    }

    public static enum DefaultAction {
        ADD,
        NEW,
        EDIT,
        DELETE,
        REMOVE,
        BROWSE,
        CLEAR;


        protected String getTooltip() {
            switch (this) {
                case ADD: {
                    return UIBundle.get("TOOLBAR_ADD_ACTION_TOOLTIP");
                }
                case DELETE: {
                    return UIBundle.get("TOOLBAR_DELETE_ACTION_TOOLTIP");
                }
                case NEW: {
                    return UIBundle.get("TOOLBAR_NEW_ACTION_TOOLTIP");
                }
                case EDIT: {
                    return UIBundle.get("TOOLBAR_EDIT_ACTION_TOOLTIP");
                }
                case REMOVE: {
                    return UIBundle.get("TOOLBAR_REMOVE_ACTION_TOOLTIP");
                }
                case CLEAR: {
                    return UIBundle.get("TOOLBAR_CLEAR_ACTION_TOOLTIP");
                }
                case BROWSE: {
                    return UIBundle.get("TOOLBAR_BROWSE_ACTION_TOOLTIP");
                }
            }
            return null;
        }

        protected Icon getIcon() {
            switch (this) {
                case ADD: {
                    return OracleIcons.getIcon((String)"add.png");
                }
                case NEW: {
                    return OracleIcons.getIcon((String)"add.png");
                }
                case DELETE: {
                    return OracleIcons.getIcon((String)"delete.png");
                }
                case REMOVE: {
                    return OracleIcons.getIcon((String)"delete.png");
                }
                case BROWSE: {
                    return OracleIcons.getIcon((String)"lov.png");
                }
                case EDIT: {
                    return OracleIcons.getIcon((String)"edit.png");
                }
                case CLEAR: {
                    return OracleIcons.getIcon((String)"clear.png");
                }
            }
            return null;
        }

        protected boolean isSelectionEnabled() {
            switch (this) {
                case DELETE: 
                case EDIT: 
                case REMOVE: {
                    return true;
                }
            }
            return false;
        }

        protected Action buildAction(final ActionListener listener) {
            Action action = null;
            action = listener instanceof Action ? (Action)listener : new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    e = new ActionEvent(e.getSource(), e.getID(), DefaultAction.this.toString());
                    listener.actionPerformed(e);
                }
            };
            action.putValue("ShortDescription", this.getTooltip());
            action.putValue("SmallIcon", this.getIcon());
            return action;
        }
    }

    public static enum RowHeaderType {
        NONE,
        GAP,
        NUMBERS;

    }
}

