/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.util.Collection;
import oracle.javatools.ui.builders.BuiltTextField;
import oracle.javatools.ui.builders.BuiltTextFieldImpl;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.StringCompletionProvider;

public final class TextFieldBuilder {
    private Instructions instructions = new Instructions();

    public BuiltTextField build() {
        if (this.instructions.expands && this.instructions.completionProvider != null) {
            throw new IllegalStateException("This builder currently does not support building text fields that are expandable and also has completions");
        }
        BuiltTextFieldImpl btf = new BuiltTextFieldImpl(this.instructions);
        return btf;
    }

    public void setText(String text) {
        this.instructions.text = text;
    }

    public void setLabel(String label) {
        this.instructions.label = label;
    }

    public void setHint(String hint) {
        this.instructions.hint = hint;
    }

    public void setPrompt(String prompt) {
        this.instructions.prompt = prompt;
    }

    public void setExpands(boolean expands) {
        this.instructions.expands = expands;
    }

    public void setEditable(boolean editable) {
        this.instructions.editable = editable;
    }

    public void setEnabled(boolean enabled) {
        this.instructions.enabled = enabled;
    }

    public void setColumns(int columns) {
        this.instructions.columns = columns;
    }

    public void setCompletion(CompletionProvider completionProvider) {
        this.instructions.completionProvider = completionProvider;
    }

    public void setCompletion(Collection<String> completions) {
        this.instructions.completionProvider = new StringCompletionProvider(completions);
    }

    final class Instructions {
        String prompt;
        String hint;
        boolean expands = false;
        int columns = 20;
        String text = "";
        boolean editable = true;
        boolean enabled = true;
        String label;
        CompletionProvider completionProvider;

        Instructions() {
        }
    }
}

