/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import oracle.javatools.ui.calendar.CalendarDateProvider;
import oracle.javatools.ui.calendar.Day;
import oracle.javatools.ui.calendar.DayComponent;
import oracle.javatools.ui.calendar.MonthComponent;
import oracle.javatools.ui.calendar.TimeDisplayPanel;
import oracle.javatools.ui.calendar.TimeEditPanel;
import oracle.javatools.ui.calendar.YearComponent;

public final class CalendarPanel
extends JPanel {
    public static final String DOUBLE_CLICK_COMMAND = "DOUBLE_CLICK_COMMAND";
    public static final String SELECTION_CHANGED_COMMAND = "SELECTION_CHANGED_COMMAND";
    private transient ArrayList _actionListeners = new ArrayList(2);
    private Calendar _cal;
    private Locale _locale;
    private boolean _showTime;
    private boolean _editTime;
    private DayComponent _dayPanel;
    private MonthComponent _monthPanel;
    private YearComponent _yearPanel;
    private TimeDisplayPanel _timeDisplay;
    private TimeEditPanel _timeEditor;
    private JButton _previousButton;
    private JButton _nextButton;
    private TreeSet<Day> _selectedDays = new TreeSet();

    public CalendarPanel(Locale locale) {
        this._locale = locale;
        this._init();
        this.setSelectedDate(new Date());
    }

    DayComponent getDayPanel() {
        return this._dayPanel;
    }

    private void _init() {
        this._cal = Calendar.getInstance(this._locale);
        this._cal.setTime(new Date());
        this._cal.setMinimalDaysInFirstWeek(1);
        this._createSubcomponents();
        this.setTimeZone(this._cal.getTimeZone());
        this._layoutComponents();
        this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 4, 8, 4)));
        this.setBackground(UIManager.getColor("TextArea.background"));
    }

    private void _createSubcomponents() {
        this._dayPanel = new DayComponent(this._cal, false, this._selectedDays, this._locale);
        this._yearPanel = new YearComponent(this._cal, this._dayPanel);
        this._monthPanel = new MonthComponent(this._cal, this._dayPanel, this._locale);
        this._timeDisplay = new TimeDisplayPanel(this._locale, this._cal);
        this._timeEditor = new TimeEditPanel(this._locale, this);
        this._previousButton = new BasicArrowButton(7);
        this._nextButton = new BasicArrowButton(3);
        this._previousButton.setBackground(UIManager.getColor("TextArea.background"));
        this._nextButton.setBackground(UIManager.getColor("TextArea.background"));
        this._previousButton.setOpaque(false);
        this._nextButton.setOpaque(false);
        this._previousButton.setBorderPainted(false);
        this._previousButton.setAction(null);
        this._nextButton.setBorderPainted(false);
        ArrowButtonListener abl = new ArrowButtonListener();
        this._previousButton.addActionListener(abl);
        this._nextButton.addActionListener(abl);
        DoubleClickListener dcl = new DoubleClickListener();
        this._dayPanel.getTable().getGrid().addMouseListener((MouseListener)dcl);
        this._dayPanel.getTable().getGrid().getGridSelectionManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CalendarPanel.this.fireSelectionAction();
            }
        });
    }

    private void _layoutComponents() {
        this.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        gridbag.setConstraints(this._previousButton, c);
        c.insets = new Insets(4, 2, 4, 2);
        c.ipadx = 2;
        c.anchor = 13;
        gridbag.setConstraints(this._monthPanel, c);
        c.anchor = 17;
        gridbag.setConstraints(this._yearPanel, c);
        c.insets = new Insets(4, 0, 4, 2);
        c.anchor = 10;
        c.ipadx = 0;
        c.gridwidth = 0;
        gridbag.setConstraints(this._nextButton, c);
        this.add(this._previousButton);
        this.add(this._monthPanel);
        this.add(this._yearPanel);
        this.add(this._nextButton);
        gridbag.setConstraints(this._dayPanel, c);
        this.add(this._dayPanel);
        this._dayPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("ComboBox.disabledBackground")));
        if (this._showTime) {
            if (this._editTime) {
                c.insets = new Insets(0, 2, 0, 2);
                gridbag.setConstraints(this._timeEditor, c);
                this.add(this._timeEditor);
            } else {
                c.insets = new Insets(0, 2, 4, 2);
                gridbag.setConstraints(this._timeDisplay, c);
                this.add(this._timeDisplay);
            }
        }
    }

    public Date[] getSelectedDates() {
        Date[] dates = new Date[this._selectedDays.size()];
        Calendar cal = (Calendar)this._cal.clone();
        int i = 0;
        for (Day day : this._selectedDays) {
            Date date = day.getDate();
            if (this._showTime) {
                cal.setTime(date);
                cal.set(11, this._cal.get(11));
                cal.set(12, this._cal.get(12));
                cal.set(13, this._cal.get(13));
                cal.setTimeZone(this._cal.getTimeZone());
                date = cal.getTime();
            }
            dates[i] = date;
            ++i;
        }
        return dates;
    }

    public void setSelectedDate(Date date) {
        this._selectedDays.clear();
        this._selectedDays.add(new Day(date));
        Calendar cal = (Calendar)this._cal.clone();
        cal.setTime(date);
        this._cal.set(11, cal.get(11));
        this._cal.set(12, cal.get(12));
        this._cal.set(13, cal.get(13));
        this._refreshCalendar();
        this.fireSelectionAction();
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone nearestMatchZone = this._timeEditor.getNearestTimeZoneMatch(timeZone);
        this._cal.setTimeZone(nearestMatchZone);
        this._refreshCalendar();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this._dayPanel.setMultiSelect(isMultiSelect);
    }

    public boolean isMultiSelect() {
        return this._dayPanel.isMultiSelect();
    }

    public void setSelectedDates(Date[] dates) {
        this._selectedDays.clear();
        if (!this._dayPanel.isMultiSelect()) {
            this._selectedDays.add(new Day(dates[0]));
        } else {
            for (Date date : dates) {
                this._selectedDays.add(new Day(date));
            }
        }
        Calendar cal = (Calendar)this._cal.clone();
        cal.setTime(dates[0]);
        this._cal.set(11, cal.get(11));
        this._cal.set(12, cal.get(12));
        this._cal.set(13, cal.get(13));
        this._dayPanel.rebuild();
        this.fireSelectionAction();
    }

    public void addSelectedDates(Date[] dates) {
        if (!this._dayPanel.isMultiSelect()) {
            this._selectedDays.clear();
            this._selectedDays.add(new Day(dates[0]));
        } else {
            for (Date date : dates) {
                this._selectedDays.add(new Day(date));
            }
        }
        this._dayPanel.rebuild();
        this.fireSelectionAction();
    }

    public void removeSelectedDates(Date[] dates) {
        for (Date date : dates) {
            this._selectedDays.remove(new Day(date));
        }
        this._dayPanel.rebuild();
        this.fireSelectionAction();
    }

    public Date getVisibleDate() {
        return this._cal.getTime();
    }

    public void makeDateVisible(Date date) {
        Calendar cal = (Calendar)this._cal.clone();
        this._cal.setTime(date);
        this._cal.set(11, cal.get(11));
        this._cal.set(12, cal.get(12));
        this._cal.set(13, cal.get(13));
        this._refreshCalendar();
    }

    private void _refreshCalendar() {
        this._monthPanel.updateDisplay();
        this._yearPanel.updateDisplay();
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._dayPanel.rebuild();
    }

    public void setMinimumDate(Date minimumDate) {
        this._dayPanel.setMinimumDate(minimumDate);
    }

    public Date getMinimumDate() {
        return this._dayPanel.getMinimumDate();
    }

    public void setMaximumDate(Date maximumDate) {
        this._dayPanel.setMaximumDate(maximumDate);
    }

    public Date getMaximumDate() {
        return this._dayPanel.getMaximumDate();
    }

    public void setDateProvider(CalendarDateProvider calDateProvider) {
        this._dayPanel.setDateProvider(calDateProvider);
    }

    public CalendarDateProvider getDateProvider() {
        return this._dayPanel.getDateProvider();
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public void setShowTime(boolean showTime) {
        this._showTime = showTime;
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._layoutComponents();
    }

    public boolean isShowingTime() {
        return this._showTime;
    }

    public void setEditTime(boolean editTime) {
        this._editTime = editTime;
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._layoutComponents();
    }

    public boolean isEditingTime() {
        return this._editTime;
    }

    public void setShowTimeZone(boolean showTimeZone) {
        this._timeDisplay.setShowTimeZone(showTimeZone);
        this._timeEditor.setShowTimeZone(showTimeZone);
    }

    public boolean getShowTimeZone() {
        return this._timeDisplay.getShowTimeZone();
    }

    public void setVisibleDate(boolean visible) {
        this._dayPanel.setVisible(visible);
        this._monthPanel.setVisible(visible);
        this._yearPanel.setVisible(visible);
        this._previousButton.setVisible(visible);
        this._nextButton.setVisible(visible);
    }

    public void setVisibleTime(boolean visible) {
        if (visible && !this._showTime) {
            this.setShowTime(true);
            this.setVisibleTimeZone(false);
        }
        this._timeDisplay.setShowTime(visible);
        this._timeEditor.setShowTime(visible);
    }

    public void setVisibleTimeZone(boolean visible) {
        if (visible && !this._showTime) {
            this.setShowTime(true);
            this.setVisibleTime(false);
        }
        this.setShowTimeZone(visible);
    }

    public TimeZone getNearestTimeZone(TimeZone timeZone) {
        return this._timeEditor.getNearestTimeZone(timeZone);
    }

    public TimeZone getTimeZoneInList(TimeZone timeZone) {
        return this._timeEditor.getNearestTimeZoneMatch(timeZone);
    }

    public void cleanUp() {
        this._dayPanel.cleanUp();
        this._monthPanel.cleanUp();
        this._yearPanel.cleanUp();
        this._actionListeners.clear();
        this._dayPanel = null;
        this._monthPanel = null;
        this._yearPanel = null;
        this._cal = null;
        this._selectedDays.clear();
        this._selectedDays = null;
    }

    Calendar getCalendar() {
        return this._cal;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ArrayList(2);
        }
        this._actionListeners.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this._actionListeners != null) {
            this._actionListeners.remove(listener);
        }
    }

    void fireSelectionAction() {
        this.fireActionPerformed(new ActionEvent(this, 1001, SELECTION_CHANGED_COMMAND));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed(ActionEvent actionEvent) {
        List list;
        CalendarPanel calendarPanel = this;
        synchronized (calendarPanel) {
            if (this._actionListeners == null) {
                return;
            }
            list = (List)this._actionListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((ActionListener)list.get(i)).actionPerformed(actionEvent);
        }
    }

    private class ArrowButtonListener
    implements ActionListener {
        private ArrowButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CalendarPanel.this._previousButton) {
                CalendarPanel.this._cal.add(2, -1);
                CalendarPanel.this._refreshCalendar();
            } else if (e.getSource() == CalendarPanel.this._nextButton) {
                CalendarPanel.this._cal.add(2, 1);
                CalendarPanel.this._refreshCalendar();
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(me)) {
                CalendarPanel.this.fireActionPerformed(new ActionEvent(CalendarPanel.this, 1001, CalendarPanel.DOUBLE_CLICK_COMMAND));
            }
        }
    }
}

