/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import oracle.javatools.ui.calendar.DayComponent;

final class MonthComponent
extends JComboBox
implements ItemListener {
    private DayComponent _dp;
    private Calendar _cal;
    private DateFormatSymbols _dfSymbols;

    public MonthComponent(Calendar cal, DayComponent dp, Locale locale) {
        this._cal = cal;
        this._dp = dp;
        this._dfSymbols = new DateFormatSymbols(locale);
        Integer[] months = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        this.setModel(new DefaultComboBoxModel<Integer>(months));
        this.setRenderer(new MonthRenderer());
        this.addItemListener(this);
        int month = this._cal.get(2);
        this.setSelectedItem(month);
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setOpaque(false);
    }

    public void updateDisplay() {
        this.setSelectedIndex(this._cal.get(2));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this._cal.set(2, (Integer)this.getSelectedItem());
        this._dp.rebuild();
    }

    public void cleanUp() {
        this._dp = null;
        this._cal = null;
    }

    private class MonthRenderer
    extends DefaultListCellRenderer {
        private MonthRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel monthLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Integer) {
                monthLabel.setText(MonthComponent.this._dfSymbols.getMonths()[(Integer)value]);
            }
            return monthLabel;
        }
    }
}

