/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.checktree.TriStateNode;

public class CheckboxTree
extends JTree {
    private static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public CheckboxTree() {
        this._init();
    }

    public CheckboxTree(TreeModel model) {
        super(model);
        this._init();
    }

    @Override
    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    private void _init() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath path = CheckboxTree.this.getSelectionPath();
                if (path != null && e.getKeyCode() == 32 && path.getLastPathComponent() instanceof TriStateNode) {
                    TriStateNode node = (TriStateNode)path.getLastPathComponent();
                    if (node.getNodeState() == TriStateNode.NodeState.YES) {
                        node.setNodeState(TriStateNode.NodeState.NO);
                    } else {
                        node.setNodeState(TriStateNode.NodeState.YES);
                    }
                    CheckboxTree.this.repaint();
                    CheckboxTree.this.fireAccessibleChange(path);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Rectangle pathBounds;
                TreePath path = CheckboxTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && (pathBounds = CheckboxTree.this.getPathBounds(path)).contains(e.getPoint())) {
                    CheckboxCellRenderer renderer = (CheckboxCellRenderer)CheckboxTree.this.getCellRenderer();
                    Rectangle rect = renderer.contentPanel.checkbox.getBounds();
                    rect.translate(pathBounds.x, pathBounds.y);
                    if (!rect.contains(e.getPoint())) {
                        return;
                    }
                    if (path.getLastPathComponent() instanceof TriStateNode) {
                        TriStateNode node = (TriStateNode)path.getLastPathComponent();
                        if (node.getNodeState() == TriStateNode.NodeState.YES) {
                            node.setNodeState(TriStateNode.NodeState.NO);
                        } else {
                            node.setNodeState(TriStateNode.NodeState.YES);
                        }
                        CheckboxTree.this.repaint();
                        CheckboxTree.this.fireAccessibleChange(path);
                    }
                }
            }
        });
        this.setCellRenderer(new CheckboxCellRenderer());
    }

    private void fireAccessibleChange(TreePath path) {
        this.setSelectionPath(null);
        this.setSelectionPath(path);
    }

    private class CheckboxCellRenderer
    implements TreeCellRenderer {
        private ContentPanel contentPanel = new ContentPanel();
        private ContentPanel accessibleContentPanel = new ContentPanel();

        private CheckboxCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ContentPanel c = this.contentPanel;
            if (!SwingUtilities.isEventDispatchThread() && CheckboxTree.this.isShowing()) {
                c = this.accessibleContentPanel;
            }
            this.updateContent(c, tree, value, selected);
            return c.content;
        }

        public void updateContent(ContentPanel content, JTree tree, Object value, boolean selected) {
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                TriStateCheckBox.State oldState = content.checkbox.getState();
                String oldText = content.label.getText();
                if (node.getNodeState() == TriStateNode.NodeState.YES) {
                    content.checkbox.setState(TriStateCheckBox.State.TRUE);
                } else if (node.getNodeState() == TriStateNode.NodeState.NO) {
                    content.checkbox.setState(TriStateCheckBox.State.FALSE);
                } else {
                    content.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                }
                String newText = node.getLabel();
                content.label.setText(newText);
                content.label.setIcon(node.getIcon());
                if (newText != null && newText.equals(oldText) && oldState != content.checkbox.getState()) {
                    this.updateAccessibleName(node.getLabel(), content.checkbox);
                }
            }
            content.label.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : tree.getBackground());
            content.label.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : tree.getForeground());
            content.label.setBorder(selected ? focusBorder : normalBorder);
        }

        private void updateAccessibleName(String text, TriStateCheckBox checkBox) {
            text = checkBox.isSelected() ? text + " " + AccessibleState.CHECKED.toDisplayString() : UIBundle.format("CHECKABLE_COMBO_UNCHECKED", text);
            checkBox.putClientProperty("AccessibleName", text);
        }

        private class ContentPanel {
            private TriStateCheckBox checkbox = new TriStateCheckBox();
            private JLabel label = new JLabel();
            private JPanel content = new CustomAccessibleJPanel();

            ContentPanel() {
                this.checkbox.setFocusable(false);
                this.checkbox.setOpaque(false);
                this.checkbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.label.setFocusable(false);
                this.label.setFont(UIManager.getFont("Tree.font"));
                this.label.setOpaque(true);
                this.content.setLayout(new BorderLayout(1, 0));
                this.content.add((Component)this.checkbox, "Before");
                this.content.add((Component)this.label, "After");
                this.content.setOpaque(false);
                this.label.addPropertyChangeListener("text", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() == null) {
                            return;
                        }
                        CheckboxCellRenderer.this.updateAccessibleName(evt.getNewValue().toString(), ContentPanel.this.checkbox);
                    }
                });
            }

            private class CustomAccessibleJPanel
            extends JPanel {
                private CustomAccessibleJPanel() {
                }

                @Override
                public AccessibleContext getAccessibleContext() {
                    return ContentPanel.this.checkbox.getAccessibleContext();
                }
            }
        }
    }
}

