/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.completion;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionTextComponent;

public class CompletionTextArea
extends JTextArea
implements CompletionTextComponent {
    private final CompletionPopupHandler _popupHandler;

    public CompletionTextArea() {
        this._popupHandler = new TextAreaPopupHandler(this);
    }

    public CompletionTextArea(CompletionPopupHandler popupHandler) {
        this._popupHandler = popupHandler;
    }

    @Override
    public CompletionPopupHandler getPopupHandler() {
        return this._popupHandler;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._popupHandler.setInsightVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        this._popupHandler.acquireInsightLock();
        try {
            super.setText(text);
        }
        finally {
            this._popupHandler.yieldInsightLock();
        }
    }

    private static final class TextAreaPopupHandler
    extends CompletionPopupHandler {
        TextAreaPopupHandler(JTextArea component) {
            super(component);
        }

        @Override
        protected int getVerticalPopupOffset(Component component) {
            JTextArea textArea = (JTextArea)this.getTextComponent();
            int caretPos = textArea.getCaretPosition();
            try {
                Rectangle viewPos = textArea.modelToView(caretPos);
                return viewPos.y + viewPos.height;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return super.getVerticalPopupOffset(component);
            }
        }
    }
}

