/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

public final class GhostBuilder {
    private GhostBuilder() {
    }

    public static GhostBuiltPalette build(EnumSet<Features> features, JComponent content, String title) {
        GhostBuiltPalette gp = GhostBuilder.build(features, content);
        gp.setTitle(title);
        return gp;
    }

    public static GhostBuiltPalette build(EnumSet<Features> features, JComponent content) {
        if (features == null) {
            features = EnumSet.noneOf(Features.class);
        }
        GhostBuiltPalette gp = new GhostBuiltPalette();
        gp.setMinimumSize(new Dimension(80, 60));
        if (features.contains((Object)Features.LOOK_DARK)) {
            gp.setLook(UIConstants.Look.DARK);
        } else {
            gp.setLook(UIConstants.Look.LIGHT);
        }
        gp.setResizable(features.contains((Object)Features.RESIZABLE));
        if (features.contains((Object)Features.HELP_BUTTON)) {
            gp.createHelpButton();
        }
        if (features.contains((Object)Features.GO_BUTTON)) {
            gp.createOKButton();
        }
        gp.setLayout(new BorderLayout(0, 0));
        gp.add((Component)content, "Center");
        gp.pack();
        return gp;
    }

    public static JButton createButton(String text, Icon icon, String name, String command) {
        JButton button = new JButton(icon);
        button.setToolTipText(StringUtils.stripMnemonic((String)text));
        button.setActionCommand(command);
        button.setName(name + " button");
        button.setMargin(new Insets(1, 1, 0, 0));
        return button;
    }

    public static class GhostBuiltPalette
    extends GhostPalette {
        private JButton helpButton;
        private JButton okButton;
        public static final String HELP_ACTION_CMD = "HELP_ACTION_CMD";
        public static final String OK_ACTION_CMD = "OK_ACTION_CMD";
        public static final String CANCEL_ACTION_CMD = "CANCEL_ACTION_CMD";
        private transient ArrayList actionListeners = new ArrayList(2);

        private GhostBuiltPalette() {
        }

        private void createHelpButton() {
            ResourceBundle bundle = ResourceBundle.getBundle("oracle.bali.ewt.resource.JEWTBundle", Locale.getDefault());
            this.helpButton = GhostBuilder.createButton(bundle.getString("HELP"), OracleIcons.getIcon((String)"help.png"), "HELP", HELP_ACTION_CMD);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhostBuiltPalette.this.fireActionPerformed(new ActionEvent(this, 1001, GhostBuiltPalette.HELP_ACTION_CMD));
                }
            });
        }

        private void createOKButton() {
            this.okButton = GhostBuilder.createButton(UIBundle.get("GHOST_WINDOW_OK_BUTTON_TIP"), OracleIcons.getIcon((String)"quick_query.png"), "GO", OK_ACTION_CMD);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhostBuiltPalette.this.fireActionPerformed(new ActionEvent(this, 1001, GhostBuiltPalette.OK_ACTION_CMD));
                }
            });
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            String ENTER_KEY = "ENTER_KEY";
            this.getInputMap(1).put(enter, ENTER_KEY);
            this.getActionMap().put(ENTER_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhostBuiltPalette.this.okButton.doClick();
                }
            });
        }

        public JButton getHelpButton() {
            return this.helpButton;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public synchronized void addActionListener(ActionListener listener) {
            if (this.actionListeners == null) {
                this.actionListeners = new ArrayList(2);
            }
            this.actionListeners.add(listener);
        }

        public synchronized void removeActionListener(ActionListener listener) {
            if (this.actionListeners != null) {
                this.actionListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireActionPerformed(ActionEvent actionEvent) {
            List list;
            GhostBuiltPalette ghostBuiltPalette = this;
            synchronized (ghostBuiltPalette) {
                if (this.actionListeners == null) {
                    return;
                }
                list = (List)this.actionListeners.clone();
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ((ActionListener)list.get(i)).actionPerformed(actionEvent);
            }
        }

        @Override
        protected void closeButtonClicked() {
            super.closeButtonClicked();
            this.fireActionPerformed(new ActionEvent(this, 1001, CANCEL_ACTION_CMD));
        }
    }

    public static enum Features {
        LOOK_LIGHT,
        LOOK_DARK,
        RESIZABLE,
        HELP_BUTTON,
        GO_BUTTON;

    }
}

