/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.ui.border.PointingBorder;
import oracle.javatools.ui.infotip.InfoTipComponent;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipRectangle;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Closeable;
import oracle.javatools.ui.infotip.templates.Template;

public final class InfoTip {
    private final InfoTipComponent infoTipComponent;
    private final int LAYER_Z_INDEX = new Integer(JLayeredPane.POPUP_LAYER - 3);
    private Rectangle location;
    private InfoTipRectangle infoTipRectangle;
    private InfoTipOrientation orientation = InfoTipOrientation.BOTTOM_TOP;
    private JComponent parent;
    private boolean showBounds;
    private Point parentOrigin;
    private final AncestorL ancestorL = new AncestorL();
    private final CloseListener closeL = new CloseListener();
    private Template template;
    private List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            InfoTip.this.hide();
        }
    });
    public static final String PROPERTY_VISIBLE = "visible";
    private int displayTime;
    public static final int DISPLAY_TIME_ACTION_SUCCESS = 15000;
    public static final int DISPLAY_TIME_ACTION_FAILURE = 20000;
    public static final int DISPLAY_TIME_OPTIONAL_USER_TASK = 25000;

    public InfoTip() {
        this.timer.setRepeats(false);
        this.displayTime = -1;
        this.infoTipComponent = new InfoTipComponent(this.orientation.getPrimaryDirection(), InfoTipStyles.DEFAULT);
    }

    public InfoTip(Template template) {
        this.timer.setRepeats(false);
        this.displayTime = -1;
        this.infoTipComponent = new InfoTipComponent(this.orientation.getPrimaryDirection(), InfoTipStyles.DEFAULT);
        this.setContent(template);
    }

    public InfoTip(Template template, InfoTipStyles style) {
        this.timer.setRepeats(false);
        this.displayTime = -1;
        this.infoTipComponent = new InfoTipComponent(this.orientation.getPrimaryDirection(), style);
        this.setContent(template);
    }

    public void setContent(Template template) {
        this.template = template;
        this.infoTipComponent.removeAll();
        if (template != null) {
            this.infoTipComponent.add(template.getContent());
        }
    }

    public InfoTipOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(InfoTipOrientation orientation) {
        this.orientation = orientation;
        this.infoTipComponent.setDirection(orientation.getPrimaryDirection());
        if (this.infoTipComponent.isShowing()) {
            this.ensureVisible();
        }
    }

    public void setShowBounds(boolean showBounds) {
        this.showBounds = showBounds;
    }

    public boolean isShowBounds() {
        return this.showBounds;
    }

    public void setLocation(Rectangle location) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.parent == null) {
            throw new IllegalStateException("InfoTip must have a parent component");
        }
        if (location == null) {
            throw new IllegalArgumentException("InfoTip must have a location");
        }
        JLayeredPane lp = this.getLayeredPane();
        this.location = SwingUtilities.convertRectangle(this.parent, location, lp);
        this.ensureVisible();
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.infoTipComponent.getBounds();
        Rectangle parentBounds = SwingUtilities.convertRectangle(this.getLayeredPane(), bounds, this.parent);
        return parentBounds;
    }

    public void show(JComponent component, Point location) {
        this.show(component, new Rectangle(location));
    }

    public void show(JComponent component) {
        Rectangle r = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        this.show(component, r);
    }

    public boolean isShowing() {
        return this.infoTipComponent != null && this.infoTipComponent.isShowing();
    }

    public void show(JComponent component, Rectangle location) {
        assert (SwingUtilities.isEventDispatchThread());
        if (component == null) {
            throw new IllegalStateException("Attempt to show an InfoTip with no parent component");
        }
        if (location == null) {
            throw new IllegalStateException("Attempt to show an InfoTip with no location");
        }
        this.parent = component;
        this.parentOrigin = this.parent.getLocationOnScreen();
        JLayeredPane lp = this.getLayeredPane();
        lp.add(this.infoTipComponent, this.LAYER_Z_INDEX, -1);
        this.setLocation(location);
        if (this.showBounds) {
            this.infoTipRectangle = new InfoTipRectangle(lp, this.location);
        }
        this.parent.addAncestorListener(this.ancestorL);
        if (this.template instanceof Closeable) {
            ((Closeable)((Object)this.template)).addActionListener(this.closeL);
        }
        if (this.displayTime > 0) {
            this.timer.setInitialDelay(this.displayTime);
            this.timer.start();
        }
        this.firePropertyChange(PROPERTY_VISIBLE, Boolean.FALSE, Boolean.TRUE);
    }

    private JLayeredPane getLayeredPane() {
        Window w = SwingUtilities.getWindowAncestor(this.parent);
        if (w == null) {
            throw new IllegalStateException("InfoTip's parent not in a window");
        }
        if (!(w instanceof RootPaneContainer)) {
            throw new IllegalStateException("Parent's window does not implement RootPaneContainer");
        }
        JLayeredPane lp = ((RootPaneContainer)((Object)w)).getLayeredPane();
        return lp;
    }

    private void pack() {
        this.infoTipComponent.setSize(this.infoTipComponent.getPreferredSize());
        this.infoTipComponent.revalidate();
        this.infoTipComponent.repaint();
        int y = this.location.y;
        int x = this.location.x;
        switch (this.infoTipComponent.getDirection()) {
            case UP: {
                x = this.location.x - this.infoTipComponent.getWidth() / 2 + (int)(this.location.getWidth() / 2.0);
                y = this.location.y + this.location.height;
                break;
            }
            case DOWN: {
                x = this.location.x - this.infoTipComponent.getWidth() / 2 + (int)(this.location.getWidth() / 2.0);
                y = this.location.y - this.infoTipComponent.getHeight();
                break;
            }
            case LEFT: {
                x = this.location.x + this.location.width;
                y = this.location.y - this.infoTipComponent.getHeight() / 2 + (int)(this.location.getHeight() / 2.0);
                break;
            }
            case RIGHT: {
                x = this.location.x - this.infoTipComponent.getWidth();
                y = this.location.y - this.infoTipComponent.getHeight() / 2 + (int)(this.location.getHeight() / 2.0);
            }
        }
        this.infoTipComponent.setLocation(x, y);
    }

    public void ensureVisible() {
        Container parent = this.infoTipComponent.getParent();
        if (parent == null) {
            return;
        }
        this.infoTipComponent.setDirection(this.orientation.getPrimaryDirection());
        this.pack();
        if (this.orientation.isVertical()) {
            if (this.infoTipComponent.getY() < 0 || this.infoTipComponent.getY() + this.infoTipComponent.getHeight() > parent.getHeight()) {
                this.infoTipComponent.setDirection(this.orientation.getSecondaryDirection());
                this.pack();
            }
            if (this.infoTipComponent.getX() < 0) {
                this.infoTipComponent.setXOffset(this.infoTipComponent.getX());
                this.infoTipComponent.setLocation(0, this.infoTipComponent.getY());
            } else if (this.infoTipComponent.getX() + this.infoTipComponent.getWidth() > parent.getWidth()) {
                this.infoTipComponent.setXOffset(this.infoTipComponent.getX() + this.infoTipComponent.getWidth() - parent.getWidth());
                this.infoTipComponent.setLocation(parent.getWidth() - this.infoTipComponent.getWidth(), this.infoTipComponent.getY());
            } else {
                this.infoTipComponent.setXOffset(0);
            }
        } else {
            if (this.orientation.getPrimaryDirection() == PointingBorder.Direction.RIGHT && this.infoTipComponent.getX() < 0) {
                int potentialRightExtent = this.location.x + this.location.width + this.infoTipComponent.getWidth();
                if (potentialRightExtent < parent.getWidth()) {
                    this.infoTipComponent.setDirection(PointingBorder.Direction.LEFT);
                    this.pack();
                } else if (parent.getWidth() - this.location.x - this.location.width > this.location.x) {
                    this.infoTipComponent.setDirection(PointingBorder.Direction.LEFT);
                    this.pack();
                }
            }
            if (this.orientation.getPrimaryDirection() == PointingBorder.Direction.LEFT && this.infoTipComponent.getX() + this.infoTipComponent.getWidth() > parent.getWidth()) {
                int potentialLeftExtent = this.location.x - this.infoTipComponent.getWidth();
                if (potentialLeftExtent >= 0) {
                    this.infoTipComponent.setDirection(PointingBorder.Direction.RIGHT);
                    this.pack();
                } else if (parent.getWidth() - this.location.x - this.location.width < this.location.x) {
                    this.infoTipComponent.setDirection(PointingBorder.Direction.RIGHT);
                    this.pack();
                }
            }
            if (this.infoTipComponent.getY() < 0) {
                this.infoTipComponent.setYOffset(this.infoTipComponent.getY());
                this.infoTipComponent.setLocation(this.infoTipComponent.getX(), 0);
            } else if (this.infoTipComponent.getY() + this.infoTipComponent.getHeight() > parent.getHeight()) {
                this.infoTipComponent.setYOffset(this.infoTipComponent.getY() + this.infoTipComponent.getHeight() - parent.getHeight());
                this.infoTipComponent.setLocation(this.infoTipComponent.getX(), parent.getHeight() - this.infoTipComponent.getHeight());
            } else {
                this.infoTipComponent.setYOffset(0);
            }
        }
    }

    public void hide() {
        assert (SwingUtilities.isEventDispatchThread());
        JComponent lp = (JComponent)this.infoTipComponent.getParent();
        if (lp != null) {
            lp.remove(this.infoTipComponent);
            lp.repaint();
        }
        if (this.parent != null) {
            this.parent.removeAncestorListener(this.ancestorL);
            this.parent = null;
        }
        if (this.infoTipRectangle != null) {
            this.infoTipRectangle.hide();
            this.infoTipRectangle = null;
        }
        if (this.template instanceof Closeable) {
            ((Closeable)((Object)this.template)).removeActionListener(this.closeL);
        }
        this.firePropertyChange(PROPERTY_VISIBLE, Boolean.TRUE, Boolean.FALSE);
    }

    JComponent getInfoTipComponent() {
        return this.infoTipComponent;
    }

    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
        if (this.timer.isRunning()) {
            if (displayTime < 0) {
                this.timer.stop();
            } else {
                this.timer.setInitialDelay(displayTime);
                this.timer.restart();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, property, oldValue, newValue);
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(pce);
        }
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("closeActionCommand".equals(e.getActionCommand())) {
                InfoTip.this.hide();
            }
        }
    }

    private class AncestorL
    implements AncestorListener {
        private AncestorL() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            InfoTip.this.hide();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            if (InfoTip.this.parent == null) {
                return;
            }
            if (!InfoTip.this.parent.isShowing()) {
                InfoTip.this.hide();
                return;
            }
            Point newParentOrigin = InfoTip.this.parent.getLocationOnScreen();
            if (!(event.getAncestor() instanceof Window)) {
                int newX = ((InfoTip)InfoTip.this).parentOrigin.x - newParentOrigin.x;
                int newY = ((InfoTip)InfoTip.this).parentOrigin.y - newParentOrigin.y;
                ((InfoTip)InfoTip.this).location.x -= newX;
                ((InfoTip)InfoTip.this).location.y -= newY;
            }
            InfoTip.this.parentOrigin = newParentOrigin;
            InfoTip.this.ensureVisible();
        }
    }
}

