/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import oracle.javatools.ui.border.PointingBorder;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.themes.LinearGradientPainter;

class InfoTipComponent
extends JPanel {
    private final PointingBorder pointingBorder;
    InfoTipStyles style;

    InfoTipComponent(PointingBorder.Direction direction, InfoTipStyles style) {
        this.style = style;
        this.pointingBorder = new GradientPointingBorder(direction);
        this.setLayout(new BorderLayout());
        Insets insets = style.getBorderInsets();
        CompoundBorder border = BorderFactory.createCompoundBorder(this.pointingBorder, BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.setBorder(border);
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.addMouseListener(new MouseAdapter(){});
    }

    void setDirection(PointingBorder.Direction direction) {
        this.pointingBorder.setDirection(direction);
        this.repaint();
    }

    PointingBorder.Direction getDirection() {
        return this.pointingBorder.getDirection();
    }

    void setXOffset(int offset) {
        this.pointingBorder.setXOffset(offset);
    }

    void setYOffset(int offset) {
        this.pointingBorder.setYOffset(offset);
    }

    private class GradientPointingBorder
    extends PointingBorder {
        public GradientPointingBorder(PointingBorder.Direction direction) {
            super(direction);
            this.setBorderColor(InfoTipComponent.this.style.getBackgroundBorderColor());
            this.setPointSize(25, 13);
        }

        @Override
        protected void paintBackground(Graphics2D g2, Component c, Shape s) {
            LinearGradientPainter backgroundPainter = InfoTipComponent.this.style.getBackgroundPainter();
            backgroundPainter.paint(g2, s);
        }
    }
}

