/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Template;

public class InfoTipHover
implements Hover {
    private final HoverFlavor flavor;
    private final InfoTip infoTip;
    private Rectangle location;
    private final JComponent parent;
    private List<HoverListener> hoverListeners = new CopyOnWriteArrayList<HoverListener>();
    private boolean showing = false;
    private AutoHideMouseListener autoHideMouseListener = new AutoHideMouseListener();
    private boolean isPointOutsideHoverAllowed = false;

    public InfoTipHover(Template template, InfoTipStyles style, JComponent parent, Point location, HoverFlavor flavor) {
        this(template, style, parent, new Rectangle(location), flavor);
    }

    public InfoTipHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location, HoverFlavor flavor) {
        this.flavor = flavor;
        this.location = location;
        this.parent = parent;
        this.infoTip = new InfoTip(template, style);
    }

    public void setContent(Template template) {
        this.infoTip.setContent(template);
    }

    public InfoTip getInfoTip() {
        return this.infoTip;
    }

    public void showHover() {
        if (this.showing) {
            return;
        }
        this.infoTip.show(this.parent, this.location);
        this.showing = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.autoHideMouseListener, 32L);
        this.parent.addMouseListener(this.autoHideMouseListener);
    }

    public void hideHover() {
        if (!this.showing) {
            return;
        }
        this.infoTip.hide();
        this.showing = false;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoHideMouseListener);
        this.parent.removeMouseListener(this.autoHideMouseListener);
        HoverEvent hideEvent = HoverEvent.createHiddenHoverEvent();
        for (HoverListener listener : this.hoverListeners) {
            listener.hoverChange(hideEvent);
        }
    }

    public HoverFlavor getFlavor() {
        return this.flavor;
    }

    public void addHoverListener(HoverListener hoverListener) {
        if (!this.hoverListeners.contains(hoverListener)) {
            this.hoverListeners.add(hoverListener);
        }
    }

    public void removeHoverListener(HoverListener hoverListener) {
        this.hoverListeners.remove(hoverListener);
    }

    public boolean isPointWithinHover(Point p) {
        JComponent comp = this.infoTip.getInfoTipComponent();
        Rectangle r = comp.getBounds();
        Point compP = comp.getLocation();
        Container cp = comp.getParent();
        if (cp == null) {
            return false;
        }
        SwingUtilities.convertPointToScreen(compP, cp);
        r.setLocation(compP);
        r.grow(6, 6);
        Rectangle locationR = new Rectangle(this.location);
        Point lP = locationR.getLocation();
        SwingUtilities.convertPointToScreen(lP, this.parent);
        locationR.x = lP.x;
        locationR.y = lP.y;
        locationR.grow(3, 3);
        Area a = new Area(r);
        a.add(new Area(locationR));
        if (a.contains(p)) {
            this.isPointOutsideHoverAllowed = false;
            return true;
        }
        return this.isPointOutsideHoverAllowed;
    }

    public boolean shouldHideHover(KeyEvent event) {
        return true;
    }

    public InfoTipOrientation getOrientation() {
        return this.infoTip.getOrientation();
    }

    public void setOrientation(InfoTipOrientation orientation) {
        this.infoTip.setOrientation(orientation);
    }

    public void ensureVisible() {
        this.infoTip.ensureVisible();
        PointerInfo pi = MouseInfo.getPointerInfo();
        if (pi == null) {
            return;
        }
        GraphicsDevice device = pi.getDevice();
        if (device == null) {
            return;
        }
        if (device != this.infoTip.getInfoTipComponent().getGraphicsConfiguration().getDevice()) {
            return;
        }
        Point mouseLoc = pi.getLocation();
        if (mouseLoc == null) {
            return;
        }
        if (!this.isPointWithinHover(mouseLoc)) {
            this.isPointOutsideHoverAllowed = true;
        }
    }

    public void setLocation(Rectangle location) {
        this.location = location;
        this.infoTip.setLocation(location);
    }

    public Rectangle getLocation() {
        return this.location;
    }

    private class AutoHideMouseListener
    extends MouseAdapter
    implements AWTEventListener {
        private AutoHideMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo == null) {
                    InfoTipHover.this.hideHover();
                    return;
                }
                Point p = pointerInfo.getLocation();
                if (p == null) {
                    InfoTipHover.this.hideHover();
                    return;
                }
                if (InfoTipHover.this.isPointWithinHover(p)) {
                    return;
                }
                InfoTipHover.this.hideHover();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            InfoTipHover.this.hideHover();
        }
    }
}

