/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.UIManager;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.themes.LinearGradientPainter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

final class InfoTipUIConstants {
    private static boolean isFusionBlue;
    static final LinearGradientPainter CODE_BACKGROUND_PAINTER;
    static final LinearGradientPainter DEFAULT_BACKGROUND_PAINTER;
    static final Color BACKGROUND_BORDER_COLOR;
    static final Color INTERNAL_BORDER_COLOR;
    static final Color SEPARATOR_PRIMARY_COLOR;
    static final Color SEPARATOR_SECONDARY_COLOR;
    static final int CODE_ICON_HEIGHT = 12;
    static final int POINT_WIDTH = 25;
    static final int POINT_HEIGHT = 13;
    static final Insets CODE_INSETS;
    static final Insets DEFAULT_INSETS;
    static final Insets CODE_TITLE_INSETS;
    static final Insets DEFAULT_TITLE_INSETS;
    static final Color CONTENT_TEXT_COLOR;
    static final Color ITEM_TEXT_COLOR;
    static final Color MORE_TEXT_COLOR;
    static final Color HYPERLINK_TEXT_COLOR;
    static final Color HYPERLINK_TEXT_HOVER_COLOR;
    static final Font DEFAULT_ITEM_TITLE_FONT;
    static final Font CODE_ITEM_TITLE_FONT;

    private InfoTipUIConstants() {
    }

    static {
        Theme theme;
        isFusionBlue = false;
        if (Themes.isThemed() && "fusionblue".equals((theme = Themes.getActiveTheme()).getId())) {
            isFusionBlue = true;
        }
        float[] fractions = new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f};
        Color[] colors = new Color[]{new Color(240, 247, 255, 178), new Color(240, 247, 255, 242), new Color(240, 247, 255, 255), new Color(240, 247, 255, 242), new Color(240, 247, 255, 178)};
        CODE_BACKGROUND_PAINTER = isFusionBlue ? new LinearGradientPainter(fractions, colors, 1) : new LinearGradientPainter(UIManager.getColor("Label.background"), UIManager.getColor("Label.background"), 1);
        fractions = new float[]{0.0f, 1.0f};
        colors = new Color[]{new Color(198, 217, 236), new Color(239, 247, 255)};
        DEFAULT_BACKGROUND_PAINTER = isFusionBlue ? new LinearGradientPainter(fractions, colors, 1) : new LinearGradientPainter(UIManager.getColor("Label.background"), UIManager.getColor("Label.background"), 1);
        BACKGROUND_BORDER_COLOR = isFusionBlue ? new Color(151, 171, 198) : new Color(120, 120, 120);
        INTERNAL_BORDER_COLOR = isFusionBlue ? new Color(203, 210, 220) : UIManager.getColor("InternalFrame.borderColor");
        SEPARATOR_PRIMARY_COLOR = isFusionBlue ? new Color(198, 217, 236) : UIManager.getColor("InternalFrame.borderDarkShadow");
        SEPARATOR_SECONDARY_COLOR = isFusionBlue ? new Color(255, 255, 255) : UIManager.getColor("InternalFrame.borderShadow");
        CODE_INSETS = new Insets(9, 6, 6, 9);
        DEFAULT_INSETS = new Insets(6, 4, 5, 5);
        CODE_TITLE_INSETS = new Insets(0, 0, 2, 0);
        DEFAULT_TITLE_INSETS = new Insets(0, 0, 6, 0);
        CONTENT_TEXT_COLOR = Color.BLACK;
        ITEM_TEXT_COLOR = Color.BLACK;
        MORE_TEXT_COLOR = Colors.HYPERLINK;
        HYPERLINK_TEXT_COLOR = Colors.HYPERLINK;
        HYPERLINK_TEXT_HOVER_COLOR = Colors.HYPERLINK_HOVER;
        DEFAULT_ITEM_TITLE_FONT = UIManager.getFont("Label.font").deriveFont(1);
        CODE_ITEM_TITLE_FONT = UIManager.getFont("Label.font");
    }
}

