/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.infotip.InfoTipSeparator;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public final class MultiItemTemplate
implements Template {
    private static int MAX_VISIBLE_ROWS = 16;
    private List<SingleItemTemplate> singleItemTemplates = new ArrayList<SingleItemTemplate>();

    public MultiItemTemplate(List<SingleItemTemplate> singleItemTemplates) {
        this.singleItemTemplates = singleItemTemplates;
    }

    @Override
    public JComponent getContent() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("flowy, fill, ins 1, gap 0"));
        panel.setOpaque(false);
        for (SingleItemTemplate template : this.singleItemTemplates) {
            if (panel.getComponentCount() != 0) {
                panel.add((Component)new InfoTipSeparator(), "growx, growy 0, h 3, gapy 6");
            }
            panel.add((Component)template.getContent(), "grow, w 100%");
        }
        this.doSizing();
        return panel;
    }

    private void doSizing() {
        int width = 0;
        for (SingleItemTemplate singleTemplate : this.singleItemTemplates) {
            int labelWidth = singleTemplate.getTitle().getPreferredSize().width;
            width = Math.max(labelWidth, width);
        }
        width = Math.max(width, 400);
        for (SingleItemTemplate singleTemplate : this.singleItemTemplates) {
            JTextArea desc = singleTemplate.getDesc();
            desc.setSize(width, 99999999);
            Dimension prefSize = ((JComponent)desc).getPreferredSize();
            desc.setPreferredSize(prefSize);
            int rowHeight = desc.getFontMetrics(desc.getFont()).getHeight();
            JScrollPane sp = singleTemplate.getSp();
            int height = Math.min(rowHeight * MAX_VISIBLE_ROWS, ((JComponent)desc).getPreferredSize().height);
            Insets insets = sp.getInsets();
            sp.setPreferredSize(new Dimension(width, height + insets.top + insets.bottom));
        }
    }
}

